/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;

public final class AxisLocation
implements Serializable {
    public static final AxisLocation TOP_OR_LEFT = new AxisLocation("AxisLocation.TOP_OR_LEFT");
    public static final AxisLocation TOP_OR_RIGHT = new AxisLocation("AxisLocation.TOP_OR_RIGHT");
    public static final AxisLocation BOTTOM_OR_LEFT = new AxisLocation("AxisLocation.BOTTOM_OR_LEFT");
    public static final AxisLocation BOTTOM_OR_RIGHT = new AxisLocation("AxisLocation.BOTTOM_OR_RIGHT");
    private String name;

    private AxisLocation(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AxisLocation)) {
            return false;
        }
        AxisLocation location = (AxisLocation)obj;
        return this.name.equals(location.toString());
    }

    public static AxisLocation getOpposite(AxisLocation location) {
        if (location == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        AxisLocation result = null;
        if (location == TOP_OR_LEFT) {
            result = BOTTOM_OR_RIGHT;
        } else if (location == TOP_OR_RIGHT) {
            result = BOTTOM_OR_LEFT;
        } else if (location == BOTTOM_OR_LEFT) {
            result = TOP_OR_RIGHT;
        } else if (location == BOTTOM_OR_RIGHT) {
            result = TOP_OR_LEFT;
        } else {
            throw new IllegalStateException("AxisLocation not recognised.");
        }
        return result;
    }
}

