/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.energyskatepark.AbstractEnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkControlPanel;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PieChartControlPanel
extends HorizontalLayoutPanel {
    private final AbstractEnergySkateParkModule module;
    private final EnergySkateParkControlPanel energySkateParkControlPanel;
    private final JCheckBox showThermal;
    private final JCheckBox showPieChartCheckBox;

    public PieChartControlPanel(final AbstractEnergySkateParkModule abstractEnergySkateParkModule, EnergySkateParkControlPanel energySkateParkControlPanel) {
        this.module = abstractEnergySkateParkModule;
        this.energySkateParkControlPanel = energySkateParkControlPanel;
        this.showPieChartCheckBox = new JCheckBox(EnergySkateParkResources.getString("piechart.show"), (boolean)((Boolean)abstractEnergySkateParkModule.pieChartVisible.get()));
        this.showPieChartCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PieChartControlPanel.this.updateShowThermalEnabled();
                abstractEnergySkateParkModule.pieChartVisible.set(PieChartControlPanel.this.showPieChartCheckBox.isSelected());
            }
        });
        this.add(this.showPieChartCheckBox);
        final boolean bl = !abstractEnergySkateParkModule.getEnergySkateParkSimulationPanel().getRootNode().getIgnoreThermal();
        this.showThermal = new JCheckBox(EnergySkateParkResources.getString("piechart.show-thermal"), bl);
        this.showThermal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                abstractEnergySkateParkModule.getEnergySkateParkSimulationPanel().setIgnoreThermal(!PieChartControlPanel.this.showThermal.isSelected());
            }
        });
        abstractEnergySkateParkModule.getEnergySkateParkSimulationPanel().addListener(new EnergySkateParkSimulationPanel.Adapter(){

            public void ignoreThermalChanged() {
                PieChartControlPanel.this.showThermal.setSelected(!abstractEnergySkateParkModule.getEnergySkateParkSimulationPanel().getIgnoreThermal());
            }
        });
        this.add(this.showThermal);
        abstractEnergySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void primaryBodyChanged() {
                PieChartControlPanel.this.update();
            }
        });
        abstractEnergySkateParkModule.getEnergySkateParkSimulationPanel().addListener(new EnergySkateParkSimulationPanel.Adapter(){});
        this.setAnchor(17);
        this.updateShowThermalEnabled();
        this.showPieChartCheckBox.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PieChartControlPanel.this.updateShowThermalEnabled();
            }
        });
        this.showPieChartCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PieChartControlPanel.this.updateShowThermalEnabled();
            }
        });
        abstractEnergySkateParkModule.addResetListener(new VoidFunction0(){

            public void apply() {
                PieChartControlPanel.this.showPieChartCheckBox.setSelected(false);
                PieChartControlPanel.this.showThermal.setSelected(bl);
            }
        });
    }

    private void updateShowThermalEnabled() {
        this.showThermal.setEnabled(this.showPieChartCheckBox.isEnabled() && this.showPieChartCheckBox.isSelected());
    }

    private void update() {
        EnergySkateParkModel energySkateParkModel = this.module.getEnergySkateParkModel();
        boolean bl = energySkateParkModel.getNumBodies() > 0 && energySkateParkModel.getBody(0).getPotentialEnergy() >= 0.0;
        this.showPieChartCheckBox.setEnabled(bl);
    }
}

