/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.energyskatepark.AbstractEnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GravitySlider
extends LinearValueControl {
    private final AbstractEnergySkateParkModule module;

    public GravitySlider(final AbstractEnergySkateParkModule abstractEnergySkateParkModule) {
        super(0.0, 30.0, EnergySkateParkResources.getString("controls.gravity"), "0.00", EnergySkateParkResources.getString("units.accel"));
        this.module = abstractEnergySkateParkModule;
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        hashtable.put(new Double(0.0), new JLabel(EnergySkateParkResources.getString("location.space")));
        hashtable.put(new Double(9.81), new JLabel(EnergySkateParkResources.getString("location.earth")));
        hashtable.put(new Double(25.95), new JLabel(EnergySkateParkResources.getString("location.jupiter")));
        this.setMajorTickSpacing(10.0);
        this.setMinorTickSpacing(5.0);
        this.setTickLabels(hashtable);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                abstractEnergySkateParkModule.getEnergySkateParkModel().setGravity(-GravitySlider.this.getValue());
            }
        });
        abstractEnergySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void gravityChanged() {
                GravitySlider.this.update();
            }
        });
        this.setFocusable(false);
        this.getSlider().setFocusable(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.update();
    }

    private void update() {
        this.setValue(Math.abs(this.module.getEnergySkateParkModel().getGravity()));
    }
}

