/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.energyskatepark.EnergySkateParkApplication;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.serialization.EnergySkateParkIO;
import edu.colorado.phet.energyskatepark.view.swing.EnergySkateParkTestMenu;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class EnergySkateParkTrackMenu
extends JMenu {
    public EnergySkateParkTrackMenu(EnergySkateParkApplication energySkateParkApplication) {
        this(EnergySkateParkResources.getString("tracks-menu.title"), energySkateParkApplication, EnergySkateParkTrackMenu.getTests());
    }

    public EnergySkateParkTrackMenu(String string, final EnergySkateParkApplication energySkateParkApplication, EnergySkateParkTestMenu.TestItem[] testItemArray) {
        super(string);
        for (final EnergySkateParkTestMenu.TestItem testItem : testItemArray) {
            this.add(new JMenuItem(new AbstractAction(testItem.getTitle()){

                public void actionPerformed(ActionEvent actionEvent) {
                    EnergySkateParkIO.open(testItem.getLocation(), energySkateParkApplication.getModule());
                }
            }));
        }
    }

    private static EnergySkateParkTestMenu.TestItem[] getTests() {
        return new EnergySkateParkTestMenu.TestItem[]{EnergySkateParkTestMenu.TestItem.getTestItemForKey("energy-skate-park/tests/loop.esp", "tracks-menu.item.loop"), EnergySkateParkTestMenu.TestItem.getTestItemForKey("energy-skate-park/tests/double-well.esp", "tracks-menu.item.double-well"), EnergySkateParkTestMenu.TestItem.getTestItemForKey("energy-skate-park/tests/double-well-rc.esp", "tracks-menu.item.double-well-roller-coaster"), EnergySkateParkTestMenu.TestItem.getTestItemForKey("energy-skate-park/tests/fallthrough_test.esp", "tracks-menu.item.friction-parabola"), EnergySkateParkTestMenu.TestItem.getTestItemForKey("energy-skate-park/tests/jump.esp", "tracks-menu.item.jump"), EnergySkateParkTestMenu.TestItem.getTestItemForKey("energy-skate-park/tests/strack4.esp", "tracks-menu.item.s-curve")};
    }
}

