/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.common.phetcommon.view.AdvancedPanel;
import edu.colorado.phet.energyskatepark.AbstractEnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.view.swing.EnergySkateParkSlider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditSkaterPanel
extends AdvancedPanel {
    private final AbstractEnergySkateParkModule module;

    public EditSkaterPanel(final AbstractEnergySkateParkModule abstractEnergySkateParkModule) {
        super(EnergySkateParkResources.getString("controls.edit-skater") + " >>", EnergySkateParkResources.getString("controls.hide-skater-properties") + " <<");
        this.module = abstractEnergySkateParkModule;
        final EnergySkateParkSlider energySkateParkSlider = new EnergySkateParkSlider(EnergySkateParkResources.getString("controls.mass"), EnergySkateParkResources.getString("units.kg"), 0.2, 200.0, 75.0);
        energySkateParkSlider.setModelTicks(new double[]{0.2, 75.0, 200.0});
        energySkateParkSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                EditSkaterPanel.this.setMass(energySkateParkSlider.getValue());
            }
        });
        JButton jButton = new JButton(EnergySkateParkResources.getString("controls.skater.restore-defaults"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditSkaterPanel.this.restoreDefaults();
            }
        });
        final JCheckBox jCheckBox = new JCheckBox("Frictionless Landing", this.isKeepEnergyOnLanding());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < abstractEnergySkateParkModule.getEnergySkateParkModel().getNumBodies(); ++i) {
                    abstractEnergySkateParkModule.getEnergySkateParkModel().getBody(i).setKeepEnergyOnLanding(jCheckBox.isSelected());
                }
            }
        });
        abstractEnergySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void primaryBodyChanged() {
                if (abstractEnergySkateParkModule.getEnergySkateParkModel().getNumBodies() > 0) {
                    energySkateParkSlider.setValue(abstractEnergySkateParkModule.getEnergySkateParkModel().getBody(0).getMass());
                }
            }
        });
        this.addControl(energySkateParkSlider);
        this.addControl(jButton);
    }

    private void restoreDefaults() {
        this.setMass(this.module.getSkaterCharacter().getMass());
        this.module.setBounciness(0.6);
        this.setStickiness(0.9);
    }

    private boolean isKeepEnergyOnLanding() {
        EnergySkateParkModel energySkateParkModel = this.module.getEnergySkateParkModel();
        if (energySkateParkModel.getNumBodies() > 0) {
            return energySkateParkModel.getBody(0).isKeepEnergyOnLanding();
        }
        return false;
    }

    private void setMass(double d) {
        EnergySkateParkModel energySkateParkModel = this.module.getEnergySkateParkModel();
        for (int i = 0; i < energySkateParkModel.getNumBodies(); ++i) {
            Body body = energySkateParkModel.getBody(i);
            body.setMass(d);
        }
    }

    private void setStickiness(double d) {
        Body.staticSticky = d;
        for (int i = 0; i < Body.particles.size(); ++i) {
            Body body = (Body)Body.particles.get(i);
            body.setStickiness(Body.staticSticky);
        }
    }

    public void reset() {
        this.restoreDefaults();
        this.setAdvancedControlsVisible(false);
    }
}

