/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.colorado.phet.common.spline.ParametricFunction2D;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.EnergySkateParkSimSharing;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;
import edu.colorado.phet.energyskatepark.model.PreFabSplines;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;
import edu.colorado.phet.energyskatepark.view.piccolo.SplineNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;

public class SplineToolboxNode
extends PNode {
    private final EnergySkateParkSimulationPanel energySkateParkSimulationPanel;
    private final boolean splinesMovable;
    private final PText textGraphic;
    private final PNode draggableIcon;
    private final PPath boundGraphic;
    private boolean created = false;
    private EnergySkateParkSpline createdSurface;
    private Property<Integer> numberOfDraggedTracks = new Property<Integer>(0);

    public SplineToolboxNode(final EnergySkateParkSimulationPanel energySkateParkSimulationPanel, boolean bl, final boolean bl2) {
        this.energySkateParkSimulationPanel = energySkateParkSimulationPanel;
        this.splinesMovable = bl;
        energySkateParkSimulationPanel.getEnergySkateParkModule().addResetListener(new VoidFunction0(){

            public void apply() {
                SplineToolboxNode.this.numberOfDraggedTracks.reset();
            }
        });
        energySkateParkSimulationPanel.addSplineDeletedByUserListener(new VoidFunction0(){

            public void apply() {
                SplineToolboxNode.this.numberOfDraggedTracks.set(energySkateParkSimulationPanel.getEnergySkateParkModule().getEnergySkateParkModel().getNumSplines());
            }
        });
        this.draggableIcon = new PNodeFacade(this.createSplineGraphic()){
            {
                super(pNode);
                SplineToolboxNode.this.numberOfDraggedTracks.addObserver(new VoidFunction1<Integer>(){

                    @Override
                    public void apply(Integer n) {
                        if (bl2) {
                            boolean bl = n <= 3;
                            this.setVisible(bl);
                            this.setPickable(bl);
                            this.setChildrenPickable(bl);
                        }
                    }
                });
            }
        };
        this.draggableIcon.addInputEventListener(new CursorHandler());
        this.draggableIcon.addInputEventListener(new SimSharingDragHandler(EnergySkateParkSimSharing.UserComponents.toolboxTrack, UserComponentTypes.sprite){

            public ParameterSet getStartDragParameters(PInputEvent pInputEvent) {
                return super.getStartDragParameters(pInputEvent).with((IParameterKey)EnergySkateParkSimSharing.ParameterKeys.numTracks, energySkateParkSimulationPanel.getEnergySkateParkModel().getNumSplines() + 1).with((IParameterKey)EnergySkateParkSimSharing.ParameterKeys.trackIndex, ParametricFunction2D.count);
            }

            public ParameterSet getEndDragParameters(PInputEvent pInputEvent) {
                return super.getEndDragParameters(pInputEvent).with(ParameterSet.parameterSet((IParameterKey)EnergySkateParkSimSharing.ParameterKeys.trackIndex, ((SplineToolboxNode)SplineToolboxNode.this).createdSurface.getParametricFunction2D().index));
            }

            protected void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                if (!SplineToolboxNode.this.created) {
                    this.create(pInputEvent);
                    SplineToolboxNode.this.numberOfDraggedTracks.set((Integer)SplineToolboxNode.this.numberOfDraggedTracks.get() + 1);
                    SplineToolboxNode.this.created = true;
                } else {
                    this.drag(pInputEvent);
                }
            }

            protected void drag(PInputEvent pInputEvent) {
                super.drag(pInputEvent);
                energySkateParkSimulationPanel.dragSplineSurface(pInputEvent, SplineToolboxNode.this.createdSurface);
            }

            protected void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                if (SplineToolboxNode.this.created) {
                    energySkateParkSimulationPanel.getSplineNode(SplineToolboxNode.this.createdSurface).processExternalDropEvent(pInputEvent);
                    SplineToolboxNode.this.created = false;
                }
            }

            private void create(PInputEvent pInputEvent) {
                Point2D.Double double_ = new Point2D.Double(pInputEvent.getCanvasPosition().getX(), pInputEvent.getCanvasPosition().getY());
                energySkateParkSimulationPanel.getRootNode().screenToWorld(double_);
                PreFabSplines.CubicSpline cubicSpline = new PreFabSplines.CubicSpline();
                cubicSpline.addControlPoint(((Point2D)double_).getX() - 1.0, ((Point2D)double_).getY());
                cubicSpline.addControlPoint(((Point2D)double_).getX(), ((Point2D)double_).getY());
                cubicSpline.addControlPoint(((Point2D)double_).getX() + 1.0, ((Point2D)double_).getY());
                SplineToolboxNode.this.createdSurface = new EnergySkateParkSpline(cubicSpline.getControlPoints());
                energySkateParkSimulationPanel.getEnergySkateParkModel().addSplineSurface(SplineToolboxNode.this.createdSurface);
                energySkateParkSimulationPanel.getSplineNode(SplineToolboxNode.this.createdSurface).processExternalStartDragEvent();
            }
        });
        this.boundGraphic = new PPath(new RoundRectangle2D.Double(0.0, 0.0, 180.0, 60.0, 20.0, 20.0));
        this.boundGraphic.setStroke(new BasicStroke(2.0f));
        this.boundGraphic.setStrokePaint(Color.blue);
        this.boundGraphic.setPaint(Color.yellow);
        this.addChild(this.boundGraphic);
        this.textGraphic = new PText(EnergySkateParkResources.getString("controls.add-track"));
        this.textGraphic.setFont(new PhetFont(1, 14));
        this.textGraphic.setOffset(this.boundGraphic.getFullBounds().getCenterX() - this.textGraphic.getFullBounds().getWidth() / 2.0, this.boundGraphic.getFullBounds().getY() + 2.0);
        this.addChild(this.textGraphic);
        this.addChild(this.draggableIcon);
        energySkateParkSimulationPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SplineToolboxNode.this.centerTheNode();
            }
        });
        this.centerTheNode();
    }

    private void centerTheNode() {
        this.draggableIcon.setScale(60.0);
        this.draggableIcon.centerFullBoundsOnPoint(this.boundGraphic.getFullBounds().getCenterX(), this.boundGraphic.getFullBounds().getCenterY());
        this.draggableIcon.translate(0.0, 0.08333333333333333);
    }

    private SplineNode createSplineGraphic() {
        EnergySkateParkSpline energySkateParkSpline = this.createSplineSurface();
        SplineNode splineNode = new SplineNode(this.energySkateParkSimulationPanel, energySkateParkSpline, this.energySkateParkSimulationPanel, this.splinesMovable);
        splineNode.setControlPointsPickable(false);
        return splineNode;
    }

    private EnergySkateParkSpline createSplineSurface() {
        PreFabSplines.CubicSpline cubicSpline = new PreFabSplines.CubicSpline();
        cubicSpline.addControlPoint(0.0, 0.0);
        cubicSpline.addControlPoint(1.0, 0.0);
        cubicSpline.addControlPoint(2.0, 0.0);
        return new EnergySkateParkSpline(cubicSpline.getControlPoints());
    }

    public static class PNodeFacade
    extends PNode {
        public PNodeFacade(PNode pNode) {
            this.addChild(pNode);
            pNode.setPickable(false);
            pNode.setChildrenPickable(false);
            PBounds pBounds = pNode.getFullBounds();
            this.addChild(new PhetPPath((Shape)pBounds, (Paint)new Color(0, 0, 0, 0)));
        }
    }
}

