/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.EnergySkateParkSimSharing;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.LinearFloorSpline2D;
import edu.colorado.phet.energyskatepark.model.TraversalState;
import edu.colorado.phet.energyskatepark.view.SkaterCharacter;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class SkaterNode
extends PNode {
    private Body body;
    private double heightDivisor = 1.0;
    private PImage skaterImageNode;
    private PPath centerDebugger;
    protected final boolean debugCenter = true;
    private PNode jetPackNode;
    private BufferedImage jetPackImage;
    private BufferedImage skaterImage;
    private final Body.ListenerAdapter bodyListener = new Body.ListenerAdapter(){

        public void thrustChanged() {
            SkaterNode.this.update();
        }

        public void dimensionChanged() {
            SkaterNode.this.update();
        }

        public void positionAngleChanged() {
            SkaterNode.this.update();
        }

        public void skaterCharacterChanged() {
            SkaterNode.this.setSkaterCharacter(SkaterNode.this.body.getSkaterCharacter());
            SkaterNode.this.update();
        }
    };

    public SkaterNode(final Body body) {
        this.body = body;
        if (body == null) {
            throw new IllegalArgumentException("Body cannot be null in " + this.getClass().getName());
        }
        this.jetPackImage = EnergySkateParkResources.getImage("rocket5.png");
        this.jetPackNode = new PhetPNode((PNode)new PImage(this.jetPackImage));
        this.addChild(this.jetPackNode);
        this.skaterImage = EnergySkateParkResources.getImage("skater3.png");
        this.skaterImageNode = new PImage(this.skaterImage);
        this.addChild(this.skaterImageNode);
        this.centerDebugger = new PhetPPath(PhetColorScheme.RED_COLORBLIND);
        this.addChild(this.centerDebugger);
        this.addInputEventListener(new SimSharingDragHandler(EnergySkateParkSimSharing.SharedComponents.skater, UserComponentTypes.sprite){
            public Point2D pressPoint;
            public SerializablePoint2D bodyPosition;

            public ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
                return super.getParametersForAllEvents(pInputEvent).with((IParameterKey)EnergySkateParkSimSharing.ParameterKeys.skaterX, body.getX()).with((IParameterKey)EnergySkateParkSimSharing.ParameterKeys.skaterY, body.getY());
            }

            protected void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                this.pressPoint = pInputEvent.getPositionRelativeTo(SkaterNode.this);
                this.bodyPosition = SkaterNode.this.getBody().getPosition();
                SkaterNode.this.getBody().setUserControlled(true);
                SkaterNode.this.getBody().setVelocity(0.0, 0.0);
            }

            protected void drag(PInputEvent pInputEvent) {
                super.drag(pInputEvent);
                Point2D point2D = pInputEvent.getPositionRelativeTo(SkaterNode.this);
                Point2D.Double double_ = new Point2D.Double(point2D.getX() - this.pressPoint.getX(), point2D.getY() - this.pressPoint.getY());
                double d = this.bodyPosition.getY() + ((Point2D)double_).getY();
                double d2 = body.getGravity() != 0.0 ? Math.max(0.0, d) : d;
                Point2D.Double double_2 = new Point2D.Double(this.bodyPosition.getX() + ((Point2D)double_).getX(), d2);
                SkaterNode.this.getBody().setPosition(((Point2D)double_2).getX(), ((Point2D)double_2).getY());
                if (((Point2D)double_2).getY() > 0.0) {
                    SkaterNode.this.snapToTrackDuringDrag();
                }
                SkaterNode.this.getBody().setUserControlled(true);
                SkaterNode.this.getBody().setVelocity(0.0, 0.0);
            }

            protected void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                SkaterNode.this.getBody().setUserControlled(false);
            }
        });
        this.addInputEventListener(new CursorHandler(12));
        this.getBody().addListener(this.bodyListener);
        this.update();
    }

    private void snapToTrackDuringDrag() {
        TraversalState traversalState = this.getBody().getTrackMatch(0.0, -0.3333333333333333);
        if (traversalState != null) {
            ImmutableVector2D immutableVector2D = traversalState.getParametricFunction2D().getUnitNormalVector(traversalState.getAlpha());
            double d = traversalState.isTop() ? 1.0 : -1.0;
            ImmutableVector2D immutableVector2D2 = immutableVector2D.getInstanceOfMagnitude(d);
            this.getBody().setAngle(immutableVector2D2.getAngle() - 1.5707963267948966);
            if (!(traversalState.getParametricFunction2D() instanceof LinearFloorSpline2D)) {
                Point2D.Double double_ = immutableVector2D.times(1.0E-6).plus(traversalState.getPosition().getX(), traversalState.getPosition().getY()).toPoint2D();
                this.getBody().setPosition(double_.getX(), double_.getY());
            }
        }
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.setBodyNoUpdate(body);
        this.update();
    }

    protected void setBodyNoUpdate(Body body) {
        this.body.removeListener(this.bodyListener);
        this.body = body;
        this.body.addListener(this.bodyListener);
    }

    private void update() {
        this.updateSkaterTransform();
        this.jetPackNode.setVisible(this.body.getThrust().getMagnitude() > 0.0);
        this.updateJetPackTransform();
        double d = 0.085;
        Ellipse2D.Double double_ = new Ellipse2D.Double(this.body.getCenterOfMass().getX() - d / 2.0, this.body.getCenterOfMass().getY() - d / 2.0, d, d);
        this.centerDebugger.setPathTo(double_);
    }

    public Rectangle2D getRedDotGlobalFullBounds() {
        return this.centerDebugger.getGlobalFullBounds();
    }

    private void updateJetPackTransform() {
        this.jetPackNode.setTransform(new AffineTransform());
        this.jetPackNode.setOffset(this.skaterImageNode.getFullBounds().getCenter2D());
        this.jetPackNode.transformBy(AffineTransform.getScaleInstance(2.0 * this.body.getWidth() / (double)this.skaterImage.getWidth(), -2.0 * this.body.getHeight() / (double)this.skaterImage.getHeight()));
        this.jetPackNode.translate(-this.jetPackImage.getWidth() / 2, -this.jetPackImage.getHeight() / 2);
        this.jetPackNode.rotateAboutPoint(-this.body.getThrust().getAngle() + 1.5707963267948966, this.jetPackImage.getWidth() / 2, this.jetPackImage.getHeight() / 2);
        if (this.body.isFacingRight()) {
            this.jetPackNode.transformBy(AffineTransform.getScaleInstance(-1.0, 1.0));
            this.jetPackNode.translate(-this.jetPackImage.getWidth(), 0.0);
        }
    }

    private void updateSkaterTransform() {
        this.skaterImageNode.setTransform(new AffineTransform());
        this.skaterImageNode.setOffset(this.body.getX(), this.body.getY());
        this.skaterImageNode.transformBy(AffineTransform.getScaleInstance(this.body.getWidth() / (double)this.skaterImage.getWidth(), -this.body.getHeight() / (double)this.skaterImage.getHeight()));
        this.skaterImageNode.rotate(-this.body.getAngle());
        this.skaterImageNode.translate(-this.skaterImage.getWidth() / 2, (double)(-this.skaterImage.getHeight()) / this.heightDivisor);
        if (this.body.isFacingRight()) {
            this.skaterImageNode.transformBy(AffineTransform.getScaleInstance(-1.0, 1.0));
            this.skaterImageNode.translate(-this.skaterImage.getWidth(), 0.0);
        }
    }

    public void setSkaterCharacter(SkaterCharacter skaterCharacter) {
        this.skaterImage = skaterCharacter.getImage();
        this.skaterImageNode.setImage(this.skaterImage);
        this.heightDivisor = skaterCharacter.getHeightDivisor();
        this.update();
    }

    public void delete() {
        this.body.removeListener(this.bodyListener);
    }
}

