/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.colorado.phet.energyskatepark.AbstractEnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.EnergySkateParkSimSharing;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.view.piccolo.SkaterNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class ReturnSkaterButtonNode
extends PhetPNode {
    private final AbstractEnergySkateParkModule module;
    private final PSwingCanvas canvas;
    private SkaterNode skaterNode;
    private final PNode buttonNode;

    public ReturnSkaterButtonNode(PSwingCanvas pSwingCanvas, final AbstractEnergySkateParkModule abstractEnergySkateParkModule, SkaterNode skaterNode) {
        this.canvas = pSwingCanvas;
        this.skaterNode = skaterNode;
        this.module = abstractEnergySkateParkModule;
        TextButtonNode textButtonNode = new TextButtonNode(EnergySkateParkResources.getString("controls.reset-character")){
            {
                this.setUserComponent(EnergySkateParkSimSharing.UserComponents.playAreaReturnSkaterButton);
                this.setBackground(Color.ORANGE);
            }
        };
        textButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                abstractEnergySkateParkModule.returnOrResetSkater();
            }
        });
        this.buttonNode = new PhetPNode((PNode)textButtonNode);
        this.addChild(this.buttonNode);
        abstractEnergySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void primaryBodyChanged() {
                ReturnSkaterButtonNode.this.update();
            }
        });
        this.update();
        pSwingCanvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ReturnSkaterButtonNode.this.update();
            }
        });
    }

    private void update() {
        this.updateVisible();
        this.updateLocation();
    }

    private void updateVisible() {
        if (this.skaterNode == null) {
            this.setVisible(false);
        } else {
            this.setVisible(!this.isSkaterFullyOnscreen());
        }
    }

    private boolean isSkaterFullyOnscreen() {
        return this.module.getEnergySkateParkSimulationPanel().isSkaterOnscreen(this.skaterNode);
    }

    private void updateLocation() {
        this.buttonNode.setOffset((double)(this.canvas.getWidth() / 2) - this.buttonNode.getFullBounds().getWidth() / 2.0, (double)(this.canvas.getHeight() / 2) - this.buttonNode.getFullBounds().getHeight() / 2.0);
    }

    public void setSkaterNode(SkaterNode skaterNode) {
        this.skaterNode = skaterNode;
        this.update();
    }
}

