/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Line2D;

public class GridNode
extends PhetPNode {
    private final PNode lines = new PNode();
    private final PNode textLayer = new PNode();
    private Paint gridPaint = null;
    private final double highlightX;

    public GridNode(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        Object object;
        String string;
        double d8;
        this.highlightX = d7;
        this.addChild(this.lines);
        this.addChild(this.textLayer);
        for (d8 = d; d8 <= d3; d8 += d5) {
            this.lines.addChild(this.createXLineNode(d2, d4, d8));
            if (d8 % 2.0 != 0.0) continue;
            string = "" + (int)d8;
            if (string.equals("0")) {
                string = PhetCommonResources.formatValueUnits("0", EnergySkateParkResources.getString("units.meters"));
            }
            object = new PText(string);
            ((PNode)object).setOffset(d8 + d5 + d5 * 0.2, d2);
            ((PNode)object).setScale(0.03f);
            ((PNode)object).getTransformReference(true).scale(1.0, -1.0);
            this.textLayer.addChild((PNode)object);
        }
        for (d8 = d2; d8 <= d4; d8 += d6) {
            this.lines.addChild(this.createYLineNode(d, d3, d8));
            if (d8 % 2.0 != 0.0) continue;
            string = "" + (int)d8;
            object = new PText(string);
            ((PNode)object).setOffset(d5 * d7 - d5 * 0.05 - ((PNode)object).getFullBounds().getWidth() * (double)0.03f, d8 + d6 * 0.05);
            ((PNode)object).setScale(0.03f);
            ((PNode)object).getTransformReference(true).scale(1.0, -1.0);
            this.textLayer.addChild((PNode)object);
            if (!string.equals("0")) continue;
            object = EnergySkateParkResources.getString("units.meters");
            PText pText = new PText((String)object);
            pText.setOffset(d5 * d7 + d5 * 0.05, d8 + d6 * 0.05);
            pText.setScale(0.03f);
            pText.getTransformReference(true).scale(1.0, -1.0);
            this.textLayer.addChild(pText);
        }
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.setLinePaint(new Color(128, 128, 128));
        this.setFontPaint(Color.black);
    }

    public void setGridPaint(Paint paint) {
        if (this.gridPaint == null || !this.gridPaint.equals(paint)) {
            this.gridPaint = paint;
            this.setLinePaint(paint);
            this.setFontPaint(paint);
        }
    }

    private void setFontPaint(Paint paint) {
        for (int i = 0; i < this.textLayer.getChildrenCount(); ++i) {
            PText pText = (PText)this.textLayer.getChild(i);
            pText.setTextPaint(paint);
        }
    }

    public void setLinePaint(Paint paint) {
        for (int i = 0; i < this.lines.getChildrenCount(); ++i) {
            PPath pPath = (PPath)this.lines.getChild(i);
            pPath.setStrokePaint(paint);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.setPickable(false);
        this.setChildrenPickable(false);
    }

    private PNode createYLineNode(double d, double d2, double d3) {
        PPath pPath = new PPath(new Line2D.Double(d, d3, d2, d3)){

            protected void paint(PPaintContext pPaintContext) {
                int n = pPaintContext.getRenderQuality();
                pPaintContext.setRenderQuality(0);
                super.paint(pPaintContext);
                pPaintContext.setRenderQuality(n);
            }
        };
        boolean bl = MathUtil.isApproxEqual(d3, 0.0, 0.001);
        if ((int)d3 % 2 == 0) {
            bl = true;
        }
        pPath.setStroke(new BasicStroke(0.01f * (float)(bl ? 3 : 1)));
        return pPath;
    }

    private PNode createXLineNode(double d, double d2, double d3) {
        PPath pPath = new PPath(new Line2D.Double(d3, d, d3, d2)){

            protected void paint(PPaintContext pPaintContext) {
                int n = pPaintContext.getRenderQuality();
                pPaintContext.setRenderQuality(0);
                super.paint(pPaintContext);
                pPaintContext.setRenderQuality(n);
            }
        };
        boolean bl = MathUtil.isApproxEqual(d3, this.highlightX, 0.001);
        pPath.setStroke(new BasicStroke(0.01f * (float)(bl ? 3 : 1)));
        return pPath;
    }
}

