/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.PhetRootPNode;
import edu.colorado.phet.common.piccolophet.nodes.MeasuringTape;
import edu.colorado.phet.energyskatepark.AbstractEnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.basics.ESPSpeedometerNode;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;
import edu.colorado.phet.energyskatepark.model.Floor;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;
import edu.colorado.phet.energyskatepark.view.piccolo.BackgroundScreenNode;
import edu.colorado.phet.energyskatepark.view.piccolo.EnergyErrorIndicatorNode;
import edu.colorado.phet.energyskatepark.view.piccolo.EnergySkateParkLegend;
import edu.colorado.phet.energyskatepark.view.piccolo.EnergySkateParkPieChartNode;
import edu.colorado.phet.energyskatepark.view.piccolo.FloorNode;
import edu.colorado.phet.energyskatepark.view.piccolo.GridNode;
import edu.colorado.phet.energyskatepark.view.piccolo.HistoryPointNode;
import edu.colorado.phet.energyskatepark.view.piccolo.PanZoomOnscreenControlNode;
import edu.colorado.phet.energyskatepark.view.piccolo.ReturnSkaterButtonNode;
import edu.colorado.phet.energyskatepark.view.piccolo.SelectedTimeControlPanel;
import edu.colorado.phet.energyskatepark.view.piccolo.SkaterNode;
import edu.colorado.phet.energyskatepark.view.piccolo.SplineNode;
import edu.colorado.phet.energyskatepark.view.piccolo.SplineToolboxNode;
import edu.colorado.phet.energyskatepark.view.piccolo.SurfaceObjectNode;
import edu.colorado.phet.energyskatepark.view.piccolo.ZeroPointPotentialNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;

public class EnergySkateParkRootNode
extends PhetRootPNode {
    private final AbstractEnergySkateParkModule module;
    private final EnergySkateParkSimulationPanel simulationPanel;
    private final PNode skaterNodeLayer = new PNode();
    private final PNode splineLayer = new PNode();
    private final PNode historyLayer = new PNode();
    private final PNode historyReadoutLayer = new PNode();
    private final PNode pieChartLayer = new PNode();
    private final MeasuringTape measuringTape;
    private final ReturnSkaterButtonNode returnSkaterButtonNode;
    private boolean ignoreThermal = false;
    private final EnergySkateParkLegend legend;
    private final BackgroundScreenNode backgroundScreenNode;
    private final SplineToolboxNode splineToolbox;
    private final FloorNode floorNode;
    private final ZeroPointPotentialNode zeroPointPotentialNode;
    public final GridNode gridNode;
    private final PanZoomOnscreenControlNode panZoomControls;
    private final PNode energyErrorIndicatorContainer = new PNode();
    private final EnergyErrorIndicatorNode energyErrorIndicatorNode;
    private final SurfaceObjectNode houseNode;
    private final SurfaceObjectNode mountainNode;
    public static final Color SKY_COLOR = new Color(170, 200, 220);
    private boolean splinesMovable;
    public final PNode controlLayer = new PNode();
    private final ArrayList<VoidFunction0> layoutListeners = new ArrayList();

    public EnergySkateParkRootNode(final AbstractEnergySkateParkModule abstractEnergySkateParkModule, final EnergySkateParkSimulationPanel energySkateParkSimulationPanel, boolean bl, double d) {
        this.module = abstractEnergySkateParkModule;
        this.simulationPanel = energySkateParkSimulationPanel;
        this.splinesMovable = abstractEnergySkateParkModule.splinesMovable;
        EnergySkateParkModel energySkateParkModel = this.getModel();
        Floor floor = energySkateParkModel.getFloor();
        energySkateParkSimulationPanel.setBackground(SKY_COLOR);
        this.splineToolbox = new SplineToolboxNode(energySkateParkSimulationPanel, this.splinesMovable, abstractEnergySkateParkModule.limitNumberOfTracks){
            {
                this.setOffset(10.0, 10.0);
            }
        };
        this.measuringTape = new MeasuringTape(new ModelViewTransform2D(new Rectangle(50, 50), new Rectangle2D.Double(0.0, 0.0, 50.0, 50.0)), new Point2D.Double(25.0, 25.0), EnergySkateParkResources.getString("units.meters.abbreviation"));
        this.updateMapping();
        this.resetMeasuringTapeLocation();
        this.legend = new EnergySkateParkLegend(abstractEnergySkateParkModule);
        this.floorNode = new FloorNode(abstractEnergySkateParkModule, this.getModel(), floor);
        this.backgroundScreenNode = new BackgroundScreenNode(energySkateParkSimulationPanel, null, (PNode)this.floorNode);
        this.zeroPointPotentialNode = new ZeroPointPotentialNode(energySkateParkSimulationPanel, energySkateParkModel);
        double d2 = -0.5;
        this.gridNode = new GridNode(-50.0 + d2, 0.0, 100.0, 150.0, 1.0, 1.0, d + d2);
        abstractEnergySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void gravityChanged() {
                HashMap<Double, Color> hashMap = new HashMap<Double, Color>();
                hashMap.put(new Double(0.0), Color.lightGray);
                hashMap.put(new Double(-25.95), Color.white);
                hashMap.put(new Double(-1.62), Color.lightGray);
                Double d = new Double(abstractEnergySkateParkModule.getEnergySkateParkModel().getGravity());
                Paint paint = (Paint)(hashMap.containsKey(d) ? hashMap.get(d) : Color.black);
                EnergySkateParkRootNode.this.gridNode.setGridPaint(paint);
            }
        });
        this.houseNode = new SurfaceObjectNode("house.png", 1.25, 12.0);
        this.mountainNode = new SurfaceObjectNode("mountains.png", 1.2000000000000002, -1.0);
        this.returnSkaterButtonNode = new ReturnSkaterButtonNode(energySkateParkSimulationPanel, abstractEnergySkateParkModule, null);
        abstractEnergySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void gravityChanged() {
                EnergySkateParkRootNode.this.updateHouseAndMountainVisible();
            }
        });
        this.addScreenChild(this.backgroundScreenNode);
        this.addWorldChild(this.houseNode);
        this.addWorldChild(this.mountainNode);
        this.addWorldChild(this.floorNode);
        this.addWorldChild(this.gridNode);
        this.addScreenChild(this.splineToolbox);
        this.addChild(this.controlLayer);
        this.addWorldChild(this.splineLayer);
        this.addWorldChild(this.skaterNodeLayer);
        this.addScreenChild(this.historyLayer);
        this.addScreenChild(this.historyReadoutLayer);
        this.addScreenChild(this.measuringTape);
        this.addScreenChild(this.pieChartLayer);
        this.addScreenChild(this.legend);
        this.addScreenChild(this.zeroPointPotentialNode);
        this.addScreenChild(this.returnSkaterButtonNode);
        this.resetDefaults();
        energySkateParkSimulationPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                EnergySkateParkRootNode.this.backgroundScreenNode.update();
            }
        });
        this.setZeroPointVisible(false);
        this.panZoomControls = new PanZoomOnscreenControlNode(energySkateParkSimulationPanel);
        if (bl) {
            this.addScreenChild(this.panZoomControls);
        }
        this.energyErrorIndicatorNode = new EnergyErrorIndicatorNode(abstractEnergySkateParkModule.getEnergySkateParkModel());
        this.energyErrorIndicatorContainer.setVisible(false);
        this.energyErrorIndicatorContainer.addChild(this.energyErrorIndicatorNode);
        this.addScreenChild(this.energyErrorIndicatorContainer);
        energySkateParkSimulationPanel.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                EnergySkateParkRootNode.this.updateEnergyIndicator();
            }

            public void componentResized(ComponentEvent componentEvent) {
                EnergySkateParkRootNode.this.updateEnergyIndicator();
            }
        });
        this.updateMapping();
        this.addWorldTransformListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EnergySkateParkRootNode.this.updateMapping();
            }
        });
        energySkateParkSimulationPanel.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 86 && keyEvent.isControlDown() && keyEvent.isShiftDown()) {
                    EnergySkateParkRootNode.this.showAll(EnergySkateParkRootNode.this);
                }
            }
        });
        abstractEnergySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void bodyCountChanged() {
                EnergySkateParkRootNode.this.updateBodies();
            }

            public void splineCountChanged() {
                EnergySkateParkRootNode.this.updateSplines();
            }

            public void historyChanged() {
                EnergySkateParkRootNode.this.updateHistory();
            }

            public void splinesSynced() {
                EnergySkateParkRootNode.this.updateSplines();
            }

            public void bodiesSynced() {
                EnergySkateParkRootNode.this.updateBodies();
            }
        });
        abstractEnergySkateParkModule.pieChartVisible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                EnergySkateParkRootNode.this.pieChartLayer.setVisible(bl);
                EnergySkateParkRootNode.this.legend.setVisible(bl);
            }
        });
        abstractEnergySkateParkModule.gridVisible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                EnergySkateParkRootNode.this.gridNode.setVisible(bl);
            }
        });
        this.addScreenChild(new SelectedTimeControlPanel(abstractEnergySkateParkModule, abstractEnergySkateParkModule.getTimeSeriesModel().getTimeModelClock()){
            {
                super(abstractEnergySkateParkModule, constantDtClock);
                ComponentAdapter componentAdapter = new ComponentAdapter(){

                    public void componentResized(ComponentEvent componentEvent) {
                        this.setOffset((double)(energySkateParkSimulationPanel.getWidth() / 2) - this.getFullWidth() / 2.0, (double)energySkateParkSimulationPanel.getHeight() - this.getFullHeight() - 2.0);
                    }
                };
                energySkateParkSimulationPanel.addComponentListener(componentAdapter);
                componentAdapter.componentResized(null);
            }
        });
        this.addWorldChild(new ESPSpeedometerNode(abstractEnergySkateParkModule.getPrimarySkaterSpeed()){
            {
                super(observableProperty);
                AffineTransform affineTransform = AffineTransform.getScaleInstance(0.02f, -0.02f);
                affineTransform.preConcatenate(AffineTransform.getTranslateInstance(7.5 - this.getFullBounds().getWidth() / 2.0 * (double)0.02f, 8.25));
                this.setTransform(affineTransform);
                abstractEnergySkateParkModule.speedVisible.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setVisible(bl);
                    }
                });
            }
        });
    }

    public SplineToolboxNode getSplineToolbox() {
        return this.splineToolbox;
    }

    public void removeSplineToolbox() {
        this.removeChild(this.splineToolbox);
    }

    private void resetMeasuringTapeLocation() {
        this.measuringTape.setModelSrc(new Point2D.Double(5.0, 5.0));
        this.measuringTape.setModelDst(new Point2D.Double(7.0, 5.0));
    }

    private void updateHouseAndMountainVisible() {
        this.houseNode.setVisible(this.module.getEnergySkateParkModel().getGravity() == -9.81 && this.getBackgroundScreenNode().getVisible());
        this.mountainNode.setVisible(this.module.getEnergySkateParkModel().getGravity() == -9.81 && this.getBackgroundScreenNode().getVisible());
    }

    private void showAll(PNode pNode) {
        pNode.setVisible(true);
        for (int i = 0; i < pNode.getChildrenCount(); ++i) {
            this.showAll(pNode.getChild(i));
        }
    }

    private void updateMapping() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        this.worldToScreen(double_);
        this.measuringTape.setModelViewTransform2D(new ModelViewTransform2D(new Rectangle(1, 1), double_));
    }

    private void updateEnergyIndicator() {
        double d = 20.0;
        double d2 = 20.0;
        this.energyErrorIndicatorNode.setOffset(d, (double)this.simulationPanel.getHeight() - d2 - this.energyErrorIndicatorNode.getFullBounds().getHeight());
    }

    private BackgroundScreenNode getBackgroundScreenNode() {
        return this.backgroundScreenNode;
    }

    public void setBackground(BufferedImage bufferedImage) {
        this.backgroundScreenNode.setBackground(bufferedImage);
    }

    private void resetDefaults() {
        this.module.pieChartVisible.reset();
        this.setMeasuringTapeVisible(false);
        this.module.gridVisible.reset();
    }

    private EnergySkateParkModel getModel() {
        return this.module.getEnergySkateParkModel();
    }

    public void addSplineNode(SplineNode splineNode) {
        this.splineLayer.addChild(splineNode);
    }

    public void reset() {
        this.setMeasuringTapeVisible(false);
        this.resetMeasuringTapeLocation();
        this.panZoomControls.reset();
        this.module.gridVisible.reset();
        this.module.pieChartVisible.reset();
        this.module.barChartVisible.reset();
    }

    public void addSkaterNode(SkaterNode skaterNode) {
        skaterNode.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                EnergySkateParkRootNode.this.module.setRecordOrLiveMode();
            }
        });
        this.skaterNodeLayer.addChild(skaterNode);
    }

    public SplineNode splineGraphicAt(int n) {
        return (SplineNode)this.splineLayer.getChildrenReference().get(n);
    }

    public int numSplineGraphics() {
        return this.splineLayer.getChildrenReference().size();
    }

    public void removeSplineNode(SplineNode splineNode) {
        this.splineLayer.removeChild(splineNode);
        splineNode.detachListeners();
    }

    private void updateHistory() {
        while (this.numHistoryGraphics() < this.getModel().getNumHistoryPoints()) {
            this.addHistoryGraphic(new HistoryPointNode(this.getModel().historyPointAt(0), this));
        }
        while (this.numHistoryGraphics() > this.getModel().getNumHistoryPoints()) {
            this.removeHistoryPointGraphic(this.historyGraphicAt(this.numHistoryGraphics() - 1));
        }
        for (int i = 0; i < this.getModel().getNumHistoryPoints(); ++i) {
            this.historyGraphicAt(i).setHistoryPoint(this.getModel().historyPointAt(i));
        }
    }

    private HistoryPointNode historyGraphicAt(int n) {
        return (HistoryPointNode)this.historyLayer.getChild(n);
    }

    private void removeHistoryPointGraphic(HistoryPointNode historyPointNode) {
        this.historyLayer.removeChild(historyPointNode);
        this.historyReadoutLayer.removeChild(historyPointNode.getReadoutGraphic());
    }

    private void addHistoryGraphic(HistoryPointNode historyPointNode) {
        this.historyLayer.addChild(historyPointNode);
        this.historyReadoutLayer.addChild(historyPointNode.getReadoutGraphic());
    }

    private int numHistoryGraphics() {
        return this.historyLayer.getChildrenCount();
    }

    private void updateBodies() {
        while (this.numBodyGraphics() < this.getModel().getNumBodies()) {
            this.addSkaterNode(new SkaterNode(this.getModel().getBody(0)));
        }
        while (this.numBodyGraphics() > this.getModel().getNumBodies()) {
            this.removeSkaterNode(this.getSkaterNode(this.numBodyGraphics() - 1));
        }
        for (int i = 0; i < this.getModel().getNumBodies(); ++i) {
            this.getSkaterNode(i).setBody(this.getModel().getBody(i));
        }
        if (this.skaterNodeLayer.getChildrenCount() == 1) {
            this.initPieChart();
            this.returnSkaterButtonNode.setSkaterNode(this.getSkaterNode(0));
        }
    }

    private void initPieChart() {
        this.pieChartLayer.removeAllChildren();
        EnergySkateParkPieChartNode energySkateParkPieChartNode = new EnergySkateParkPieChartNode(this.module, this.getSkaterNode(0));
        energySkateParkPieChartNode.setIgnoreThermal(this.ignoreThermal);
        this.pieChartLayer.addChild(energySkateParkPieChartNode);
    }

    private void updateSplines() {
        while (this.numSplineGraphics() > 0) {
            this.removeSplineNode(this.splineGraphicAt(0));
        }
        for (int i = 0; i < this.getModel().getNumSplines(); ++i) {
            EnergySkateParkSpline energySkateParkSpline = this.getModel().getSpline(i);
            this.addSplineNode(new SplineNode(this.simulationPanel, energySkateParkSpline, this.simulationPanel, this.splinesMovable));
        }
    }

    private void removeSkaterNode(SkaterNode skaterNode) {
        this.skaterNodeLayer.removeChild(skaterNode);
        skaterNode.delete();
    }

    public int numBodyGraphics() {
        return this.skaterNodeLayer.getChildrenCount();
    }

    public SkaterNode getSkaterNode(int n) {
        return (SkaterNode)this.skaterNodeLayer.getChild(n);
    }

    public boolean isMeasuringTapeVisible() {
        return this.measuringTape.getVisible();
    }

    public void setMeasuringTapeVisible(boolean bl) {
        this.measuringTape.setVisible(bl);
    }

    public boolean getIgnoreThermal() {
        return this.ignoreThermal;
    }

    public void setIgnoreThermal(boolean bl) {
        if (this.ignoreThermal != bl) {
            this.ignoreThermal = bl;
            for (int i = 0; i < this.pieChartLayer.getChildrenCount(); ++i) {
                EnergySkateParkPieChartNode energySkateParkPieChartNode = (EnergySkateParkPieChartNode)this.pieChartLayer.getChild(i);
                energySkateParkPieChartNode.setIgnoreThermal(this.ignoreThermal);
            }
        }
    }

    public void clearBackground() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(new Color(0, 0, 0, 255));
        graphics2D.fillRect(0, 0, 1, 1);
        this.setBackground(null);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        double d = 10.0;
        double d2 = 10.0;
        this.legend.setOffset((double)this.getSimulationPanel().getWidth() - this.legend.getFullBounds().getWidth() - d, d2);
        if (this.panZoomControls != null) {
            this.panZoomControls.setOffset((double)this.getSimulationPanel().getWidth() - this.panZoomControls.getFullBounds().getWidth() - d, (double)this.getSimulationPanel().getHeight() - this.panZoomControls.getFullBounds().getHeight() - d2);
        }
        for (VoidFunction0 voidFunction0 : this.layoutListeners) {
            voidFunction0.apply();
        }
    }

    public void addLayoutListener(VoidFunction0 voidFunction0) {
        this.layoutListeners.add(voidFunction0);
    }

    private EnergySkateParkSimulationPanel getSimulationPanel() {
        return this.simulationPanel;
    }

    public void setZeroPointVisible(boolean bl) {
        this.zeroPointPotentialNode.setVisible(bl);
    }

    public boolean isZeroPointVisible() {
        return this.zeroPointPotentialNode.getVisible();
    }

    public PNode getMeasuringTapeNode() {
        return this.measuringTape;
    }

    public void updateScale() {
        this.panZoomControls.updateScale();
    }

    public void setEnergyErrorVisible(boolean bl) {
        this.energyErrorIndicatorContainer.setVisible(bl);
    }

    public boolean isEnergyErrorVisible() {
        return this.energyErrorIndicatorContainer.getVisible();
    }

    public void setBackgroundVisible(boolean bl) {
        this.getBackgroundScreenNode().setVisible(bl);
        this.updateHouseAndMountainVisible();
    }

    public void updateSplineNodes() {
        this.updateSplines();
    }

    public SkaterNode getSkaterNode(Body body) {
        for (int i = 0; i < this.skaterNodeLayer.getChildrenCount(); ++i) {
            SkaterNode skaterNode = (SkaterNode)this.skaterNodeLayer.getChild(i);
            if (skaterNode.getBody() != body) continue;
            return skaterNode;
        }
        return null;
    }

    public void updateBackground() {
        this.backgroundScreenNode.update();
    }

    public EnergySkateParkLegend getLegend() {
        return this.legend;
    }
}

