/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.piccolo;

import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;

public class EnergyErrorIndicatorNode
extends PhetPNode {
    private Body body;
    private final EnergySkateParkModel model;
    private final ShadowPText textNode;
    private final Body.Listener listener;

    public EnergyErrorIndicatorNode(EnergySkateParkModel energySkateParkModel) {
        this.model = energySkateParkModel;
        this.listener = new Body.ListenerAdapter(){

            public void energyChanged() {
                EnergyErrorIndicatorNode.this.update();
            }
        };
        energySkateParkModel.addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void bodyCountChanged() {
                EnergyErrorIndicatorNode.this.updateBody();
            }
        });
        this.updateBody();
        this.textNode = this.createTextNode("Energy Error");
        this.addChild(this.textNode);
        JButton jButton = new JButton("Clear");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergyErrorIndicatorNode.this.body.clearEnergyError();
            }
        });
        PSwing pSwing = new PSwing(jButton);
        pSwing.setOffset(0.0, this.createTextNode("Energy Error: 0.00E-00").getFullBounds().getHeight());
        this.addChild(pSwing);
    }

    private ShadowPText createTextNode(String string) {
        ShadowPText shadowPText = new ShadowPText(string);
        shadowPText.setFont(new PhetFont(18, true));
        shadowPText.setShadowColor(Color.black);
        shadowPText.setShadowOffset(2.0, 2.0);
        shadowPText.setTextPaint(PhetColorScheme.RED_COLORBLIND);
        return shadowPText;
    }

    private void update() {
        if (this.body == null) {
            this.setVisible(false);
        } else {
            this.setVisible(this.body.getErrorCount() > 0);
            if (this.body.getErrorCount() > 0) {
                double d = this.body.getFractionalEnergyError() * 100.0;
                String string = new DecimalFormat("0.00").format(d);
                this.textNode.setText("Energy Error: " + string + "% (" + this.body.getErrorCount() + " errors)");
            }
        }
    }

    private void updateBody() {
        Body body;
        Body body2 = body = this.model.getNumBodies() > 0 ? this.model.getBody(0) : null;
        if (body != this.body) {
            if (this.body != null) {
                this.body.removeListener(this.listener);
            }
            if (body != null) {
                body.addListener(this.listener);
            }
            this.body = body;
            this.update();
        }
    }
}

