/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.plots.bargraphs;

import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.view.EnergyLookAndFeel;
import java.awt.Color;

public abstract class ValueAccessor {
    private final String name;
    private final Color color;

    protected ValueAccessor(String string, Color color) {
        this.name = string;
        this.color = color;
    }

    public String getName() {
        return this.name;
    }

    public abstract double getValue(EnergySkateParkModel var1);

    public Color getColor() {
        return this.color;
    }

    public static class KineticEnergy
    extends ValueAccessor {
        public KineticEnergy(EnergyLookAndFeel energyLookAndFeel) {
            super(EnergySkateParkResources.getString("energy.kinetic"), energyLookAndFeel.getKEColor());
        }

        public double getValue(EnergySkateParkModel energySkateParkModel) {
            if (energySkateParkModel.getNumBodies() == 0) {
                return 0.0;
            }
            return energySkateParkModel.getBody(0).getKineticEnergy();
        }
    }

    public static class PotentialEnergy
    extends ValueAccessor {
        public PotentialEnergy(EnergyLookAndFeel energyLookAndFeel) {
            super(EnergySkateParkResources.getString("energy.potential"), energyLookAndFeel.getPEColor());
        }

        public double getValue(EnergySkateParkModel energySkateParkModel) {
            if (energySkateParkModel.getNumBodies() == 0) {
                return 0.0;
            }
            return energySkateParkModel.getBody(0).getPotentialEnergy();
        }
    }

    public static class ThermalEnergy
    extends ValueAccessor {
        public ThermalEnergy(EnergyLookAndFeel energyLookAndFeel) {
            super(EnergySkateParkResources.getString("energy.thermal"), energyLookAndFeel.getThermalEnergyColor());
        }

        public double getValue(EnergySkateParkModel energySkateParkModel) {
            if (energySkateParkModel.getNumBodies() == 0) {
                return 0.0;
            }
            return energySkateParkModel.getBody(0).getThermalEnergy();
        }
    }

    public static class TotalEnergy
    extends ValueAccessor {
        public TotalEnergy(EnergyLookAndFeel energyLookAndFeel) {
            super(EnergySkateParkResources.getString("energy.total"), energyLookAndFeel.getTotalEnergyColor());
        }

        public double getValue(EnergySkateParkModel energySkateParkModel) {
            if (energySkateParkModel.getNumBodies() == 0) {
                return 0.0;
            }
            return energySkateParkModel.getBody(0).getTotalEnergy();
        }
    }
}

