/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.plots.bargraphs;

import edu.colorado.phet.common.piccolophet.nodes.barchart.BarChartNode;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.plots.bargraphs.ValueAccessor;
import edu.colorado.phet.energyskatepark.view.EnergyLookAndFeel;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;

public class EnergySkateParkBarGraph
extends BarChartNode {
    private final EnergySkateParkModel model;

    public EnergySkateParkBarGraph(EnergySkateParkSimulationPanel energySkateParkSimulationPanel, EnergySkateParkModel energySkateParkModel, double d) {
        this(energySkateParkSimulationPanel, energySkateParkModel, EnergySkateParkResources.getString("properties.energy"), d);
        ValueAccessor[] valueAccessorArray = new ValueAccessor[]{new ValueAccessor.KineticEnergy(energySkateParkSimulationPanel.getEnergySkateParkModule().getEnergyLookAndFeel()), new ValueAccessor.PotentialEnergy(energySkateParkSimulationPanel.getEnergySkateParkModule().getEnergyLookAndFeel()), new ValueAccessor.ThermalEnergy(energySkateParkSimulationPanel.getEnergySkateParkModule().getEnergyLookAndFeel()), new ValueAccessor.TotalEnergy(energySkateParkSimulationPanel.getEnergySkateParkModule().getEnergyLookAndFeel())};
        BarChartNode.Variable[] variableArray = EnergySkateParkBarGraph.toVariableArray(valueAccessorArray, energySkateParkModel);
        this.init(variableArray);
    }

    public EnergySkateParkBarGraph(EnergySkateParkSimulationPanel energySkateParkSimulationPanel, EnergySkateParkModel energySkateParkModel, String string, double d) {
        super(string, d, EnergyLookAndFeel.getLegendBackground());
        this.model = energySkateParkModel;
        energySkateParkSimulationPanel.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void primaryBodyChanged() {
                EnergySkateParkBarGraph.this.update();
            }
        });
    }

    public static BarChartNode.Variable[] toVariableArray(final ValueAccessor[] valueAccessorArray, final EnergySkateParkModel energySkateParkModel) {
        BarChartNode.Variable[] variableArray = new BarChartNode.Variable[valueAccessorArray.length];
        for (int i = 0; i < variableArray.length; ++i) {
            final int n = i;
            variableArray[i] = new BarChartNode.Variable(valueAccessorArray[n].getName(), valueAccessorArray[n].getValue(energySkateParkModel), valueAccessorArray[n].getColor()){

                public double getValue() {
                    return valueAccessorArray[n].getValue(energySkateParkModel);
                }
            };
        }
        return variableArray;
    }
}

