/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.plots;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartCursorNode;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.DynamicJFreeChartNode;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.DynamicJFreeChartNodeControlPanel;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.BufferedPhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.PopupMenuHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.colorado.phet.common.piccolophet.nodes.ZoomControlNode;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.energyskatepark.AbstractEnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.EnergySkateParkSimSharing;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.plots.VerticalZoomControl;
import edu.colorado.phet.energyskatepark.view.EnergyLookAndFeel;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkLookAndFeel;
import edu.colorado.phet.energyskatepark.view.swing.EnergySkateParkPlaybackPanel;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class EnergyTimePlot {
    private final EnergySkateParkModel model;
    private final TimeSeriesModel timeSeriesModel;
    private final ConstantDtClock clock;
    private final JDialog dialog;
    private final PhetPCanvas phetPCanvas;
    private final DynamicJFreeChartNode dynamicJFreeChartNode;
    private final JFreeChart chart;
    private final ZoomControlNode zoomControlNode;
    private final ReadoutTextNode thermalPText;
    private final ReadoutTextNode keText;
    private final ReadoutTextNode peText;
    private final ReadoutTextNode totalText;
    private final ArrayList listeners = new ArrayList();
    private JFreeChartCursorNode jFreeChartCursorNode;
    private final JDialog developerControlDialog;
    private final EnergySkateParkPlaybackPanel playbackPanel;

    public EnergyTimePlot(AbstractEnergySkateParkModule abstractEnergySkateParkModule, JFrame jFrame, ConstantDtClock constantDtClock, EnergySkateParkModel energySkateParkModel, final TimeSeriesModel timeSeriesModel) {
        this.model = energySkateParkModel;
        this.clock = constantDtClock;
        this.timeSeriesModel = timeSeriesModel;
        this.phetPCanvas = new BufferedPhetPCanvas();
        this.phetPCanvas.setBackground(EnergySkateParkLookAndFeel.backgroundColor);
        this.chart = ChartFactory.createXYLineChart(EnergySkateParkResources.getString("plots.energy-vs-time"), EnergySkateParkResources.getString("plots.energy-vs-time.time"), EnergySkateParkResources.getString("plots.energy-vs-time.energy"), new XYSeriesCollection(new XYSeries((Comparable)((Object)"series"))), PlotOrientation.VERTICAL, false, false, false);
        this.dynamicJFreeChartNode = new DynamicJFreeChartNode(this.phetPCanvas, this.chart);
        this.dynamicJFreeChartNode.setBuffered(true);
        this.dynamicJFreeChartNode.setBufferedImmediateSeries();
        this.dynamicJFreeChartNode.addSeries(EnergySkateParkResources.getString("energy.thermal"), PhetColorScheme.RED_COLORBLIND);
        this.dynamicJFreeChartNode.addSeries(EnergySkateParkResources.getString("energy.kinetic.abbreviation"), Color.green);
        this.dynamicJFreeChartNode.addSeries(EnergySkateParkResources.getString("energy.potential.abbreviation"), Color.blue);
        this.dynamicJFreeChartNode.addSeries(EnergySkateParkResources.getString("energy.total"), new EnergyLookAndFeel().getTotalEnergyColor());
        this.chart.getXYPlot().getRangeAxis().setRange(0.0, 7000.0);
        this.chart.getXYPlot().getDomainAxis().setRange(0.0, 20.0);
        this.thermalPText = new ReadoutTextNode(PhetColorScheme.RED_COLORBLIND);
        this.keText = new ReadoutTextNode(Color.green);
        this.peText = new ReadoutTextNode(Color.blue);
        this.totalText = new ReadoutTextNode(new EnergyLookAndFeel().getTotalEnergyColor());
        timeSeriesModel.addListener(new TimeSeriesModel.Adapter(){

            public void dataSeriesChanged() {
                if (EnergyTimePlot.this.getEnergySkateParkModel().getNumBodies() > 0) {
                    double d = EnergyTimePlot.this.getEnergySkateParkModel().getBody(0).getThermalEnergy();
                    double d2 = EnergyTimePlot.this.getEnergySkateParkModel().getBody(0).getKineticEnergy();
                    double d3 = EnergyTimePlot.this.getEnergySkateParkModel().getBody(0).getPotentialEnergy();
                    double d4 = EnergyTimePlot.this.getEnergySkateParkModel().getBody(0).getTotalEnergy();
                    EnergyTimePlot.this.updateReadouts();
                    double d5 = timeSeriesModel.getRecordTime();
                    EnergyTimePlot.this.dynamicJFreeChartNode.addValue(0, d5, d);
                    EnergyTimePlot.this.dynamicJFreeChartNode.addValue(1, d5, d2);
                    EnergyTimePlot.this.dynamicJFreeChartNode.addValue(2, d5, d3);
                    EnergyTimePlot.this.dynamicJFreeChartNode.addValue(3, d5, d4);
                    EnergyTimePlot.this.jFreeChartCursorNode.setMaxDragTime(d5);
                }
            }
        });
        timeSeriesModel.addPlaybackTimeChangeListener(new TimeSeriesModel.PlaybackTimeListener(){

            public void timeChanged() {
                if (EnergyTimePlot.this.getEnergySkateParkModel().getNumBodies() > 0) {
                    EnergyTimePlot.this.updateReadouts();
                }
            }
        });
        this.dialog = new JDialog(jFrame, EnergySkateParkResources.getString("plots.energy-vs-time"), false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.phetPCanvas, "Center");
        this.playbackPanel = new EnergySkateParkPlaybackPanel(abstractEnergySkateParkModule, timeSeriesModel, constantDtClock);
        jPanel.add((Component)this.playbackPanel, "South");
        this.dialog.setContentPane(jPanel);
        this.dialog.setSize(800, 400);
        this.dialog.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
                timeSeriesModel.setLiveMode();
            }
        });
        this.phetPCanvas.addScreenChild(this.dynamicJFreeChartNode);
        this.phetPCanvas.addScreenChild(this.thermalPText);
        this.phetPCanvas.addScreenChild(this.keText);
        this.phetPCanvas.addScreenChild(this.peText);
        this.phetPCanvas.addScreenChild(this.totalText);
        this.dialog.setLocation(0, Toolkit.getDefaultToolkit().getScreenSize().height - this.dialog.getHeight() - 100);
        this.jFreeChartCursorNode = new JFreeChartCursorNode(this.dynamicJFreeChartNode);
        this.phetPCanvas.addScreenChild(this.jFreeChartCursorNode);
        this.jFreeChartCursorNode.addListener(new JFreeChartCursorNode.Listener(){

            public void cursorTimeChanged() {
                timeSeriesModel.setPlaybackMode();
                timeSeriesModel.setPlaybackTime(EnergyTimePlot.this.jFreeChartCursorNode.getTime());
            }
        });
        timeSeriesModel.addPlaybackTimeChangeListener(new TimeSeriesModel.PlaybackTimeListener(){

            public void timeChanged() {
                EnergyTimePlot.this.updateCursor(EnergyTimePlot.this.jFreeChartCursorNode, timeSeriesModel);
            }
        });
        timeSeriesModel.addListener(new TimeSeriesModel.Adapter(){

            public void dataSeriesChanged() {
                if (timeSeriesModel.numPlaybackStates() == 0) {
                    EnergyTimePlot.this.clear();
                }
            }

            public void modeChanged() {
                EnergyTimePlot.this.updateCursor(EnergyTimePlot.this.jFreeChartCursorNode, timeSeriesModel);
            }

            public void pauseChanged() {
                EnergyTimePlot.this.updateCursor(EnergyTimePlot.this.jFreeChartCursorNode, timeSeriesModel);
            }
        });
        this.zoomControlNode = new VerticalZoomControl(this.chart.getXYPlot().getRangeAxis());
        this.phetPCanvas.addScreenChild(this.zoomControlNode);
        this.dialog.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                EnergyTimePlot.this.relayout();
            }
        });
        this.relayout();
        this.developerControlDialog = new JDialog(jFrame, EnergySkateParkResources.getString("plots.energy-vs-time") + " (developer controls)", false);
        this.developerControlDialog.setContentPane(new DynamicJFreeChartNodeControlPanel(this.dynamicJFreeChartNode));
        this.developerControlDialog.pack();
        this.developerControlDialog.setLocation(this.dialog.getLocation().x, this.dialog.getLocation().y - this.developerControlDialog.getHeight());
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Show Renderers");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergyTimePlot.this.developerControlDialog.setVisible(true);
            }
        });
        jPopupMenu.add(jMenuItem);
        this.phetPCanvas.addInputEventListener(new PopupMenuHandler(EnergySkateParkSimSharing.UserComponents.energyTimePlot, this.phetPCanvas, jPopupMenu));
    }

    private void updateReadouts() {
        double d = this.getEnergySkateParkModel().getBody(0).getThermalEnergy();
        double d2 = this.getEnergySkateParkModel().getBody(0).getKineticEnergy();
        double d3 = this.getEnergySkateParkModel().getBody(0).getPotentialEnergy();
        double d4 = this.getEnergySkateParkModel().getBody(0).getTotalEnergy();
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        this.thermalPText.setText(EnergySkateParkResources.getString("energy.thermal") + " = " + decimalFormat.format(d) + " J");
        this.keText.setText(EnergySkateParkResources.getString("energy.kinetic.abbreviation") + " = " + decimalFormat.format(d2) + " J");
        this.peText.setText(EnergySkateParkResources.getString("energy.potential.abbreviation") + " = " + decimalFormat.format(d3) + " J");
        this.totalText.setText(EnergySkateParkResources.getString("energy.total") + " = " + decimalFormat.format(d4) + " J");
    }

    private void updateCursor(JFreeChartCursorNode jFreeChartCursorNode, TimeSeriesModel timeSeriesModel) {
        jFreeChartCursorNode.setVisible(timeSeriesModel.isPaused() || timeSeriesModel.isPlaybackMode());
        jFreeChartCursorNode.setTime(timeSeriesModel.getPlaybackTime());
    }

    private EnergySkateParkModel getEnergySkateParkModel() {
        return this.model;
    }

    public boolean isVisible() {
        return this.dialog.isVisible();
    }

    public void setVisible(boolean bl) {
        if (bl != this.dialog.isVisible()) {
            this.dialog.setVisible(bl);
            this.relayout();
            this.notifyVisibilityChanged();
        }
    }

    private void relayout() {
        this.dynamicJFreeChartNode.setBounds(0.0, 0.0, (double)this.phetPCanvas.getWidth() - this.zoomControlNode.getFullBounds().getWidth(), this.phetPCanvas.getHeight());
        this.zoomControlNode.setOffset(this.dynamicJFreeChartNode.getDataArea().getMaxX(), this.dynamicJFreeChartNode.getDataArea().getCenterY());
        this.thermalPText.setOffset(this.dynamicJFreeChartNode.getDataArea().getX() + 2.0, this.dynamicJFreeChartNode.getDataArea().getY());
        this.totalText.setOffset(this.dynamicJFreeChartNode.getDataArea().getX() + 2.0, this.thermalPText.getFullBounds().getMaxY() + 5.0);
        this.keText.setOffset(this.dynamicJFreeChartNode.getDataArea().getCenterX(), this.dynamicJFreeChartNode.getDataArea().getY());
        this.peText.setOffset(this.dynamicJFreeChartNode.getDataArea().getCenterX(), this.keText.getFullBounds().getMaxY() + 5.0);
    }

    public void reset() {
        this.dialog.setVisible(false);
        this.clear();
    }

    private void clear() {
        this.dynamicJFreeChartNode.clear();
        this.playbackPanel.reset();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyVisibilityChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).visibilityChanged();
        }
    }

    public static interface Listener {
        public void visibilityChanged();
    }

    public class ReadoutTextNode
    extends PhetPNode {
        private final ShadowPText text = new ShadowPText(" ");
        private final PPath background;

        public ReadoutTextNode(Color color) {
            this.text.setFont(new PhetFont(1, 14));
            this.text.setTextPaint(color);
            this.text.setShadowColor(Color.black);
            this.background = new PhetPPath((Shape)this.text.getFullBounds(), EnergyLookAndFeel.getLegendBackground());
            this.addChild(this.background);
            this.addChild(this.text);
        }

        public void setText(String string) {
            this.text.setText(string);
            this.background.setPathTo(this.text.getFullBounds());
        }
    }
}

