/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.plots;

import edu.colorado.phet.energyskatepark.AbstractEnergySkateParkModule;
import edu.colorado.phet.energyskatepark.plots.VerticalZoomControl;
import edu.colorado.phet.energyskatepark.plots.bargraphs.EnergySkateParkBarGraph;
import edu.colorado.phet.energyskatepark.view.swing.ClearHeatButton;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;

public class BarGraphCanvas
extends PSwingCanvas {
    private final AbstractEnergySkateParkModule module;
    private final PSwing clearHeatButton;
    private final VerticalZoomControl verticalZoomControl;

    public BarGraphCanvas(AbstractEnergySkateParkModule abstractEnergySkateParkModule) {
        this.module = abstractEnergySkateParkModule;
        final EnergySkateParkBarGraph energySkateParkBarGraph = new EnergySkateParkBarGraph(abstractEnergySkateParkModule.getEnergySkateParkSimulationPanel(), abstractEnergySkateParkModule.getEnergySkateParkModel(), 0.08);
        this.getLayer().addChild(energySkateParkBarGraph);
        energySkateParkBarGraph.translate(45.0, 45.0);
        ClearHeatButton clearHeatButton = new ClearHeatButton(abstractEnergySkateParkModule.getEnergySkateParkModel());
        this.clearHeatButton = new PSwing(clearHeatButton);
        this.getLayer().addChild(this.clearHeatButton);
        this.setPanEventHandler(null);
        this.setZoomEventHandler(null);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                BarGraphCanvas.this.updateLayout();
            }
        });
        final NumberAxis numberAxis = new NumberAxis();
        numberAxis.addChangeListener(new AxisChangeListener(){

            public void axisChanged(AxisChangeEvent axisChangeEvent) {
                BarGraphCanvas.this.updateZoom(energySkateParkBarGraph, numberAxis);
            }
        });
        this.updateZoom(energySkateParkBarGraph, numberAxis);
        this.verticalZoomControl = new VerticalZoomControl(numberAxis);
        this.getLayer().addChild(this.verticalZoomControl);
        this.updateLayout();
    }

    private void updateZoom(EnergySkateParkBarGraph energySkateParkBarGraph, NumberAxis numberAxis) {
        double d = Math.abs(numberAxis.getLowerBound() - numberAxis.getUpperBound());
        energySkateParkBarGraph.setBarScale(500.0 / d);
    }

    private void updateLayout() {
        int n = 2;
        int n2 = 2;
        this.clearHeatButton.setOffset(n2, (double)this.getHeight() - this.clearHeatButton.getFullBounds().getHeight() - (double)n);
        this.verticalZoomControl.setOffset((double)this.getWidth() - this.verticalZoomControl.getFullBounds().getWidth() - (double)n2, (double)this.getHeight() - this.verticalZoomControl.getFullBounds().getHeight() - (double)n);
    }

    public void reset() {
        this.verticalZoomControl.setZoom(0);
    }
}

