/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model.physics;

import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.energyskatepark.model.physics.Particle;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;

public class ParticleNode
extends PNode {
    private final Particle particle;
    private final PhetPPath phetPPath;

    public ParticleNode(final Particle particle) {
        this.particle = particle;
        Color color = Color.yellow;
        this.phetPPath = new PhetPPath(this.toTransparentColor(color, 128), (Stroke)new BasicStroke(0.02f), (Paint)PhetColorScheme.RED_COLORBLIND);
        double d = 0.3f;
        this.phetPPath.setPathTo(new Ellipse2D.Double(0.0, 0.0, d, d));
        this.addChild(this.phetPPath);
        particle.addListener(new Particle.Listener(){

            public void particleChanged() {
                ParticleNode.this.update();
            }
        });
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                particle.setPosition(new SerializablePoint2D(pInputEvent.getPositionRelativeTo(ParticleNode.this)));
                particle.setUserControlled(true);
                particle.setVelocity(0.0, 0.0);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                particle.setUserControlled(false);
                particle.setFreeFall();
            }
        });
        this.update();
    }

    private Color toTransparentColor(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public void update() {
        this.phetPPath.setOffset(this.particle.getX() - this.phetPPath.getWidth() / 2.0, this.particle.getY() - this.phetPPath.getHeight() / 2.0);
        this.phetPPath.setPaint(this.toTransparentColor(this.getParticleColor(), 128));
        this.phetPPath.setStrokePaint(this.getColorForTop());
    }

    private Paint getColorForTop() {
        if (this.particle.isFreeFall()) {
            return this.particle.isAboveSplineZero() ? Color.green : Color.black;
        }
        return this.particle.isAboveSpline1D() ? Color.green : Color.yellow;
    }

    private Color getParticleColor() {
        if (this.particle.isFreeFall()) {
            return Color.blue;
        }
        return PhetColorScheme.RED_COLORBLIND;
    }
}

