/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model;

import edu.colorado.phet.energyskatepark.AbstractEnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import java.awt.Color;
import java.awt.Paint;

public abstract class Planet {
    private final String name;
    private final double gravity;
    private final Paint groundPaint;
    private final Paint groundLinePaint;
    private final boolean groundVisible;

    protected Planet(String string, double d, Paint paint, Paint paint2, boolean bl) {
        this.gravity = d;
        this.name = string;
        this.groundPaint = paint;
        this.groundLinePaint = paint2;
        this.groundVisible = bl;
    }

    public String getName() {
        return this.name;
    }

    public double getGravity() {
        return this.gravity;
    }

    public void apply(AbstractEnergySkateParkModule abstractEnergySkateParkModule) {
        this.setupImage(abstractEnergySkateParkModule);
        this.setupGravity(abstractEnergySkateParkModule);
    }

    private void setupGravity(AbstractEnergySkateParkModule abstractEnergySkateParkModule) {
        abstractEnergySkateParkModule.getEnergySkateParkModel().setGravity(this.gravity);
    }

    protected abstract void setupImage(AbstractEnergySkateParkModule var1);

    public boolean isDefault() {
        return false;
    }

    public Paint getGroundPaint() {
        return this.groundPaint;
    }

    public Paint getGroundLinePaint() {
        return this.groundLinePaint;
    }

    public boolean isGroundVisible() {
        return this.groundVisible;
    }

    public static class Earth
    extends Planet {
        public Earth() {
            super(EnergySkateParkResources.getString("location.earth"), -9.81, new Color(100, 170, 100), new Color(0, 130, 0), true);
        }

        protected void setupImage(AbstractEnergySkateParkModule abstractEnergySkateParkModule) {
            abstractEnergySkateParkModule.getEnergySkateParkSimulationPanel().getRootNode().setBackground(EnergySkateParkResources.getImage("earth-background.jpg"));
        }

        public boolean isDefault() {
            return true;
        }
    }

    public static class Jupiter
    extends Planet {
        public Jupiter() {
            super(EnergySkateParkResources.getString("location.jupiter"), -25.95, new Color(173, 114, 98), new Color(62, 44, 58), true);
        }

        protected void setupImage(AbstractEnergySkateParkModule abstractEnergySkateParkModule) {
            abstractEnergySkateParkModule.getEnergySkateParkSimulationPanel().getRootNode().setBackground(EnergySkateParkResources.getImage("jupiter4.jpg"));
        }
    }

    public static class Moon
    extends Planet {
        public Moon() {
            super(EnergySkateParkResources.getString("location.moon"), -1.62, Color.gray, Color.darkGray, true);
        }

        protected void setupImage(AbstractEnergySkateParkModule abstractEnergySkateParkModule) {
            abstractEnergySkateParkModule.getEnergySkateParkSimulationPanel().getRootNode().setBackground(EnergySkateParkResources.getImage("moon2.jpg"));
        }
    }

    public static class Space
    extends Planet {
        public Space() {
            super(EnergySkateParkResources.getString("location.space"), 0.0, Color.black, Color.black, false);
        }

        protected void setupImage(AbstractEnergySkateParkModule abstractEnergySkateParkModule) {
            abstractEnergySkateParkModule.getEnergySkateParkSimulationPanel().getRootNode().setBackground(EnergySkateParkResources.getImage("blackhole_large_2.jpg"));
        }

        public boolean isGroundVisible() {
            return false;
        }
    }
}

