/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model;

import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.persistence.PersistenceUtil;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.spline.ControlPointParametricFunction2D;
import edu.colorado.phet.common.spline.CubicSpline2D;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnergySkateParkSpline
implements Serializable {
    private final DefaultTrackSpline parametricFunction2D;
    private boolean rollerCoaster;
    private boolean userControlled;
    private final boolean interactive = true;
    private transient ArrayList listeners = new ArrayList();

    public EnergySkateParkSpline(SerializablePoint2D[] serializablePoint2DArray) {
        this(new DefaultTrackSpline(serializablePoint2DArray));
    }

    private EnergySkateParkSpline(DefaultTrackSpline defaultTrackSpline) {
        this.parametricFunction2D = defaultTrackSpline;
    }

    public boolean isUserControlled() {
        return this.userControlled;
    }

    public String toString() {
        return "fn=" + this.parametricFunction2D;
    }

    public EnergySkateParkSpline copy() {
        try {
            return (EnergySkateParkSpline)PersistenceUtil.copy(this);
        }
        catch (PersistenceUtil.CopyFailedException copyFailedException) {
            copyFailedException.printStackTrace();
            throw new RuntimeException(copyFailedException);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof EnergySkateParkSpline) {
            EnergySkateParkSpline energySkateParkSpline = (EnergySkateParkSpline)object;
            return energySkateParkSpline.parametricFunction2D.equals(this.parametricFunction2D) && energySkateParkSpline.rollerCoaster == this.rollerCoaster && energySkateParkSpline.userControlled == this.userControlled && energySkateParkSpline.interactive;
        }
        return false;
    }

    public ControlPointParametricFunction2D getParametricFunction2D() {
        return this.parametricFunction2D;
    }

    public void setRollerCoasterMode(boolean bl) {
        if (bl != this.rollerCoaster) {
            this.rollerCoaster = bl;
            this.parametricFunction2D.rollerCoasterMode = bl;
            this.notifyRollerCoasterModeChanged();
        }
    }

    public boolean isRollerCoasterMode() {
        return this.rollerCoaster;
    }

    public void setUserControlled(boolean bl) {
        this.userControlled = bl;
    }

    public SerializablePoint2D[] getControlPoints() {
        return this.parametricFunction2D.getControlPoints();
    }

    public boolean isInteractive() {
        return true;
    }

    public GeneralPath getInterpolationPath() {
        return this.createInterpolationPath();
    }

    private GeneralPath createInterpolationPath() {
        SerializablePoint2D[] serializablePoint2DArray = this.getInterpolationPoints();
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(serializablePoint2DArray[0].getX(), serializablePoint2DArray[0].getY());
        for (int i = 1; i < serializablePoint2DArray.length; ++i) {
            doubleGeneralPath.lineTo(serializablePoint2DArray[i]);
        }
        return doubleGeneralPath.getGeneralPath();
    }

    private SerializablePoint2D[] getInterpolationPoints() {
        ArrayList<SerializablePoint2D> arrayList = new ArrayList<SerializablePoint2D>();
        for (double d = 0.0; d <= 1.0; d += 0.01) {
            arrayList.add(this.parametricFunction2D.evaluate(d));
        }
        arrayList.add(this.parametricFunction2D.evaluate(1.0));
        return arrayList.toArray(new SerializablePoint2D[0]);
    }

    public SerializablePoint2D getControlPoint(int n) {
        return this.getControlPoints()[n];
    }

    public void translate(double d, double d2) {
        if (d != 0.0 || d2 != 0.0) {
            this.parametricFunction2D.translateControlPoints(d, d2);
            this.notifyControlPointsChanged();
        }
    }

    private void notifyControlPointsChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.controlPointsChanged();
        }
    }

    public int numControlPoints() {
        return this.getControlPoints().length;
    }

    public void translateControlPoint(int n, double d, double d2) {
        this.parametricFunction2D.translateControlPoint(n, d, d2);
        this.notifyControlPointsChanged();
    }

    public void removeControlPoint(int n) {
        this.parametricFunction2D.removeControlPoint(n);
        this.notifyControlPointsChanged();
    }

    public void setControlPointLocation(int n, SerializablePoint2D serializablePoint2D) {
        this.parametricFunction2D.setControlPoint(n, serializablePoint2D);
        this.notifyControlPointsChanged();
    }

    public double getMinControlPointY() {
        ArrayList<Double> arrayList = this.getSortedYControlPointValues();
        return arrayList.get(0);
    }

    public double getMinControlPointX() {
        ArrayList<Double> arrayList = this.getSortedXControlPointValues();
        return arrayList.get(0);
    }

    public double getMaxControlPointX() {
        ArrayList<Double> arrayList = this.getSortedXControlPointValues();
        return arrayList.get(arrayList.size() - 1);
    }

    public double getMaxControlPointY() {
        ArrayList<Double> arrayList = this.getSortedYControlPointValues();
        return arrayList.get(arrayList.size() - 1);
    }

    private ArrayList<Double> getSortedYControlPointValues() {
        ArrayList<Double> arrayList = new ArrayList<Double>(){
            {
                for (int i = 0; i < EnergySkateParkSpline.this.getControlPoints().length; ++i) {
                    SerializablePoint2D serializablePoint2D = EnergySkateParkSpline.this.getControlPoints()[i];
                    this.add(serializablePoint2D.getY());
                }
            }
        };
        Collections.sort(arrayList);
        return arrayList;
    }

    private ArrayList<Double> getSortedXControlPointValues() {
        ArrayList<Double> arrayList = new ArrayList<Double>(){
            {
                for (int i = 0; i < EnergySkateParkSpline.this.getControlPoints().length; ++i) {
                    SerializablePoint2D serializablePoint2D = EnergySkateParkSpline.this.getControlPoints()[i];
                    this.add(serializablePoint2D.getX());
                }
            }
        };
        Collections.sort(arrayList);
        return arrayList;
    }

    public ObservableList<SerializablePoint2D> sample100() {
        ArrayList<SerializablePoint2D> arrayList = new ArrayList<SerializablePoint2D>();
        for (int i = 0; i < 100; ++i) {
            SerializablePoint2D serializablePoint2D = this.parametricFunction2D.evaluate((double)i / 100.0);
            arrayList.add(serializablePoint2D);
        }
        return new ObservableList<SerializablePoint2D>(arrayList);
    }

    public double getMinY() {
        return this.sample100().map(new Function1<SerializablePoint2D, Double>(){

            @Override
            public Double apply(SerializablePoint2D serializablePoint2D) {
                return serializablePoint2D.getY();
            }
        }).min();
    }

    public double getMaxY() {
        return this.sample100().map(new Function1<SerializablePoint2D, Double>(){

            @Override
            public Double apply(SerializablePoint2D serializablePoint2D) {
                return serializablePoint2D.getY();
            }
        }).max();
    }

    public double getMinX() {
        return this.sample100().map(new Function1<SerializablePoint2D, Double>(){

            @Override
            public Double apply(SerializablePoint2D serializablePoint2D) {
                return serializablePoint2D.getX();
            }
        }).min();
    }

    public double getMaxX() {
        return this.sample100().map(new Function1<SerializablePoint2D, Double>(){

            @Override
            public Double apply(SerializablePoint2D serializablePoint2D) {
                return serializablePoint2D.getX();
            }
        }).max();
    }

    public void addListener(Listener listener) {
        this.createListenerArray();
        this.listeners.add(listener);
    }

    private void createListenerArray() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
    }

    public void removeListener(Listener listener) {
        this.createListenerArray();
        this.listeners.remove(listener);
    }

    private void notifyRollerCoasterModeChanged() {
        this.createListenerArray();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).rollerCoasterModeChanged();
        }
    }

    public static class DefaultTrackSpline
    extends CubicSpline2D {
        private boolean rollerCoasterMode = false;

        public DefaultTrackSpline(SerializablePoint2D[] serializablePoint2DArray) {
            super(serializablePoint2DArray);
        }

        public boolean isRollerCoasterMode() {
            return this.rollerCoasterMode;
        }
    }

    public static interface Listener {
        public void rollerCoasterModeChanged();

        public void controlPointsChanged();
    }
}

