/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model;

import edu.colorado.phet.common.phetcommon.util.persistence.PersistenceUtil;
import edu.colorado.phet.common.spline.ParametricFunction2D;
import edu.colorado.phet.energyskatepark.common.OptionalItemSerializableList;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSplineListAdapter;
import edu.colorado.phet.energyskatepark.model.Floor;
import edu.colorado.phet.energyskatepark.model.HistoryPoint;
import edu.colorado.phet.energyskatepark.model.physics.ParticleStage;
import edu.colorado.phet.energyskatepark.view.SkaterCharacter;
import edu.colorado.phet.energyskatepark.view.SkaterCharacterSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EnergySkateParkModel
implements Serializable {
    private double time = 0.0;
    private ArrayList history = new ArrayList();
    private ArrayList bodies = new ArrayList();
    private ArrayList<EnergySkateParkSpline> splines = new ArrayList();
    private Floor floor;
    private double gravity = -9.81;
    private double zeroPointPotentialY;
    private final List listeners = new OptionalItemSerializableList();
    private boolean recordPath = false;
    private double initZeroPointPotentialY;
    private final double floorFriction;
    private int maxNumHistoryPoints = 100;
    private final ParticleStage particleStage;
    private SkaterCharacter skaterCharacter = SkaterCharacterSet.getDefaultCharacter();
    private final Body.ListenerAdapter primaryBodyAdapter = new PrimaryBodyListenerAdapter();
    private boolean rollerCoasterMode;

    public EnergySkateParkModel(double d, double d2) {
        this.zeroPointPotentialY = d;
        this.initZeroPointPotentialY = d;
        this.floorFriction = d2;
        this.particleStage = new EnergySkateParkSplineListAdapter(this);
        this.updateFloorState();
    }

    public Body createBody() {
        return new Body(this.getSkaterCharacter().getModelWidth(), this.getSkaterCharacter().getModelHeight(), this.particleStage, this.getGravity(), this.getZeroPointPotentialY(), this.getSkaterCharacter());
    }

    public int getNumSplines() {
        return this.splines.size();
    }

    public double getTime() {
        return this.time;
    }

    public void setRecordPath(boolean bl) {
        this.recordPath = bl;
    }

    public boolean containsBody(Body body) {
        return this.bodies.contains(body);
    }

    public void clearHistory() {
        this.history.clear();
        this.notifyHistoryChanged();
    }

    public void clearHeat() {
        for (int i = 0; i < this.bodies.size(); ++i) {
            Body body = (Body)this.bodies.get(i);
            body.clearHeat();
        }
    }

    public void setGravity(double d) {
        if (this.gravity != d) {
            this.gravity = d;
            this.notifyGravityChanged();
            for (int i = 0; i < this.bodies.size(); ++i) {
                Body body = (Body)this.bodies.get(i);
                body.setGravityState(this.getGravity(), this.getZeroPointPotentialY());
            }
            this.updateFloorState();
        }
    }

    private void notifyGravityChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EnergyModelListener energyModelListener = (EnergyModelListener)this.listeners.get(i);
            energyModelListener.gravityChanged();
        }
    }

    public void removeAllSplineSurfaces() {
        while (this.splines.size() > 0) {
            this.removeSplineSurface(this.getSpline(0));
        }
    }

    public void removeAllBodies() {
        while (this.bodies.size() > 0) {
            this.removeBody(0);
        }
    }

    public void removeBody(int n) {
        this.removeListeners(this.getBody(n));
        this.bodies.remove(n);
        this.notifyBodyCountChanged();
    }

    private void removeListeners(Body body) {
        body.removeListener(this.primaryBodyAdapter);
    }

    public void updateFloorState() {
        boolean bl;
        boolean bl2 = bl = Math.abs(this.getGravity()) > 0.0;
        if (bl) {
            this.floor = new Floor(this.floorFriction);
        } else {
            this.detachFromFloor();
            this.floor = null;
        }
        this.notifyFloorChanged();
    }

    private void detachFromFloor() {
        for (int i = 0; i < this.bodies.size(); ++i) {
            Body body = (Body)this.bodies.get(i);
            if (!body.isOnFloor()) continue;
            body.setFreeFallMode();
        }
    }

    private void notifyFloorChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EnergyModelListener energyModelListener = (EnergyModelListener)this.listeners.get(i);
            energyModelListener.floorChanged();
        }
    }

    public Floor getFloor() {
        return this.floor;
    }

    public EnergySkateParkModel copyState() {
        try {
            return (EnergySkateParkModel)PersistenceUtil.copy(this);
        }
        catch (PersistenceUtil.CopyFailedException copyFailedException) {
            copyFailedException.printStackTrace();
            return this;
        }
    }

    public void setState(EnergySkateParkModel energySkateParkModel) {
        int n;
        energySkateParkModel = energySkateParkModel.copyState();
        this.time = energySkateParkModel.time;
        this.maxNumHistoryPoints = energySkateParkModel.maxNumHistoryPoints;
        this.setSkaterCharacter(energySkateParkModel.getSkaterCharacter());
        for (n = 0; n < this.bodies.size(); ++n) {
            this.removeListeners((Body)this.bodies.get(n));
        }
        this.bodies = energySkateParkModel.bodies;
        this.notifyBodiesSynced();
        this.notifyPrimaryBodyChanged();
        this.splines = energySkateParkModel.splines;
        this.notifySplinesSynced();
        if (this.floor != null && energySkateParkModel.floor != null) {
            if (this.floor.getY() != energySkateParkModel.floor.getY()) {
                this.floor.setY(energySkateParkModel.floor.getY());
                this.notifyFloorChanged();
            }
        } else {
            this.floor = energySkateParkModel.floor;
            this.notifyFloorChanged();
        }
        if (this.floor == null) {
            this.detachFromFloor();
        }
        this.history = energySkateParkModel.history;
        this.notifyHistoryChanged();
        if (this.gravity != energySkateParkModel.gravity) {
            this.gravity = energySkateParkModel.gravity;
            this.notifyGravityChanged();
        }
        if (this.zeroPointPotentialY != energySkateParkModel.zeroPointPotentialY) {
            this.zeroPointPotentialY = energySkateParkModel.zeroPointPotentialY;
            this.notifyZeroPointPotentialYChanged();
        }
        for (n = 0; n < this.listeners.size(); ++n) {
            EnergyModelListener energyModelListener = (EnergyModelListener)this.listeners.get(n);
            energyModelListener.stateSet();
        }
    }

    private void notifyBodiesSynced() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EnergyModelListener energyModelListener = (EnergyModelListener)this.listeners.get(i);
            energyModelListener.bodiesSynced();
        }
    }

    private void notifySplinesSynced() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EnergyModelListener energyModelListener = (EnergyModelListener)this.listeners.get(i);
            energyModelListener.splinesSynced();
        }
    }

    private void notifyHistoryChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((EnergyModelListener)this.listeners.get(i)).historyChanged();
        }
    }

    public EnergySkateParkSpline getEnergySkateParkSpline(ParametricFunction2D parametricFunction2D) {
        for (EnergySkateParkSpline energySkateParkSpline : this.splines) {
            if (energySkateParkSpline.getParametricFunction2D() != parametricFunction2D) continue;
            return energySkateParkSpline;
        }
        return null;
    }

    private double timeSinceLastHistory() {
        if (this.history.size() == 0) {
            return this.time;
        }
        return this.time - this.historyPointAt(this.history.size() - 1).getTime();
    }

    public void stepInTime(double d) {
        this.time += d;
        this.updateHistory();
        this.notifyPreStep(d);
        for (int i = 0; i < this.bodies.size(); ++i) {
            Body body = (Body)this.bodies.get(i);
            body.stepInTime(d);
        }
    }

    private void notifyPreStep(double d) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EnergyModelListener energyModelListener = (EnergyModelListener)this.listeners.get(i);
            energyModelListener.preStep();
        }
    }

    private void updateHistory() {
        boolean bl = false;
        if (this.recordPath && this.getNumBodies() > 0 && this.timeSinceLastHistory() > 0.1) {
            this.history.add(new HistoryPoint(this.getTime(), this.getBody(0)));
            bl = true;
        }
        if (this.history.size() > this.maxNumHistoryPoints) {
            this.history.remove(0);
            bl = true;
        }
        if (bl) {
            this.notifyHistoryChanged();
        }
    }

    public EnergySkateParkSpline getSpline(int n) {
        return this.splines.get(n);
    }

    public void addSplineSurface(EnergySkateParkSpline energySkateParkSpline) {
        energySkateParkSpline.setRollerCoasterMode(this.rollerCoasterMode);
        this.splines.add(energySkateParkSpline);
        this.notifySplineCountChanged();
    }

    private void notifySplineCountChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EnergyModelListener energyModelListener = (EnergyModelListener)this.listeners.get(i);
            energyModelListener.splineCountChanged();
        }
    }

    public void addBody(Body body) {
        this.bodies.add(body);
        if (this.bodies.size() == 1) {
            this.initZeroPointPotentialY = this.zeroPointPotentialY = 0.0;
            body.addListener(this.primaryBodyAdapter);
            this.notifyPrimaryBodyChanged();
        }
        this.notifyBodyCountChanged();
    }

    private void notifyPrimaryBodyChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EnergyModelListener energyModelListener = (EnergyModelListener)this.listeners.get(i);
            energyModelListener.primaryBodyChanged();
        }
    }

    private void notifyBodyCountChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EnergyModelListener energyModelListener = (EnergyModelListener)this.listeners.get(i);
            energyModelListener.bodyCountChanged();
        }
    }

    public int getNumBodies() {
        return this.bodies.size();
    }

    public Body getBody(int n) {
        return (Body)this.bodies.get(n);
    }

    public double getGravity() {
        return this.gravity;
    }

    public void removeSplineSurface(EnergySkateParkSpline energySkateParkSpline) {
        this.detachBodies(energySkateParkSpline.getParametricFunction2D());
        this.splines.remove(energySkateParkSpline);
        this.notifySplineCountChanged();
    }

    private void detachBodies(ParametricFunction2D parametricFunction2D) {
        for (int i = 0; i < this.bodies.size(); ++i) {
            Body body = (Body)this.bodies.get(i);
            if (!body.isOnSpline(parametricFunction2D)) continue;
            body.setFreeFallMode();
        }
    }

    public double getZeroPointPotentialY() {
        return this.zeroPointPotentialY;
    }

    public void setZeroPointPotentialY(double d) {
        this.zeroPointPotentialY = d;
        for (int i = 0; i < this.bodies.size(); ++i) {
            Body body = (Body)this.bodies.get(i);
            body.setGravityState(this.getGravity(), d);
        }
        this.notifyZeroPointPotentialYChanged();
    }

    private void notifyZeroPointPotentialYChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EnergyModelListener energyModelListener = (EnergyModelListener)this.listeners.get(i);
            energyModelListener.zeroPointPotentialYChanged();
        }
    }

    public void translateZeroPointPotentialY(double d) {
        this.setZeroPointPotentialY(this.getZeroPointPotentialY() + d);
    }

    public void reset() {
        this.setRollerCoasterMode(false);
        this.removeAllBodies();
        this.removeAllSplineSurfaces();
        this.clearHistory();
        this.setGravity(-9.81);
        this.setZeroPointPotentialY(this.initZeroPointPotentialY);
        this.updateFloorState();
        this.setSkaterCharacter(SkaterCharacterSet.getDefaultCharacter());
    }

    public void setSkaterCharacter(SkaterCharacter skaterCharacter) {
        if (!this.skaterCharacter.equals(skaterCharacter)) {
            this.skaterCharacter = skaterCharacter;
            for (int i = 0; i < this.bodies.size(); ++i) {
                Body body = (Body)this.bodies.get(i);
                body.setSkaterCharacter(skaterCharacter);
            }
            this.notifySkaterCharacterChanged();
        }
    }

    private void notifySkaterCharacterChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EnergyModelListener energyModelListener = (EnergyModelListener)this.listeners.get(i);
            energyModelListener.skaterCharacterChanged();
        }
    }

    public SkaterCharacter getSkaterCharacter() {
        return this.skaterCharacter;
    }

    public void setRollerCoasterMode(boolean bl) {
        this.rollerCoasterMode = bl;
        for (EnergySkateParkSpline energySkateParkSpline : this.splines) {
            energySkateParkSpline.setRollerCoasterMode(bl);
        }
    }

    public void addEnergyModelListener(EnergyModelListener energyModelListener) {
        this.listeners.add(energyModelListener);
    }

    public int getNumHistoryPoints() {
        return this.history.size();
    }

    public HistoryPoint historyPointAt(int n) {
        return (HistoryPoint)this.history.get(n);
    }

    public static interface EnergyModelListener {
        public void preStep();

        public void gravityChanged();

        public void splineCountChanged();

        public void floorChanged();

        public void bodyCountChanged();

        public void historyChanged();

        public void zeroPointPotentialYChanged();

        public void splinesSynced();

        public void bodiesSynced();

        public void stateSet();

        public void skaterCharacterChanged();

        public void primaryBodyChanged();
    }

    public static class EnergyModelListenerAdapter
    implements EnergyModelListener {
        public void preStep() {
        }

        public void gravityChanged() {
        }

        public void splineCountChanged() {
        }

        public void floorChanged() {
        }

        public void bodyCountChanged() {
        }

        public void historyChanged() {
        }

        public void zeroPointPotentialYChanged() {
        }

        public void splinesSynced() {
        }

        public void bodiesSynced() {
        }

        public void stateSet() {
        }

        public void skaterCharacterChanged() {
        }

        public void primaryBodyChanged() {
        }
    }

    class PrimaryBodyListenerAdapter
    extends Body.ListenerAdapter
    implements Serializable {
        PrimaryBodyListenerAdapter() {
        }

        public void thrustChanged() {
            EnergySkateParkModel.this.notifyPrimaryBodyChanged();
        }

        public void energyChanged() {
            EnergySkateParkModel.this.notifyPrimaryBodyChanged();
        }

        public void positionAngleChanged() {
            EnergySkateParkModel.this.notifyPrimaryBodyChanged();
        }

        public void skaterCharacterChanged() {
            EnergySkateParkModel.this.notifyPrimaryBodyChanged();
        }

        public void dimensionChanged() {
            EnergySkateParkModel.this.notifyPrimaryBodyChanged();
        }

        public void restorePointChanged() {
            EnergySkateParkModel.this.notifyPrimaryBodyChanged();
        }
    }
}

