/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.persistence.PersistenceUtil;
import edu.colorado.phet.common.spline.ParametricFunction2D;
import edu.colorado.phet.energyskatepark.common.OptionalItemSerializableList;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;
import edu.colorado.phet.energyskatepark.model.LinearFloorSpline2D;
import edu.colorado.phet.energyskatepark.model.TraversalState;
import edu.colorado.phet.energyskatepark.model.physics.Particle;
import edu.colorado.phet.energyskatepark.model.physics.ParticleStage;
import edu.colorado.phet.energyskatepark.util.EnergySkateParkLogging;
import edu.colorado.phet.energyskatepark.view.SkaterCharacter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Body
implements Serializable {
    private Body restorePoint = null;
    private final Particle particle;
    private boolean facingRight;
    private double width;
    private double height;
    private double angularVelocity = 0.0;
    private int errorCount = 0;
    private double fractionalEnergyError = 0.0;
    private final List listeners = new OptionalItemSerializableList();
    public static final List particles = new ArrayList();
    public static double staticSticky = 0.9;
    private SkaterCharacter skaterCharacter;

    public Body(double d, double d2, ParticleStage particleStage, double d3, double d4, SkaterCharacter skaterCharacter) {
        this.width = d;
        this.height = d2;
        this.skaterCharacter = skaterCharacter;
        this.particle = new Particle(particleStage);
        this.particle.setMass(75.0);
        this.particle.getParticle1D().setReflect(false);
        this.particle.setStickiness(staticSticky);
        this.setGravityState(d3, d4);
        particles.add(this);
        this.reset();
    }

    public void setSpline(EnergySkateParkSpline energySkateParkSpline, boolean bl, double d) {
        this.switchToTrack(energySkateParkSpline.getParametricFunction2D(), bl, d);
    }

    public void switchToTrack(ParametricFunction2D parametricFunction2D, boolean bl, double d) {
        this.particle.switchToTrack(parametricFunction2D, d, bl);
    }

    public void setFreeFallMode() {
        this.particle.setFreeFall();
    }

    public void setPosition(double d, double d2) {
        SerializablePoint2D serializablePoint2D = this.getPosition();
        this.particle.setPosition(d, d2);
        if (!serializablePoint2D.equals(this.getPosition())) {
            this.notifyPositionAngleChanged();
        }
    }

    public boolean isRestorePointSet() {
        return this.restorePoint != null;
    }

    public void deleteRestorePoint() {
        this.restorePoint = null;
    }

    public void reset() {
        this.setFreeFallMode();
        this.particle.setVelocity(0.0, 0.0);
        this.setThermalEnergy(0.0);
        if (!this.isRestorePointSet()) {
            this.setAngularVelocity(0.0);
            this.setVelocity(0.0, 0.0);
            this.setPosition(4.5, 6.0);
            this.setAngle(0.0);
        } else {
            this.setPosition(this.restorePoint.getPosition());
            this.setAngularVelocity(this.restorePoint.getAngularVelocity());
            this.setVelocity(this.restorePoint.getVelocity());
            this.setAngle(this.restorePoint.particle.getAngle());
        }
    }

    private void setThermalEnergy(double d) {
        this.particle.setThermalEnergy(d);
        this.notifyEnergyChanged();
    }

    private void notifyEnergyChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.energyChanged();
        }
    }

    public void setGravityState(double d, double d2) {
        this.particle.setGravity(d);
        this.particle.setZeroPointPotentialY(d2);
    }

    public void stepInTime(double d) {
        double d2;
        double d3 = this.getAngle();
        SerializablePoint2D serializablePoint2D = this.getPosition();
        double d4 = this.getTotalEnergy();
        this.particle.stepInTime(d);
        this.updateStateFromParticle();
        if (this.getY() < -0.1 && this.isFreeFallMode() && Math.abs(this.getGravity()) > 0.0) {
            this.setPosition(this.getX(), 0.1);
        }
        if (d3 != this.getAngle() || !serializablePoint2D.equals(this.getPosition())) {
            this.notifyPositionAngleChanged();
        }
        if ((d2 = Math.abs(d4 - this.getTotalEnergy())) > 1.0E-5 && this.getThrust().getMagnitude() == 0.0 && !this.isUserControlled() && !this.isSplineUserControlled()) {
            EnergySkateParkLogging.println("err = " + d2);
            ++this.errorCount;
            this.fractionalEnergyError += d2 / Math.abs(d4);
        }
    }

    private boolean isSplineUserControlled() {
        return this.particle.isSplineUserControlled();
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public double getFractionalEnergyError() {
        return this.fractionalEnergyError;
    }

    public void updateStateFromParticle() {
        if (this.getSpeed() > 0.01 && !this.isFreeFallMode() && !this.isUserControlled()) {
            this.facingRight = this.getVelocity().dot(Vector2D.createPolar(1.0, this.getAngle())) > 0.0;
        }
    }

    public double getY() {
        return this.getCenterOfMass().getY();
    }

    public double getX() {
        return this.getCenterOfMass().getX();
    }

    public SerializablePoint2D getCenterOfMass() {
        return this.particle.getPosition();
    }

    public ImmutableVector2D getVelocity() {
        return this.particle.getVelocity();
    }

    public void setVelocity(ImmutableVector2D immutableVector2D) {
        this.setVelocity(immutableVector2D.getX(), immutableVector2D.getY());
    }

    public void setVelocity(double d, double d2) {
        this.particle.setVelocity(d, d2);
        this.updateStateFromParticle();
        this.notifyEnergyChanged();
    }

    public void setMass(double d) {
        this.particle.setMass(d);
        this.notifyEnergyChanged();
    }

    public boolean isUserControlled() {
        return this.particle.isUserControlled();
    }

    public void setUserControlled(boolean bl) {
        this.particle.setUserControlled(bl);
        if (!bl) {
            this.snapToTrack();
            try {
                this.restorePoint = (Body)PersistenceUtil.copy(this);
            }
            catch (PersistenceUtil.CopyFailedException copyFailedException) {
                copyFailedException.printStackTrace();
            }
        }
        this.notifyEnergyChanged();
    }

    private void snapToTrack() {
        TraversalState traversalState = this.getSnapTrackMatch();
        if (traversalState != null) {
            EnergySkateParkLogging.println("match = " + traversalState);
            this.setPosition(traversalState.getPosition().getX(), traversalState.getPosition().getY() + 1.0E-4);
        }
    }

    private TraversalState getSnapTrackMatch() {
        TraversalState[] traversalStateArray = new TraversalState[]{this.getTrackMatch(0.0, 0.2), this.getTrackMatch(-0.1, 0.1), this.getTrackMatch(0.1, 0.1)};
        TraversalState traversalState = null;
        for (int i = 0; i < traversalStateArray.length; ++i) {
            if (traversalStateArray[i] == null) continue;
            traversalState = traversalStateArray[i];
            break;
        }
        return traversalState;
    }

    public Body getRestorePoint() {
        try {
            return (Body)PersistenceUtil.copy(this.restorePoint);
        }
        catch (PersistenceUtil.CopyFailedException copyFailedException) {
            copyFailedException.printStackTrace();
            throw new RuntimeException(copyFailedException);
        }
    }

    public double getHeight() {
        return this.height;
    }

    public SerializablePoint2D getPosition() {
        return this.particle.getPosition();
    }

    public double getMass() {
        return this.particle.getMass();
    }

    public double getSpeed() {
        return this.getVelocity().getMagnitude();
    }

    public void setPosition(SerializablePoint2D serializablePoint2D) {
        this.setPosition(serializablePoint2D.getX(), serializablePoint2D.getY());
    }

    public double getKineticEnergy() {
        return 0.5 * this.getMass() * this.getSpeed() * this.getSpeed();
    }

    public double getAngle() {
        return this.particle.getAngle();
    }

    public boolean isFreeFallMode() {
        return this.particle.isFreeFall();
    }

    public boolean isFacingRight() {
        return this.facingRight;
    }

    public void setThrust(double d, double d2) {
        this.particle.setThrust(d, d2);
        this.notifyEnergyChanged();
        this.notifyThrustChanged();
    }

    public ImmutableVector2D getThrust() {
        return this.particle.getThrust();
    }

    public double getFrictionCoefficient() {
        return this.particle.getFrictionCoefficient();
    }

    public void setFrictionCoefficient(double d) {
        this.particle.setFrictionCoefficient(d);
    }

    public void setBounciness(double d) {
        this.particle.setElasticity(d);
    }

    public double getWidth() {
        return this.width;
    }

    public boolean isOnSpline(ParametricFunction2D parametricFunction2D) {
        return this.particle.isOnSpline(parametricFunction2D);
    }

    public double getMechanicalEnergy() {
        return this.getKineticEnergy() + this.getPotentialEnergy();
    }

    public double getTotalEnergy() {
        return this.getMechanicalEnergy() + this.getThermalEnergy();
    }

    public double getThermalEnergy() {
        return this.particle.getThermalEnergy();
    }

    public double getGravity() {
        return this.particle.getGravity();
    }

    public void clearHeat() {
        this.particle.resetThermalEnergy();
        this.notifyEnergyChanged();
    }

    public double getPotentialEnergy() {
        return this.particle.getPotentialEnergy();
    }

    public double getAngularVelocity() {
        return this.angularVelocity;
    }

    public void setAngularVelocity(double d) {
        this.angularVelocity = d;
    }

    public ParametricFunction2D getSpline() {
        return this.particle.getSpline();
    }

    public TraversalState getBestTraversalState(TraversalState traversalState) {
        ImmutableVector2D immutableVector2D = new Vector2D(traversalState.getParametricFunction2D().getUnitNormalVector(traversalState.getAlpha())).getScaledInstance(traversalState.isTop() ? 1.0 : -1.0);
        SerializablePoint2D serializablePoint2D = traversalState.getParametricFunction2D().evaluate(traversalState.getAlpha());
        return this.particle.getBestTraversalState(serializablePoint2D, immutableVector2D);
    }

    public TraversalState getTraversalState() {
        return this.particle.getTraversalState();
    }

    public TraversalState getTrackMatch(double d, double d2) {
        return this.particle.getTrackMatch(d, d2);
    }

    public void setAngle(double d) {
        double d2 = this.getAngle();
        this.particle.setAngle(d);
        if (d2 != d) {
            this.notifyPositionAngleChanged();
        }
    }

    private void notifyPositionAngleChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.positionAngleChanged();
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void setDimension(double d, double d2) {
        this.width = d;
        this.height = d2;
        this.notifyDimensionChanged();
    }

    private void notifyDimensionChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.dimensionChanged();
        }
    }

    public void clearEnergyError() {
        this.errorCount = 0;
        this.fractionalEnergyError = 0.0;
    }

    public void setStickiness(double d) {
        this.particle.setStickiness(d);
    }

    public ParticleStage getParticleStage() {
        return this.particle.getParticleStage();
    }

    public double getZeroPointPotentialY() {
        return this.particle.getZeroPointPotentialY();
    }

    public void setRestorePoint(Body body) {
        this.restorePoint = body;
        this.notifyRestorePointChanged();
    }

    private void notifyRestorePointChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.restorePointChanged();
        }
    }

    public boolean isKeepEnergyOnLanding() {
        return !this.particle.isConvertNormalVelocityToThermalOnLanding();
    }

    public void setKeepEnergyOnLanding(boolean bl) {
        this.particle.setConvertNormalVelocityToThermalOnLanding(!bl);
    }

    public void setSkaterCharacter(SkaterCharacter skaterCharacter) {
        this.skaterCharacter = skaterCharacter;
        this.setDimension(skaterCharacter.getModelWidth(), skaterCharacter.getModelHeight());
        this.setMass(skaterCharacter.getMass());
        this.notifySkaterCharacterChanged();
    }

    private void notifySkaterCharacterChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.skaterCharacterChanged();
        }
    }

    public SkaterCharacter getSkaterCharacter() {
        return this.skaterCharacter;
    }

    public boolean isOnFloor() {
        return this.particle.getSpline() instanceof LinearFloorSpline2D;
    }

    public double getHeightAboveZero() {
        return this.particle.getHeightAboveZero();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyThrustChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.thrustChanged();
        }
    }

    public static interface Listener {
        public void thrustChanged();

        public void energyChanged();

        public void dimensionChanged();

        public void positionAngleChanged();

        public void skaterCharacterChanged();

        public void restorePointChanged();
    }

    public static class ListenerAdapter
    implements Listener {
        public void thrustChanged() {
        }

        public void energyChanged() {
        }

        public void dimensionChanged() {
        }

        public void positionAngleChanged() {
        }

        public void skaterCharacterChanged() {
        }

        public void restorePointChanged() {
        }
    }
}

