/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.basics;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.energyskatepark.EnergySkateParkSimSharing;
import edu.colorado.phet.energyskatepark.basics.EnergySkateParkBasicsModule;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;

public class TrackButton
extends PNode {
    private static final Color INVISIBLE_COLOR = new Color(0, 0, 0, 0);

    public TrackButton(final EnergySkateParkBasicsModule energySkateParkBasicsModule, final String string, final ImmutableVector2D immutableVector2D) {
        PImage pImage = new PImage(this.createIcon(energySkateParkBasicsModule, string, immutableVector2D));
        this.addChild(pImage);
        final PhetPPath phetPPath = new PhetPPath(pImage.getFullBoundsReference().getBounds2D(), (Stroke)new BasicStroke(3.0f), (Paint)INVISIBLE_COLOR);
        this.addChild(phetPPath);
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                SimSharingManager.sendUserMessage(UserComponentChain.chain((IUserComponent)EnergySkateParkSimSharing.UserComponents.trackButton, string), UserComponentTypes.button, UserActions.pressed, ParameterSet.parameterSet((IParameterKey)EnergySkateParkSimSharing.ParameterKeys.trackName, string));
                energySkateParkBasicsModule.loadTrack(string, immutableVector2D);
            }
        });
        energySkateParkBasicsModule.currentTrackFileName.addObserver(new VoidFunction1<String>(){

            @Override
            public void apply(String string2) {
                phetPPath.setStrokePaint(string2.equalsIgnoreCase(string) ? Color.YELLOW : INVISIBLE_COLOR);
            }
        });
    }

    private BufferedImage createIcon(EnergySkateParkBasicsModule energySkateParkBasicsModule, String string, ImmutableVector2D immutableVector2D) {
        energySkateParkBasicsModule.loadTrack(string, immutableVector2D);
        BufferedImage bufferedImage = new BufferedImage(1024, 768, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        energySkateParkBasicsModule.getEnergySkateParkSimulationPanel().setSize(1024, 768);
        energySkateParkBasicsModule.getEnergySkateParkSimulationPanel().getRootNode().updateBackground();
        energySkateParkBasicsModule.getEnergySkateParkSimulationPanel().getRootNode().fullPaint(new PPaintContext(graphics2D));
        return BufferedImageUtils.multiScaleToWidth(bufferedImage, 100);
    }
}

