/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.DoubleProperty;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.piccolophet.SimSharingPiccoloModule;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.energyskatepark.EnergySkateParkResources;
import edu.colorado.phet.energyskatepark.model.Body;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkOptions;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkRecordableModel;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkSpline;
import edu.colorado.phet.energyskatepark.model.Planet;
import edu.colorado.phet.energyskatepark.model.PreFabSplines;
import edu.colorado.phet.energyskatepark.plots.BarChartDialog;
import edu.colorado.phet.energyskatepark.plots.EnergyPositionPlotDialog;
import edu.colorado.phet.energyskatepark.plots.EnergyTimePlot;
import edu.colorado.phet.energyskatepark.view.EnergyLookAndFeel;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;
import edu.colorado.phet.energyskatepark.view.SkaterCharacter;
import edu.colorado.phet.energyskatepark.view.SkaterCharacterSet;
import edu.colorado.phet.energyskatepark.view.WiggleMeInSpace;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnergySkateParkModule
extends SimSharingPiccoloModule {
    public final EnergySkateParkModel energyModel;
    public final EnergySkateParkSimulationPanel energySkateParkSimulationPanel;
    private final EnergyLookAndFeel energyLookAndFeel = new EnergyLookAndFeel();
    public final BarChartDialog barChartDialog;
    private final double floorY = 0.0;
    private final EnergySkateParkRecordableModel energyTimeSeriesModel;
    private final SkaterCharacterSet skaterCharacterSet = new SkaterCharacterSet();
    private final PhetFrame phetFrame;
    private final TimeSeriesModel timeSeriesModel;
    private final EnergyTimePlot energyTimePlot;
    private final EnergyPositionPlotDialog energyPositionPlotDialog;
    private final EnergySkateParkOptions options;
    public final boolean splinesMovable;
    public final boolean bumpUpSplines;
    private double coefficientOfFriction;
    public final BooleanProperty pieChartVisible = new BooleanProperty(false);
    public final BooleanProperty gridVisible = new BooleanProperty(false);
    public final BooleanProperty speedVisible = new BooleanProperty(false);
    public final BooleanProperty barChartVisible = new BooleanProperty(false);
    public final Property<Boolean> normalSpeed = new Property<Boolean>(true);
    private final Property<Option<Double>> primarySkaterSpeed = new Property<Option.Some<Double>>(new Option.Some<Double>(0.0));
    public final Property<Double> mass;
    public final Property<Integer> numberOfSplines = new Property<Integer>(0);
    private ArrayList<VoidFunction0> resetListeners = new ArrayList();
    public final boolean limitNumberOfTracks;
    public final boolean useTimeSlider;

    public AbstractEnergySkateParkModule(IUserComponent iUserComponent, String string, PhetFrame phetFrame, EnergySkateParkOptions energySkateParkOptions, boolean bl, boolean bl2, double d, boolean bl3, double d2, boolean bl4, boolean bl5) {
        super(iUserComponent, string, new ConstantDtClock(30, 0.03));
        this.splinesMovable = bl;
        this.bumpUpSplines = bl2;
        this.limitNumberOfTracks = bl4;
        this.useTimeSlider = bl5;
        ConstantDtClock constantDtClock = (ConstantDtClock)this.getClock();
        this.options = energySkateParkOptions;
        this.phetFrame = phetFrame;
        this.energyModel = new EnergySkateParkModel(0.0, d);
        this.setModel(new BaseModel());
        this.energyTimeSeriesModel = new EnergySkateParkRecordableModel(this.getEnergySkateParkModel()){

            public void setState(Object object) {
                super.setState(object);
                AbstractEnergySkateParkModule.this.updatePrimarySkaterSpeed();
            }

            public void stepInTime(double d) {
                super.stepInTime(d);
                AbstractEnergySkateParkModule.this.updatePrimarySkaterSpeed();
            }
        };
        this.energyModel.addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void splineCountChanged() {
                AbstractEnergySkateParkModule.this.numberOfSplines.set(AbstractEnergySkateParkModule.this.energyModel.getNumSplines());
            }
        });
        this.timeSeriesModel = new TimeSeriesModel(this.energyTimeSeriesModel, constantDtClock);
        this.timeSeriesModel.setMaxAllowedRecordTime(20.0);
        constantDtClock.addClockListener(this.timeSeriesModel);
        this.energySkateParkSimulationPanel = new EnergySkateParkSimulationPanel(this, bl3, d2);
        this.setSimulationPanel(this.energySkateParkSimulationPanel);
        this.barChartDialog = new BarChartDialog(phetFrame, EnergySkateParkResources.getString("plots.bar-graph"), false, this);
        this.barChartDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AbstractEnergySkateParkModule.this.barChartVisible.set(false);
            }
        });
        this.barChartDialog.setSize(200, 625);
        this.barChartDialog.setLocation(Math.min(Toolkit.getDefaultToolkit().getScreenSize().width - this.barChartDialog.getWidth(), phetFrame.getX() + phetFrame.getWidth()), phetFrame.getY());
        this.barChartVisible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                AbstractEnergySkateParkModule.this.barChartDialog.setVisible(bl);
            }
        });
        this.energyTimePlot = new EnergyTimePlot(this, phetFrame, constantDtClock, this.energyModel, this.timeSeriesModel);
        this.energyTimePlot.addListener(new EnergyTimePlot.Listener(){

            public void visibilityChanged() {
                AbstractEnergySkateParkModule.this.setRecordOrLiveMode();
            }
        });
        this.addDefaultBody();
        this.energyPositionPlotDialog = new EnergyPositionPlotDialog(phetFrame, EnergySkateParkResources.getString("plots.energy-vs-position"), false, this);
        this.energyPositionPlotDialog.setSize(400, 400);
        this.setClockControlPanel(null);
        this.setDefaults();
        this.setLogoPanelVisible(false);
        new WiggleMeInSpace(this).start();
        this.mass = new DoubleProperty(this.getEnergySkateParkModel().getBody(0).getMass());
    }

    private void setDefaults() {
        this.barChartVisible.reset();
        this.normalSpeed.reset();
        this.speedVisible.reset();
        this.setEnergyTimePlotVisible(false);
        this.setEnergyPositionPlotVisible(false);
    }

    public EnergySkateParkModel getEnergySkateParkModel() {
        return this.energyModel;
    }

    public EnergyLookAndFeel getEnergyLookAndFeel() {
        return this.energyLookAndFeel;
    }

    public EnergySkateParkSimulationPanel getEnergySkateParkSimulationPanel() {
        return this.energySkateParkSimulationPanel;
    }

    @Override
    public void reset() {
        super.reset();
        this.speedVisible.reset();
        this.energyModel.reset();
        this.energySkateParkSimulationPanel.reset();
        this.timeSeriesModel.reset();
        this.normalSpeed.reset();
        this.timeSeriesModel.setLiveMode();
        this.timeSeriesModel.startLiveMode();
        this.energyTimePlot.reset();
        this.barChartDialog.reset();
        this.energyPositionPlotDialog.reset();
        this.addDefaultBody();
        this.pieChartVisible.reset();
        this.updatePrimarySkaterSpeed();
        this.mass.reset();
        for (VoidFunction0 voidFunction0 : this.resetListeners) {
            voidFunction0.apply();
        }
    }

    public void returnOrResetSkater() {
        if (this.getEnergySkateParkModel().getNumBodies() > 0) {
            Body body = this.getEnergySkateParkModel().getBody(0);
            this.returnOrResetSkater(body);
        }
    }

    private void returnOrResetSkater(Body body) {
        if (body.isRestorePointSet()) {
            this.returnSkateToRestorePoint(body);
        } else {
            this.reinitializeSkater(body);
        }
    }

    public void reinitializeSkater(Body body) {
        body.deleteRestorePoint();
        body.reset();
        this.initBodyOnTrack(body);
    }

    public void returnSkateToRestorePoint(Body body) {
        body.reset();
        if (!body.isRestorePointSet()) {
            this.initBodyOnTrack(body);
        }
        if (!this.getEnergySkateParkSimulationPanel().isSkaterOnscreen(body)) {
            body.deleteRestorePoint();
            body.reset();
            this.initBodyOnTrack(body);
        }
    }

    public double getCoefficientOfFriction() {
        return this.coefficientOfFriction;
    }

    public void updatePrimarySkaterSpeed() {
        this.primarySkaterSpeed.set(new Option.Some<Double>(this.energyModel.getNumBodies() > 0 ? this.energyModel.getBody(0).getSpeed() : 0.0));
    }

    private void addDefaultBody() {
        Body body = this.energyModel.createBody();
        this.energyModel.addBody(body);
        this.energyModel.addSplineSurface(this.createDefaultTrack());
        this.initBodyOnTrack(body);
        this.updatePrimarySkaterSpeed();
    }

    private EnergySkateParkSpline createDefaultTrack() {
        return new EnergySkateParkSpline(new PreFabSplines().getParabolic().getControlPoints());
    }

    private void initBodyOnTrack(Body body) {
        if (this.isTrackDefaultState()) {
            body.setSpline(this.energyModel.getSpline(0), false, 0.1);
            body.clearHeat();
            body.clearEnergyError();
        }
    }

    private boolean isTrackDefaultState() {
        return this.energyModel.getNumSplines() > 0 && this.energyModel.getSpline(0).equals(this.createDefaultTrack());
    }

    public TimeSeriesModel getTimeSeriesModel() {
        return this.timeSeriesModel;
    }

    public void setRecordPath(boolean bl) {
        this.getEnergySkateParkModel().setRecordPath(bl);
    }

    public boolean isMeasuringTapeVisible() {
        return this.energySkateParkSimulationPanel.isMeasuringTapeVisible();
    }

    public void setMeasuringTapeVisible(boolean bl) {
        this.energySkateParkSimulationPanel.setMeasuringTapeVisible(bl);
    }

    public void clearPaths() {
        this.getEnergySkateParkModel().clearHistory();
    }

    public void setEnergyTimePlotVisible(boolean bl) {
        this.energyTimePlot.setVisible(bl);
    }

    public void setCoefficientOfFriction(double d) {
        this.coefficientOfFriction = d;
        for (int i = 0; i < this.getEnergySkateParkModel().getNumBodies(); ++i) {
            this.getEnergySkateParkModel().getBody(i).setFrictionCoefficient(d);
        }
    }

    public void setEnergyPositionPlotVisible(boolean bl) {
        this.energyPositionPlotDialog.setVisible(bl);
    }

    public void setBounciness(double d) {
        EnergySkateParkModel energySkateParkModel = this.getEnergySkateParkModel();
        for (int i = 0; i < energySkateParkModel.getNumBodies(); ++i) {
            energySkateParkModel.getBody(i).setBounciness(d);
        }
    }

    public void confirmAndReset() {
        int n = PhetOptionPane.showYesNoDialog(this.getSimulationPanel(), EnergySkateParkResources.getString("message.confirm-reset"));
        if (n == 0) {
            this.reset();
        }
    }

    public Planet[] getPlanets() {
        return new Planet[]{new Planet.Space(), new Planet.Moon(), new Planet.Earth(), new Planet.Jupiter()};
    }

    public Frame getPhetFrame() {
        return this.phetFrame;
    }

    public void setSkaterCharacter(SkaterCharacter skaterCharacter) {
        this.energyModel.setSkaterCharacter(skaterCharacter);
    }

    public SkaterCharacter getSkaterCharacter() {
        return this.energyModel.getSkaterCharacter();
    }

    public SkaterCharacter[] getSkaterCharacters() {
        return this.skaterCharacterSet.getSkaterCharacters();
    }

    public void setEnergyErrorVisible(boolean bl) {
        this.energySkateParkSimulationPanel.setEnergyErrorVisible(bl);
    }

    public boolean isEnergyErrorVisible() {
        return this.energySkateParkSimulationPanel.isEnergyErrorVisible();
    }

    public void showNewEnergyVsTimePlot() {
        this.energyTimePlot.setVisible(true);
    }

    public EnergySkateParkOptions getOptions() {
        return this.options;
    }

    private boolean isEnergyVsTimeGraphVisible() {
        return this.energyTimePlot.isVisible();
    }

    public void setRecordOrLiveMode() {
        if (this.isEnergyVsTimeGraphVisible()) {
            this.timeSeriesModel.setRecordMode();
        } else {
            this.timeSeriesModel.setLiveMode();
        }
    }

    public Body createBody() {
        return this.energyModel.createBody();
    }

    public ObservableProperty<Option<Double>> getPrimarySkaterSpeed() {
        return this.primarySkaterSpeed;
    }

    public void addResetListener(VoidFunction0 voidFunction0) {
        this.resetListeners.add(voidFunction0);
    }
}

