/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.spline;

import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.spline.ControlPointParametricFunction2D;
import edu.colorado.phet.common.spline.CubicSpline;
import edu.colorado.phet.common.spline.ParametricFunction2D;
import java.util.ArrayList;

public class CubicSpline2D
extends ControlPointParametricFunction2D {
    private CubicSpline x;
    private CubicSpline y;
    private ArrayList listeners = new ArrayList();

    public CubicSpline2D(SerializablePoint2D[] serializablePoint2DArray) {
        super(serializablePoint2DArray);
        this.update();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof CubicSpline2D) {
            CubicSpline2D cubicSpline2D = (CubicSpline2D)object;
            return cubicSpline2D.x.equals(this.x) && cubicSpline2D.y.equals(this.y);
        }
        return false;
    }

    public void setControlPoints(SerializablePoint2D[] serializablePoint2DArray) {
        super.setControlPoints(serializablePoint2DArray);
        this.update();
    }

    public void translateControlPoint(int n, double d, double d2) {
        super.translateControlPoint(n, d, d2);
        this.update();
    }

    public void removeControlPoint(int n) {
        super.removeControlPoint(n);
        this.update();
    }

    public void setControlPoint(int n, SerializablePoint2D serializablePoint2D) {
        super.setControlPoint(n, serializablePoint2D);
        this.update();
    }

    public void translateControlPoints(double d, double d2) {
        if (d != 0.0 || d2 != 0.0) {
            super.translateControlPoints(d, d2);
            this.update();
            this.notifyTrackChanged();
        }
    }

    private void update() {
        SerializablePoint2D[] serializablePoint2DArray = this.getControlPoints();
        double[] dArray = new double[serializablePoint2DArray.length];
        double[] dArray2 = new double[serializablePoint2DArray.length];
        double[] dArray3 = new double[serializablePoint2DArray.length];
        for (int i = 0; i < serializablePoint2DArray.length; ++i) {
            dArray[i] = 1.0 / (double)(serializablePoint2DArray.length - 1) * (double)i;
            dArray2[i] = serializablePoint2DArray[i].getX();
            dArray3[i] = serializablePoint2DArray[i].getY();
        }
        dArray[dArray.length - 1] = Math.round(dArray[dArray.length - 1]);
        this.x = CubicSpline.interpolate(dArray, dArray2);
        this.y = CubicSpline.interpolate(dArray, dArray3);
        this.notifyTrackChanged();
    }

    public String toString() {
        return new ObservableList<SerializablePoint2D>(this.getControlPoints()).mkString(", ");
    }

    public String toStringSerialization() {
        SerializablePoint2D[] serializablePoint2DArray = this.getControlPoints();
        String string = "new SPoint2D[]{";
        for (int i = 0; i < serializablePoint2DArray.length; ++i) {
            string = string + "new SPoint2D(" + serializablePoint2DArray[i].getX() + ", " + serializablePoint2DArray[i].getY() + ")";
            if (i >= serializablePoint2DArray.length - 1) continue;
            string = string + ", ";
        }
        return string + "};";
    }

    public void removeListener(ParametricFunction2D.Listener listener) {
        this.listeners.remove(listener);
    }

    public void addListener(ParametricFunction2D.Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyTrackChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ParametricFunction2D.Listener listener = (ParametricFunction2D.Listener)this.listeners.get(i);
            listener.trackChanged();
        }
    }

    public SerializablePoint2D evaluate(double d) {
        return new SerializablePoint2D(this.x.evaluate(d), this.y.evaluate(d));
    }
}

