/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.barchart;

import edu.colorado.phet.common.piccolophet.nodes.barchart.VerticalShadowHTMLNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;

public class BarNode
extends PNode {
    private double scale;
    private double value;
    private int x;
    private int width;
    private int y;
    private VerticalShadowHTMLNode label;
    private PPath rectanglePath;
    private double labelWidth;

    public BarNode(String string, double d, double d2, int n, int n2, int n3, Color color, Font font) {
        this.scale = d;
        this.value = d2;
        this.x = n;
        this.y = n3;
        this.width = n2;
        this.rectanglePath = new PPath(null);
        this.rectanglePath.setPaint(color);
        this.rectanglePath.setStroke(new BasicStroke(1.0f));
        this.rectanglePath.setStrokePaint(Color.black);
        this.label = new VerticalShadowHTMLNode(font, string, color, Color.black);
        this.addChild(this.rectanglePath);
        this.addChild(this.label);
        this.labelWidth = this.label.getWidth();
        this.updateBar();
    }

    private void updateBar() {
        double d = this.computeHeight();
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.x, (double)this.y - d, this.width, d);
        this.label.setOffset(double_.x + 2.0 - this.labelWidth, (int)((double)this.y + this.label.getFullBounds().getHeight() + 14.0));
        this.rectanglePath.setPathTo(double_);
    }

    public void setValue(double d) {
        if (d != this.value) {
            this.value = d;
            this.update();
        }
    }

    private void update() {
        if (this.value < 0.0) {
            this.rectanglePath.setOffset(0.0, -this.computeHeight());
        } else {
            this.rectanglePath.setOffset(0.0, 0.0);
        }
        this.value = Math.abs(this.value);
        this.updateBar();
    }

    private double computeHeight() {
        return this.scale * this.value;
    }

    public void setBarScale(double d) {
        if (this.scale != d) {
            this.scale = d;
            this.update();
        }
    }
}

