/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.barchart;

import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ShadowHTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.barchart.BarNode;
import edu.colorado.phet.common.piccolophet.nodes.barchart.VerticalShadowHTMLNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class BarChartNode
extends PNode {
    private ShadowHTMLNode titleNode;
    private PNode frontLayer = new PNode();
    private PNode barLayer = new PNode();
    private double barChartHeight;
    private double barWidth;
    private double dw;
    private double sep;
    private double topY;
    private XAxis xAxis;
    private PPath background;
    private YAxis yAxis;
    private Variable[] variables;
    private double scale = 1.0;
    private PNode backLayer = new PNode();
    private VerticalShadowHTMLNode verticalLabelNode;

    public BarChartNode(String string, double d, Paint paint) {
        this(string, d, paint, 400.0);
    }

    public BarChartNode(String string, double d, Paint paint, double d2) {
        this.scale = d;
        this.topY = 0.0;
        this.barChartHeight = d2;
        this.barWidth = 20.0;
        this.dw = 7.0;
        this.sep = this.barWidth + this.dw;
        this.titleNode = new ShadowHTMLNode(string);
        this.titleNode.setColor(Color.black);
        this.titleNode.setShadowColor(Color.blue);
        this.titleNode.setFont(this.getTitleFont());
        PhetPPath phetPPath = new PhetPPath((Shape)this.titleNode.getFullBounds(), paint);
        this.frontLayer.addChild(phetPPath);
        this.verticalLabelNode = new VerticalShadowHTMLNode(new PhetFont(), "", Color.red, Color.black);
        this.verticalLabelNode.setOffset(-20.0, 150.0);
        this.frontLayer.addChild(this.verticalLabelNode);
        this.addChild(this.backLayer);
        this.addChild(this.barLayer);
        this.addChild(this.frontLayer);
    }

    protected Font getTitleFont() {
        return new PhetFont(1, 18);
    }

    public void setBarScale(double d) {
        this.scale = d;
        for (int i = 0; i < this.barLayer.getChildrenCount(); ++i) {
            BarNode barNode = (BarNode)this.barLayer.getChild(i);
            barNode.setBarScale(d);
        }
        this.update();
    }

    private void addBarGraphic(BarNode barNode) {
        this.barLayer.addChild(barNode);
    }

    public void init(Variable[] variableArray) {
        this.variables = variableArray;
        double d = (double)variableArray.length * (this.sep + this.dw) - this.sep;
        this.background = new PPath(new Rectangle2D.Double(0.0, this.topY, 2.0 + d, 1.0));
        this.background.setPaint(null);
        this.background.setStroke(new BasicStroke());
        this.background.setStrokePaint(null);
        this.frontLayer.addChild(this.background);
        this.xAxis = new XAxis();
        this.backLayer.addChild(this.xAxis);
        this.yAxis = new YAxis();
        this.frontLayer.addChild(this.yAxis);
        for (int i = 0; i < variableArray.length; ++i) {
            Variable variable = variableArray[i];
            int n = (int)((double)i * this.sep + this.dw);
            BarNode barNode = new BarNode(variable.getName(), this.scale, variable.getValue(), n, (int)this.barWidth, (int)this.barChartHeight, variable.getColor(), new PhetFont(1, 14));
            this.addBarGraphic(barNode);
        }
        this.frontLayer.addChild(this.titleNode);
        this.addPropertyChangeListener("visible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BarChartNode.this.update();
            }
        });
        this.update();
    }

    public void update() {
        if (this.getVisible()) {
            for (int i = 0; i < this.barLayer.getChildrenCount(); ++i) {
                BarNode barNode = (BarNode)this.barLayer.getChild(i);
                barNode.setValue(this.variables[i].getValue());
            }
        }
    }

    public static class Variable {
        private String name;
        private double value;
        private Color color;

        public Variable(String string, double d, Color color) {
            this.name = string;
            this.value = d;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public double getValue() {
            return this.value;
        }

        public Color getColor() {
            return this.color;
        }
    }

    private class XAxis
    extends PNode {
        private PPath path = new PPath(this.createLinePath());

        public XAxis() {
            this.addChild(this.path);
            this.path.setStrokePaint(new Color(255, 150, 150));
            this.path.setStroke(new BasicStroke(3.0f));
        }

        private Line2D.Double createLinePath() {
            return new Line2D.Double(0.0, BarChartNode.this.barChartHeight, BarChartNode.this.background.getFullBounds().getWidth(), BarChartNode.this.barChartHeight);
        }
    }

    private class YAxis
    extends PNode {
        private PPath path;

        public YAxis() {
            GeneralPath generalPath = this.createShape();
            this.path = new PPath(generalPath);
            this.path.setPaint(Color.black);
            this.addChild(this.path);
        }

        private GeneralPath createShape() {
            Point2D.Double double_ = new Point2D.Double(0.0, BarChartNode.this.barChartHeight);
            Point2D.Double double_2 = new Point2D.Double(0.0, BarChartNode.this.topY + 25.0);
            try {
                return new Arrow(double_, double_2, 8.0, 8.0, 3.0).getShape();
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                return new GeneralPath();
            }
        }
    }
}

