/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class ZoomControlNode
extends PNode {
    private static final Point IN_LOCATION = new Point(31, 13);
    private static final Point OUT_LOCATION = new Point(3, 13);
    public static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    public static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    private int _orientation;
    private PImage _inButton;
    private PImage _inButtonPressed;
    private PImage _outButton;
    private PImage _outButtonPressed;
    private EventListenerList _listenerList;
    private boolean _inPressed;
    private boolean _outPressed;

    public ZoomControlNode(int n) {
        this._orientation = n;
        PImage pImage = n == 0 ? new PImage(this.loadBufferedImage("piccolo-phet/images/zoomBackgroundHorizontal.png")) : new PImage(this.loadBufferedImage("piccolo-phet/images/zoomBackgroundVertical.png"));
        this.addChild(pImage);
        this._inButton = new PImage(this.loadBufferedImage("piccolo-phet/images/zoomInButton.png"));
        this._inButtonPressed = new PImage(this.loadBufferedImage("piccolo-phet/images/zoomInButtonPressed.png"));
        this._inButton.setOffset(IN_LOCATION);
        this._inButtonPressed.setOffset(IN_LOCATION);
        this.addChild(this._inButton);
        this.addChild(this._inButtonPressed);
        this._outButton = new PImage(this.loadBufferedImage("piccolo-phet/images/zoomOutButton.png"));
        this._outButtonPressed = new PImage(this.loadBufferedImage("piccolo-phet/images/zoomOutButtonPressed.png"));
        this._outButton.setOffset(OUT_LOCATION);
        this._outButtonPressed.setOffset(OUT_LOCATION);
        this.addChild(this._outButton);
        this.addChild(this._outButtonPressed);
        pImage.setPickable(false);
        pImage.setChildrenPickable(false);
        this._inButton.addInputEventListener(new CursorHandler());
        this._inButtonPressed.addInputEventListener(new CursorHandler());
        this._outButton.addInputEventListener(new CursorHandler());
        this._outButtonPressed.addInputEventListener(new CursorHandler());
        PBasicInputEventHandler pBasicInputEventHandler = new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                if (!ZoomControlNode.this._inButtonPressed.getVisible()) {
                    ZoomControlNode.this._inButtonPressed.setVisible(true);
                    ZoomControlNode.this._inButtonPressed.setPickable(true);
                    ZoomControlNode.this._inButtonPressed.setChildrenPickable(true);
                    ZoomControlNode.this._inPressed = true;
                }
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                if (ZoomControlNode.this._inPressed) {
                    ZoomControlNode.this._inButtonPressed.setVisible(false);
                    ZoomControlNode.this._inButtonPressed.setPickable(false);
                    ZoomControlNode.this._inButtonPressed.setChildrenPickable(false);
                    ZoomControlNode.this._inPressed = false;
                    ZoomControlNode.this.fireZoomIn();
                }
            }
        };
        this._inButton.addInputEventListener(pBasicInputEventHandler);
        this._inButtonPressed.addInputEventListener(pBasicInputEventHandler);
        PBasicInputEventHandler pBasicInputEventHandler2 = new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                if (!ZoomControlNode.this._outButtonPressed.getVisible()) {
                    ZoomControlNode.this._outButtonPressed.setVisible(true);
                    ZoomControlNode.this._outButtonPressed.setPickable(true);
                    ZoomControlNode.this._outButtonPressed.setChildrenPickable(true);
                    ZoomControlNode.this._outPressed = true;
                }
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                if (ZoomControlNode.this._outPressed) {
                    ZoomControlNode.this._outButtonPressed.setVisible(false);
                    ZoomControlNode.this._outButtonPressed.setPickable(false);
                    ZoomControlNode.this._outButtonPressed.setChildrenPickable(false);
                    ZoomControlNode.this._outPressed = false;
                    ZoomControlNode.this.fireZoomOut();
                }
            }
        };
        this._outButton.addInputEventListener(pBasicInputEventHandler2);
        this._outButtonPressed.addInputEventListener(pBasicInputEventHandler2);
        this._inButtonPressed.setVisible(false);
        this._inButtonPressed.setPickable(false);
        this._inButtonPressed.setChildrenPickable(false);
        this._outButtonPressed.setVisible(false);
        this._outButtonPressed.setPickable(false);
        this._outButtonPressed.setChildrenPickable(false);
        this._listenerList = new EventListenerList();
    }

    private BufferedImage loadBufferedImage(String string) {
        try {
            return ImageLoader.loadBufferedImage(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    public void setZoomInEnabled(boolean bl) {
        this._inButton.setVisible(bl);
        this._inButton.setPickable(bl);
        this._inButton.setChildrenPickable(bl);
    }

    public void setZoomOutEnabled(boolean bl) {
        this._outButton.setVisible(bl);
        this._outButton.setPickable(bl);
        this._outButton.setChildrenPickable(bl);
    }

    public void addZoomListener(ZoomListener zoomListener) {
        this._listenerList.add(ZoomListener.class, zoomListener);
    }

    private void fireZoomIn() {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ZoomListener.class) continue;
            ((ZoomListener)objectArray[i + 1]).zoomedIn();
        }
    }

    private void fireZoomOut() {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ZoomListener.class) continue;
            ((ZoomListener)objectArray[i + 1]).zoomedOut();
        }
    }

    public static interface ZoomListener
    extends EventListener {
        public void zoomedOut();

        public void zoomedIn();
    }
}

