/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.model.property;

import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObservableProperty<T>
implements Cloneable {
    private static final Logger LOGGER = LoggingUtils.getLogger(ObservableProperty.class.getCanonicalName());
    private final ArrayList<SimpleObserver> simpleObservers = new ArrayList();
    private final ArrayList<VoidFunction1<T>> newValueObservers = new ArrayList();
    private final ArrayList<ChangeObserver<T>> newAndOldValueObservers = new ArrayList();
    private T oldValue;

    public ObservableProperty(T t) {
        this.oldValue = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(SimpleObserver simpleObserver, boolean bl) {
        ArrayList<SimpleObserver> arrayList = this.simpleObservers;
        synchronized (arrayList) {
            this.simpleObservers.add(simpleObserver);
        }
        if (bl) {
            simpleObserver.update();
        }
    }

    private void notifyObservers(T t, T t2) {
        this.notifySimpleObservers();
        this.notifyNewValueObservers(t);
        this.notifyNewAndOldValueObservers(t, t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySimpleObservers() {
        ArrayList<SimpleObserver> arrayList;
        ArrayList<SimpleObserver> arrayList2 = this.simpleObservers;
        synchronized (arrayList2) {
            arrayList = new ArrayList<SimpleObserver>(this.simpleObservers);
        }
        for (SimpleObserver simpleObserver : arrayList) {
            simpleObserver.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNewValueObservers(T t) {
        ArrayList<VoidFunction1<T>> arrayList;
        ArrayList<VoidFunction1<T>> arrayList2 = this.newValueObservers;
        synchronized (arrayList2) {
            arrayList = new ArrayList<VoidFunction1<T>>(this.newValueObservers);
        }
        for (VoidFunction1 voidFunction1 : arrayList) {
            voidFunction1.apply(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(VoidFunction1<T> voidFunction1) {
        ArrayList<VoidFunction1<T>> arrayList = this.newValueObservers;
        synchronized (arrayList) {
            this.newValueObservers.add(voidFunction1);
        }
        voidFunction1.apply(this.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNewAndOldValueObservers(T t, T t2) {
        ArrayList<ChangeObserver<T>> arrayList;
        ArrayList<ChangeObserver<T>> arrayList2 = this.newAndOldValueObservers;
        synchronized (arrayList2) {
            arrayList = new ArrayList<ChangeObserver<T>>(this.newAndOldValueObservers);
        }
        for (ChangeObserver changeObserver : arrayList) {
            changeObserver.update(t, t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(ChangeObserver<T> changeObserver) {
        ArrayList<ChangeObserver<T>> arrayList = this.newAndOldValueObservers;
        synchronized (arrayList) {
            this.newAndOldValueObservers.add(changeObserver);
        }
    }

    public void addObserver(SimpleObserver simpleObserver) {
        this.addObserver(simpleObserver, true);
    }

    public abstract T get();

    public String toString() {
        return this.get().toString();
    }

    protected synchronized Runnable getChangeNotifier() {
        final T t = this.get();
        final boolean bl = t == null ? this.oldValue != null : !t.equals(this.oldValue);
        final T t2 = this.oldValue;
        Runnable runnable = new Runnable(){

            public void run() {
                if (bl) {
                    ObservableProperty.this.notifyObservers(t, t2);
                }
            }
        };
        if (bl) {
            this.oldValue = t;
        }
        return runnable;
    }

    public void notifyIfChanged() {
        this.getChangeNotifier().run();
    }

    static {
        LOGGER.setLevel(Level.INFO);
    }
}

