#define PY_SSiZE_T_CLEAN
/*
    Copyright 2020 Ming-Feng Hsieh (jmfhsieh@gmail.com)

    This file is part of Clover.

    Clover is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Clover is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Clover; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/
#include <Python.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<math.h>
#define max_i_mer 14
#define aligndistancef(s1,s2) (indistancec(s1,s2) || aligndistancek(s1,s2))

long k_mer,p_mer,i_mer, idealnumber;
float splitparameter, idealerrorfraction;
//rdna: reverse of DNA
char rdna[256];
//dti: DNA to longinteger
char dti[256];
//itd: longinteger to DNA
char itd[] = {'A', 'C', 'G', 'T'};
// parray carray use for alignment
long *carray, *parray;
long larray=0;

struct kmer{
char *sequence;
char *reverse;
long *sequenceseed;
long *reverseseed;
long weight;
char fresh;
char direction;
};
typedef struct kmer kmer;

struct contig{
char *sequence;
char *reverse;
long *sequenceseed;
long *reverseseed;
long length;
long weight;
};
typedef struct contig contig;

struct supercontig{
char *sequence;
char *reverse;
long *sequenceseed;
long *reverseseed;
long length;
long weight;
struct supercontig **pre;
struct supercontig **next;
char *predirection;
char *nextdirection;
char prelength;
char nextlength;
char fresh;
};
typedef struct supercontig supercontig;

int aligndistancee(s1,s2)
 {return aligndistancec(s1,s2,k_mer,k_mer,p_mer); }

static PyObject* aligndistance1(PyObject* self, PyObject* args)
{
const char *s1, *s2;
long p;
    Py_ssize_t size;

    if (!PyArg_ParseTuple(args, "ss#i", &s1, &s2, &size, &p))
        return NULL;
return Py_BuildValue("i", aligndistancec(s1, s2, size, size, p));
}

static PyObject* aligndistance2(PyObject* self, PyObject* args)
{
const char *s1, *s2;
long p;
    Py_ssize_t size;

    if (!PyArg_ParseTuple(args, "ss#i", &s1, &s2, &size, &p))
        return NULL;
return Py_BuildValue("i", aligndistanceg(s1, s2, size, p));
}

static PyObject* aligndistance3(PyObject* self, PyObject* args)
{
const char *s1, *s2;
long p;
    Py_ssize_t size;

    if (!PyArg_ParseTuple(args, "ss#i", &s1, &s2, &size, &p))
        return NULL;
return Py_BuildValue("i", aligndistanced(s1, s2, size, p));
}

static PyObject* aligndistance5(PyObject* self, PyObject* args)
{
const char *s1, *s2;
long p;
    Py_ssize_t size;

    if (!PyArg_ParseTuple(args, "ss#i", &s1, &s2, &size, &p))
        return NULL;
if(size>=larray) {
if(larray) {
free(parray);
free(carray);
}
larray=size+100000;
parray=(long *)malloc(sizeof(long)*larray);
carray=(long *)malloc(sizeof(long)*larray);
}
return Py_BuildValue("i", aligndistances(s1, s2, size, p));
}

static PyObject* aligndistance6(PyObject* self, PyObject* args)
{
const char *s1, *s2;
long p;
    Py_ssize_t size;

    if (!PyArg_ParseTuple(args, "ss#i", &s1, &s2, &size, &p))
        return NULL;
if(size>=larray) {
if(larray) {
free(parray);
free(carray);
}
larray=size+100000;
parray=(long *)malloc(sizeof(long)*larray);
carray=(long *)malloc(sizeof(long)*larray);
}
return Py_BuildValue("i", indistances(s1, s2, size, p) || aligndistances(s1, s2, size, p));
}

static PyObject* aligndistance4(PyObject* self, PyObject* args)
{
const char *s1, *s2;
long p;
    Py_ssize_t size;

    if (!PyArg_ParseTuple(args, "ss#i", &s1, &s2, &size, &p))
        return NULL;
return Py_BuildValue("i", aligndistanceb(s1, s2, size, p));
}

long min3(a,b,c)
{
if(a<=b) {
if(a<=c)
return a;
else
return c;
}else {
if(b<=c)
return b;
else
return c;
}
}

int aligndistanceb( const char *s1, const char *s2, long l, long p)
{
long *darray;
long i,j, flag,lp= l+2, index=0;
if( !l )
return 0;
l++;
darray=(long *) malloc(sizeof(long)*l*l);
for(i =0; i<l; i++) {
flag=1;
for(j=0;j<l;j++) {
if(!i || !j)
darray[index]=i+j;
else {
if(s1[i-1] == s2[j-1] )
darray[index] =min3(darray[index-1]+1,darray[index-l]+1,darray[index-lp]);
else
darray[index] =min3(darray[index-1],darray[index-l],darray[index-lp])+1;
} // end else
if(darray[index] <=p)
flag=0;
index++;
} // end for
if(flag) {
free(darray);
return 0;
}
} // end for
if(darray[--index] >p) {
free(darray);
return 0;
}else {
free(darray);
return 1;
}//end if
}

int aligndistanceg( const char *s1, const char *s2, long l, long p)
{
long *darray;
long i,j, index,lp;
if( !l )
return 0;
l++;
lp=l+1;
index=0;
darray=(long *) malloc(sizeof(long)*l*l);
for(i =0; i<l; i++) {
for(j =0;j<l;j++) {
if(!i || !j)
darray[index]=i+j;
else {
if(s1[i-1] == s2[j-1] )
darray[index] =min3(darray[index-1]+1,darray[index-l]+1,darray[index-lp]);
else
darray[index] =min3(darray[index-1],darray[index-l],darray[index-lp])+1;
} // end else
index++;
} // end for
} // end for
if(darray[--index] >p) {
free(darray);
return 0;
}else {
free(darray);
return 1;
}//end if
}

long aligndistancek( const char *s1, const char *s2)
{
long *temp;
long i,j,stop,flag, ps=(p_mer/2),psp=(p_mer/2)+1,l=k_mer+1;
for(i =0; i<l; i++) {
temp=parray;
parray=carray;
carray=temp;
if((j=i-ps) <= 0) 
j=0;
else
carray[j-1] = p_mer;
if((stop=i+psp) <l)
carray[stop] =p_mer;
else
stop=l;
flag=1;
for(j=j;j<stop;j++) {
if(!i || !j)
carray[j]=i+j;
else {
if(s1[i-1] == s2[j-1] )
carray[j] =min3(carray[j-1]+1,parray[j]+1,parray[j-1]);
else
carray[j] =min3(carray[j-1],parray[j],parray[j-1])+1;
} // end else
if(carray[j] <=p_mer)
flag=0;
} // end for
if(flag) 
return 0;
} // end for
if(carray[--j] >p_mer) 
return 0;
else 
return 1;
}

int aligndistances( const char *s1, const char *s2, long l, long p)
{
long *temp;
long i,j,stop,flag, ps=(p/2),psp=(p/2)+1;
if( !l )
return 0;
l++;
for(i =0; i<l; i++) {
temp=parray;
parray=carray;
carray=temp;
if((j=i-ps) <= 0) 
j=0;
else
carray[j-1] = p;
if((stop=i+psp) <l)
carray[stop] =p;
else
stop=l;
flag=1;
for(j=j;j<stop;j++) {
if(!i || !j)
carray[j]=i+j;
else {
if(s1[i-1] == s2[j-1] )
carray[j] =min3(carray[j-1]+1,parray[j]+1,parray[j-1]);
else
carray[j] =min3(carray[j-1],parray[j],parray[j-1])+1;
} // end else
if(carray[j] <=p)
flag=0;
} // end for
if(flag) 
return 0;
} // end for
if(carray[--j] >p) 
return 0;
else 
return 1;
}

int aligndistanced( const char *s1, const char *s2, long l, long p)
{
long *darray;
long i,j,stop,index,flag,lp= l+2,ps=(p/2),psp=(p/2)+1;
if( !l )
return 0;
l++;
darray=(long *) malloc(sizeof(long)*l*l);
for(i =0; i<l; i++) {
if((j=i-ps) <= 0) {
j=0;
index=i*l;
}else{
index=(i*l) +j;
darray[index-1] = p;
}
if((stop=i+psp) <l)
darray[index+stop-j] =p;
else
stop=l;
flag=1;
for(j=j;j<stop;j++) {
if(!i || !j)
darray[index]=i+j;
else {
if(s1[i-1] == s2[j-1] )
darray[index] =min3(darray[index-1]+1,darray[index-l]+1,darray[index-lp]);
else
darray[index] =min3(darray[index-1],darray[index-l],darray[index-lp])+1;
} // end else
if(darray[index] <=p)
flag=0;
index++;
} // end for
if(flag) {
free(darray);
return 0;
}
} // end for
if(darray[--index] >p) {
free(darray);
return 0;
}else {
free(darray);
return 1;
}//end if
}

static PyObject* indistance(PyObject* self, PyObject* args)
{
const char *s1, *s2;
long i,p;
long result=0;
    Py_ssize_t size;

    if (!PyArg_ParseTuple(args, "ss#i", &s1, &s2, &size, &p))
        return NULL;

	for(i=0; i<(long)size; i++) 
		if(s1[i] != s2[i]) 
if(++result>p)
return Py_BuildValue("i",0);
return Py_BuildValue("i",1);
}

static PyObject* inkpdistance(PyObject* self, PyObject* args)
{
const char *s1, *s2;
long i,k,p;
long result=0;

    if (!PyArg_ParseTuple(args, "ssii", &s1, &s2, &k, &p))
        return NULL;

	for(i=0; i<k; i++) 
		if(s1[i] != s2[i]) 
if(++result>p)
return Py_BuildValue("i",0);
return Py_BuildValue("i",1);
}

long stoi( const char *s)
{
long i=0, j;
for(j=0; j<i_mer; j++) {
i<<=2;
i+= dti[s[j]];
}
return i;
}

char *getreverse( char *s2, const char*s1)
{
long i, j=k_mer;
for(i=0; i<k_mer; i++)
s2[i]=rdna[s1[--j]];
return s2;
} 

char *getreversen( char *s2, const char*s1, long n)
{
long i, j=n;
for(i=0; i<n; i++)
s2[i]=rdna[s1[--j]];
return s2;
}
 
long *longncpy( long *s2, const long*s1, long n)
{
long i;
for(i=0; i<n; i++)
s2[i]=s1[i];
return s2;
}

supercontig **superncpy( supercontig **s2, const supercontig**s1, long n)
{
long i;
for(i=0; i<n; i++)
s2[i]=s1[i];
return s2;
}

char *reversedcn( char *s2, const char*s1, long n)
{
long i, j=n;
for(i=0; i<n; i++) {
j--;
s2[i]=s1[j];
}
return s2;
} 
long *reversedin( long *s2, const long *s1, long n)
{
long i, j=n;
for(i=0; i<n; i++) {
j--;
s2[i]=s1[j];
}
return s2;
} 
/* this is not reliable
long detectfile( FILE *fptr) 
{
long i,j;
while( (fgetc(fptr) != '\n')&& (!feof(fptr)));
j= ftell(fptr );
if(!j )
return 0;
fseek(fptr,0,SEEK_END );
i= ftell(fptr );
printf("i=%ld, j= %ld",i,j);
i/= j;
printf("i=%ld, j= %ld",i,j);
rewind(fptr);
return i;
}
*/

char *fgetl(char *string, long *l, FILE *fptr)
{
long i=0;
int j;
while(((j=fgetc(fptr))!='\n') && !feof(fptr))
string[i++]=j;
*l=i;
return string;
}

long detectfilen( FILE *fptr, long *length) 
{
long i,j,k;
char *l;
fseek(fptr,0,SEEK_END );
i= ftell(fptr );
rewind(fptr);
j=0;
k=0;
l= (char *) malloc(sizeof(char) *i);
while(fgetl(l,&i,fptr) && !feof(fptr)) {
j++;
k+=i;
}
rewind(fptr);
*length=k;
free(l);
return j;
}

long *preprocessingdgraph( long *dgraph, long *dbase )
{
long i, j= (1<<(i_mer*2));
dbase[0]=dgraph[0];
for(i=1; i<j; i++) 
dbase[i]= dgraph[i]+dbase[i-1];
return dbase;
}
 
long *preprocessingdgraphreset( long *dgraph, long *dbase )
{
long i, j= (1<<(i_mer*2))-1;
dbase[0]=0;
for(i=0; i<j; i++) { 
dbase[i+1]= dgraph[i]+dbase[i];
dgraph[i]=0;
}
dgraph[j]=0;
return dbase;
}
 
long *preprocessingdgraphmap( long *dgraph)
{
long i, j= (1<<(i_mer*2));
for(i=1; i<=j; i++) 
dgraph[i]+= dgraph[i-1];
return dgraph;
}

long indistancec( const char *s1, const char *s2)
{
long i,result=0;
	for(i=0; i< k_mer; i++) 
		if(s1[i] != s2[i]) 
if(++result>p_mer)
return 0;
return 1;
}

int indistances( const char *s1, const char *s2, long l, long p)
{
long i,result=0;
	for(i=0; i< l; i++) 
		if(s1[i] != s2[i]) 
if(++result>p)
return 0;
return 1;
}

int aligndistancec( const char *s1, const char *s2, long l1, long l2, long err)
{
long i, len, lab;
if(l1<l2) {
len=l1;
lab= l2-l1;
}else{
len=l2;
lab= l1-l2;
}
if(lab >err)
return 0;
	for(i=0; i< len; i++) {
		if(s1[i] != s2[i]) {
err--;
l1-=i;
l2-=i;
return aligndistancec(&s1[i],&s2[i+1],l1,l2-1,err)||aligndistancec(&s1[i+1],&s2[i+1],l1-1,l2-1,err)||aligndistancec(&s1[i+1],&s2[i],l1-1,l2,err);
}
}
if(lab >err)
return 0;
else
return 1;
}

static PyObject* buildkpgraphc(PyObject* self, PyObject* args)
{
char *infile, *outfile1, *outfile2, *outfile3;
FILE *infptr, *outfptr1, *outfptr2, *outfptr3;
kmer *kmerpool, *kmertemp;
long **dgraph, **darray, **dbase, *systemlonginteger, *tempptr, *pool, *kmertempsequenceseed, *kmertempreverseseed;
long i,j,k_number,kp, pp, temp1, temp2, temp3, temp4, temp5,temp6,temp7;
char *systemstring, *kmertempsequence,kmertempdirection;

rdna['A']='T';
rdna['C']='G';
rdna['G']='C';
rdna['T']='A';
rdna['N']='N';
dti['A']=0;
dti['C']=1;
dti['G']=2;
dti['T']=3;

    if (!PyArg_ParseTuple(args, "iiissss", &k_mer, &p_mer, &i_mer, &infile, &outfile1, &outfile2, &outfile3))
        return NULL;

if (i_mer > max_i_mer)
 i_mer = max_i_mer;
pp=p_mer+1;
kp=k_mer+1;
infptr=fopen( infile, "r+" );
k_number= detectfilen(infptr, &temp1);
//fclose(infptr);
kmerpool= (kmer *) malloc(sizeof(kmer) * k_number );
dgraph= (long **) malloc(sizeof(long *) * pp);
darray= (long **) malloc(sizeof(long *) * pp);
dbase= (long **) malloc(sizeof(long *) * pp);
temp1=(1<<(i_mer*2));
for(j=0; j <pp; j++) {
dgraph[j]= (long *)malloc(sizeof(long) * temp1);
dbase[j]= (long *)malloc(sizeof(long) * temp1);
darray[j]= (long *) malloc(sizeof(long) * k_number);
systemlonginteger=dgraph[j];
for(i=0; i<temp1; i++)
systemlonginteger[i]=0;
}
systemstring= (char *) malloc( sizeof(char) * kp * 2 * k_number );
temp1=0;
systemlonginteger= (long *) malloc( sizeof(long) * pp * 2 * k_number );
temp2=0;
temp5=k_mer+3;
for(i=0; i<k_number; i++) {
kmertemp=&kmerpool[i];
kmertemp->sequence=fgets(&systemstring[temp1] , temp5, infptr);
kmertemp->sequence[k_mer]=0;
temp1+= kp;
kmertemp->reverse= getreverse( &systemstring[temp1], kmertemp->sequence);
temp1+= kp;
kmertemp->sequenceseed= &systemlonginteger[temp2];
temp2+= pp;
kmertemp->reverseseed= &systemlonginteger[temp2];
temp2+= pp;
kmertemp->fresh=1;
kmertemp->direction=1;
temp3=0;
for(j=0;j<pp;j++) {
temp4=stoi(&kmertemp->sequence[temp3]);
kmertemp->sequenceseed[j]=temp4;
dgraph[j][temp4]+=1;
kmertemp->reverseseed[j]=stoi(&kmertemp->reverse[temp3]);
temp3 += i_mer;
}
}
fclose(infptr);
for(j=0;j<pp;j++) {
dbase[j]=preprocessingdgraph(dgraph[j], dbase[j]);
tempptr=darray[j];
pool=dbase[j];
for(i=0; i<k_number; i++) {
tempptr[--pool[kmerpool[i].sequenceseed[j]]]=i;
//darray[j][--dgraph[j][tempptr[j]]]=i;
//temp1=kmertemp.sequenceseed[j];
//dgraph[j][temp1]--;
//temp2=dgraph[j][temp1]; 
//darray[j][temp2]=i;
}
}
temp1=0;
temp2=0;
// temp1, temp2 is used
pool= (long *) malloc(sizeof(long) * k_number );
outfptr1=fopen(outfile1,"w+" );
outfptr2=fopen(outfile2,"w+" );
outfptr3=fopen(outfile3,"w+" );
fprintf(outfptr3,"%ld,",temp2);
for(i=0; i<k_number; i++) {
if (!kmerpool[i].fresh)
continue;
 kmerpool[i].fresh=0;
fprintf(outfptr1, "%ld,", i);
fprintf(outfptr2, "%ld,", kmerpool[i].direction );
pool[temp2++]=i;
while(temp1 < temp2) {
temp3=pool[temp1++];
kmertempsequence=kmerpool[temp3].sequence;
kmertempsequenceseed=kmerpool[temp3].sequenceseed;
kmertempreverseseed=kmerpool[temp3].reverseseed;
kmertempdirection=kmerpool[temp3].direction;
for(j=0; j<pp; j++ ){
temp3=kmertempsequenceseed[j];
if(!dgraph[j][temp3])  
continue;
temp5=0;
temp6=dgraph[j][temp3];
tempptr=&darray[j][dbase[j][temp3]];
for(temp4=0; temp4<temp6;temp4++) {
temp7=tempptr[temp4];
if(!kmerpool[temp7].fresh) 
continue;
if(indistancec(kmertempsequence,kmerpool[temp7].sequence)) {
kmerpool[temp7].fresh=0;
kmerpool[temp7].direction=kmertempdirection;
fprintf(outfptr1, "%ld,", temp7);
fprintf(outfptr2, "%ld,", kmertempdirection );
pool[temp2++]=temp7;
} // end if
else
tempptr[temp5++]=temp7;
}//end for
dgraph[j][temp3]=temp5;
}//end for
for(j=0; j<pp; j++ ){
temp3=kmertempreverseseed[j];
if(!dgraph[j][temp3]) 
continue;
temp5=0;
temp6=dgraph[j][temp3];
tempptr=&darray[j][dbase[j][temp3]];
for(temp4=0; temp4<temp6;temp4++) {
temp7=tempptr[temp4];
if(!kmerpool[temp7].fresh)
continue;
if(indistancec(kmertempsequence,kmerpool[temp7].reverse)) {
kmerpool[temp7].fresh=0;
kmerpool[temp7].direction= !kmertempdirection;
fprintf(outfptr1, "%ld,", temp7);
fprintf(outfptr2, "%ld,", !kmertempdirection );
pool[temp2++]=temp7;
} // end if
else
tempptr[temp5++]=temp7;
}//end for
dgraph[j][temp3]=temp5;
}//end for
}//endwhile
fprintf(outfptr3,"%ld,",temp2);
}//end for
fclose(outfptr1);
fclose(outfptr2);
fclose(outfptr3);
for(j=0; j<pp; j++) {
free(dgraph[j]);
free(dbase[j]);
free(darray[j]);
}
free(dgraph);
free(dbase);
free(darray);
free(pool);
free(kmerpool);
free(systemstring);
free(systemlonginteger);
Py_RETURN_NONE;
}

static PyObject* buildkpgraphtransc(PyObject* self, PyObject* args)
{
char *infile, *outfile1, *outfile2;
FILE *infptr, *outfptr1, *outfptr2;
kmer *kmerpool, *kmertemp;
long **dgraph, **darray, **dbase, *systemlonginteger, *tempptr, *pool, *kmertempsequenceseed;
long i,j,k_number,kp, pp, temp1, temp2, temp3, temp4, temp5,temp6,temp7;
char *systemstring, *kmertempsequence;

rdna['A']='T';
rdna['C']='G';
rdna['G']='C';
rdna['T']='A';
rdna['N']='N';
dti['A']=0;
dti['C']=1;
dti['G']=2;
dti['T']=3;

    if (!PyArg_ParseTuple(args, "iiisss", &k_mer, &p_mer, &i_mer, &infile, &outfile1, &outfile2))
        return NULL;

if (i_mer > max_i_mer)
 i_mer = max_i_mer;
pp=p_mer+1;
kp=k_mer+1;
infptr=fopen( infile, "r+" );
k_number= detectfilen(infptr, &temp1);
//fclose(infptr);
kmerpool= (kmer *) malloc(sizeof(kmer) * k_number );
dgraph= (long **) malloc(sizeof(long *) * pp);
darray= (long **) malloc(sizeof(long *) * pp);
dbase= (long **) malloc(sizeof(long *) * pp);
temp1=(1<<(i_mer*2));
for(j=0; j <pp; j++) {
dgraph[j]= (long *)malloc(sizeof(long) * temp1);
dbase[j]= (long *)malloc(sizeof(long) * temp1);
darray[j]= (long *) malloc(sizeof(long) * k_number);
systemlonginteger=dgraph[j];
for(i=0; i<temp1; i++)
systemlonginteger[i]=0;
}
systemstring= (char *) malloc( sizeof(char) * kp * k_number );
temp1=0;
systemlonginteger= (long *) malloc( sizeof(long) * pp * k_number );
temp2=0;
temp5=k_mer+3;
for(i=0; i<k_number; i++) {
kmertemp=&kmerpool[i];
kmertemp->sequence=fgets(&systemstring[temp1] , temp5, infptr);
temp1+= kp;
kmertemp->sequenceseed= &systemlonginteger[temp2];
temp2+= pp;
kmertemp->fresh=1;
temp3=0;
for(j=0;j<pp;j++) {
temp4=stoi(&kmertemp->sequence[temp3]);
kmertemp->sequenceseed[j]=temp4;
dgraph[j][temp4]+=1;
temp3 += i_mer;
}
}
fclose(infptr);
for(j=0;j<pp;j++) {
dbase[j]=preprocessingdgraph(dgraph[j], dbase[j]);
tempptr=darray[j];
pool=dbase[j];
for(i=0; i<k_number; i++) {
tempptr[--pool[kmerpool[i].sequenceseed[j]]]=i;
}
}
temp1=0;
temp2=0;
// temp1, temp2 is used
pool= (long *) malloc(sizeof(long) * k_number );
outfptr1=fopen(outfile1,"w+" );
outfptr2=fopen(outfile2,"w+" );
fprintf(outfptr2,"%ld,",temp2);
for(i=0; i<k_number; i++) {
if (!kmerpool[i].fresh)
continue;
 kmerpool[i].fresh=0;
fprintf(outfptr1, "%ld,", i);
pool[temp2++]=i;
while(temp1 < temp2) {
temp3=pool[temp1++];
kmertempsequence=kmerpool[temp3].sequence;
kmertempsequenceseed=kmerpool[temp3].sequenceseed;
for(j=0; j<pp; j++ ){
temp3=kmertempsequenceseed[j];
if(!dgraph[j][temp3])  
continue;
temp5=0;
temp6=dgraph[j][temp3];
tempptr=&darray[j][dbase[j][temp3]];
for(temp4=0; temp4<temp6;temp4++) {
temp7=tempptr[temp4];
if(!kmerpool[temp7].fresh) 
continue;
if(indistancec(kmertempsequence,kmerpool[temp7].sequence)) {
kmerpool[temp7].fresh=0;
fprintf(outfptr1, "%ld,", temp7);
pool[temp2++]=temp7;
} // end if
else
tempptr[temp5++]=temp7;
}//end for
dgraph[j][temp3]=temp5;
}//end for
}//endwhile
fprintf(outfptr2,"%ld,",temp2);
}//end for
fclose(outfptr1);
fclose(outfptr2);
for(j=0; j<pp; j++) {
free(dgraph[j]);
free(dbase[j]);
free(darray[j]);
}
free(dgraph);
free(dbase);
free(darray);
free(pool);
free(kmerpool);
free(systemstring);
free(systemlonginteger);
Py_RETURN_NONE;
}

static PyObject* mapkpgraphc(PyObject* self, PyObject* args)
{
char *infile1, *infile2, *outfile1, *outfile2, *outfile3, *outfile4;
FILE *infptr1, *infptr2, *outfptr1, *outfptr2, *outfptr3, *outfptr4;
kmer *kmerpool, *kmertemp;
contig *readpool, *readtemp;
long *dgraph, *darray, *systemlonginteger1, *systemlonginteger2, *tempptr, *kmertempsequenceseed, *kmertempreverseseed;
long i,j, r_number, k_number,kp, pp, temp1, temp2, temp3, temp4, temp5,temp6,temp7, temp8;
char *systemstring1, *systemstring2, *kmertempsequence, *kmertempreverse;
rdna['A']='T';
rdna['C']='G';
rdna['G']='C';
rdna['T']='A';
rdna['N']='N';
dti['A']=0;
dti['C']=1;
dti['G']=2;
dti['T']=3;
dti['N']=0;
//mapadd
//printf("1: ok\n");
    if (!PyArg_ParseTuple(args, "iiissssss", &k_mer, &p_mer, &i_mer, &infile1, &infile2, &outfile1, &outfile2, &outfile3, &outfile4))
        return NULL;

if (i_mer > max_i_mer)
 i_mer = max_i_mer;
pp=p_mer+1;
kp=k_mer+1;

//mapadd
//printf("2: ok\n");

infptr1=fopen( infile1, "r+" );
r_number= detectfilen(infptr1, &temp8);
temp7=temp8-(r_number*(i_mer-1));
temp1=(1<<(i_mer*2))+1;
readpool= (contig *) malloc(sizeof(contig) * r_number );
dgraph= (long *) malloc(sizeof(long)*temp1 );
darray= (long *) malloc(sizeof(long) * temp7*2);
for(i=0; i<temp1; i++)
dgraph[i]=0;
systemstring1= (char *) malloc( sizeof(char) * temp8);
temp1=0;
systemlonginteger1= (long *) malloc( sizeof(long) * temp7);
temp2=0;
//mapadd
//printf("3: ok\n");

for(i=0; i<r_number; i++) {
readtemp=&readpool[i];
readtemp->sequence=fgetl(&systemstring1[temp1] , &temp6, infptr1);
temp1+=temp6;
readtemp->length=temp6;
temp6-= (i_mer-1);
readtemp->sequenceseed= &systemlonginteger1[temp2];
temp2+= temp6;
for(j=0;j<temp6;j++) {
temp4=stoi( &readtemp->sequence[j]);
readtemp->sequenceseed[j]=temp4;
dgraph[temp4]+=2;
}
}
fclose(infptr1);
//mapadd
//printf("4: ok\n");

dgraph=preprocessingdgraphmap(dgraph);
//mapadd
//printf("5: ok\n");

for(i=0; i<r_number; i++) {
temp6=readpool[i].length-(i_mer-1);
tempptr=readpool[i].sequenceseed;
for(j=0; j<temp6; j++) {
temp4=tempptr[j];
darray[--dgraph[temp4]]=j;
darray[--dgraph[temp4]]=i;
}
}
//mapadd
//printf("6: ok\n");

for(i=0; i<temp7; i++)
systemlonginteger1[i]= -1;
//mapadd
//printf("7: ok\n");

infptr2=fopen( infile2, "r+" );
k_number= detectfilen(infptr2, &temp1);
kmerpool= (kmer *) malloc(sizeof(kmer) * k_number );
systemstring2= (char *) malloc( sizeof(char) * kp * 2 * k_number );
temp1=0;
systemlonginteger2= (long *) malloc( sizeof(long) * pp * 2 * k_number );
temp2=0;
temp5=k_mer+3;
//mapadd
//printf("8: ok\n");

for(i=0; i<k_number; i++) {
kmertemp=&kmerpool[i];
kmertemp->sequence=fgets(&systemstring2[temp1] , temp5, infptr2);
kmertemp->sequence[k_mer]=0;
temp1+= kp;
kmertemp->reverse= getreverse( &systemstring2[temp1], kmertemp->sequence);
temp1+= kp;
kmertemp->sequenceseed= &systemlonginteger2[temp2];
temp2+= pp;
kmertemp->reverseseed= &systemlonginteger2[temp2];
temp2+= pp;
temp3=0;
for(j=0;j<pp;j++) {
kmertemp->sequenceseed[j]=stoi(&kmertemp->sequence[temp3]);
kmertemp->reverseseed[j]=stoi(&kmertemp->reverse[temp3]);
temp3 += i_mer;
}
}
//mapadd
//printf("9: ok\n");

fclose(infptr2);
temp1=0;
//  temp1 is used
outfptr1=fopen(outfile1,"w+" );
outfptr2=fopen(outfile2,"w+" );
outfptr3=fopen(outfile3,"w+" );
outfptr4=fopen(outfile4,"w+" );
fprintf(outfptr4,"%ld,",temp1);
temp7=k_mer-1;
//mapadd
//printf("10: ok\n");
//printf("k_number= %ld\n",k_number);
for(i=0; i<k_number; i++) {
kmertempsequence=kmerpool[i].sequence;
kmertempreverse=kmerpool[i].reverse;
kmertempsequenceseed=kmerpool[i].sequenceseed;
kmertempreverseseed=kmerpool[i].reverseseed;
//printf("i=%ld positive",i );
for(j=0; j<pp; j++ ){
temp3=kmertempsequenceseed[j];
temp2=dgraph[temp3+1]-dgraph[temp3];
if(!temp2)
continue;
tempptr=&darray[dgraph[temp3]];
temp3=j*i_mer;
for(temp4=0; temp4<temp2;temp4++) {
temp5=tempptr[temp4++];
readtemp=&readpool[temp5];
temp6=tempptr[temp4];
temp6-=temp3;
if((temp6<0) || (temp6 >= (readtemp->length -temp7))|| (readtemp->sequenceseed[temp6]== i))
continue;
if(indistancec(kmertempsequence, &readtemp->sequence[temp6])) {
fprintf(outfptr1, "%ld,", temp5);
fprintf(outfptr2, "%ld,", temp6);
fprintf(outfptr3, "%ld,", 1);
readtemp->sequenceseed[temp6]=i;
temp1++;
} // end if
}//end for
}//end for
//printf(" negative\n" );
for(j=0; j<pp; j++ ){
temp3=kmertempreverseseed[j];
temp2=dgraph[temp3+1]-dgraph[temp3];
if(!temp2)
continue;
tempptr=&darray[dgraph[temp3]];
temp3=j*i_mer;
for(temp4=0; temp4<temp2;temp4++) {
temp5=tempptr[temp4++];
readtemp= &readpool[temp5];
temp6=tempptr[temp4];
temp6-=temp3;
if((temp6<0) || (temp6 >= (readtemp->length -temp7))|| (readtemp->sequenceseed[temp6]== i))
continue;
if(indistancec(kmertempreverse, &readtemp->sequence[temp6])) {
fprintf(outfptr1, "%ld,", temp5);
fprintf(outfptr2, "%ld,", temp6);
fprintf(outfptr3, "%ld,", 0);
readtemp->sequenceseed[temp6]=i;
temp1++;
} // end if
}//end for
}//end for
fprintf(outfptr4,"%ld,",temp1);
}//end for
//mapadd
//printf("11: ok\n");
fclose(outfptr1);
fclose(outfptr2);
fclose(outfptr3);
fclose(outfptr4);
free(dgraph);
free(darray);
free(kmerpool);
free(readpool);
free(systemstring1);
free(systemstring2);
free(systemlonginteger1);
free(systemlonginteger2);
Py_RETURN_NONE;
}

static PyObject* mapkpgraphtransc(PyObject* self, PyObject* args)
{
char *infile1, *infile2, *outfile1, *outfile2, *outfile3;
FILE *infptr1, *infptr2, *outfptr1, *outfptr2, *outfptr3;
kmer *kmerpool, *kmertemp;
contig *readpool, *readtemp;
long *dgraph, *darray, *systemlonginteger1, *systemlonginteger2, *tempptr, *kmertempsequenceseed;
long i,j, r_number, k_number,kp, pp, temp1, temp2, temp3, temp4, temp5,temp6,temp7, temp8;
char *systemstring1, *systemstring2, *kmertempsequence;
rdna['A']='T';
rdna['C']='G';
rdna['G']='C';
rdna['T']='A';
rdna['N']='N';
dti['A']=0;
dti['C']=1;
dti['G']=2;
dti['T']=3;
dti['N']=0;

    if (!PyArg_ParseTuple(args, "iiisssss", &k_mer, &p_mer, &i_mer, &infile1, &infile2, &outfile1, &outfile2, &outfile3))
        return NULL;

if (i_mer > max_i_mer)
 i_mer = max_i_mer;
pp=p_mer+1;
kp=k_mer+1;


infptr1=fopen( infile1, "r+" );
r_number= detectfilen(infptr1, &temp8);
temp7=temp8-(r_number*(i_mer-1));
temp1=(1<<(i_mer*2))+1;
readpool= (contig *) malloc(sizeof(contig) * r_number );
dgraph= (long *) malloc(sizeof(long)*temp1 );
darray= (long *) malloc(sizeof(long) * temp7*2);
for(i=0; i<temp1; i++)
dgraph[i]=0;
systemstring1= (char *) malloc( sizeof(char) * temp8);
temp1=0;
systemlonginteger1= (long *) malloc( sizeof(long) * temp7);
temp2=0;
for(i=0; i<r_number; i++) {
readtemp=&readpool[i];
readtemp->sequence=fgetl(&systemstring1[temp1] , &temp6, infptr1);
temp1+=temp6;
readtemp->length=temp6;
temp6-= (i_mer-1);
readtemp->sequenceseed= &systemlonginteger1[temp2];
temp2+= temp6;
for(j=0;j<temp6;j++) {
temp4=stoi(&readtemp->sequence[j]);
readtemp->sequenceseed[j]=temp4;
dgraph[temp4]+= 2;
}
}
fclose(infptr1);
dgraph=preprocessingdgraphmap(dgraph);
for(i=0; i<r_number; i++) {
temp6=readpool[i].length-(i_mer-1);
tempptr=readpool[i].sequenceseed;
for(j=0; j<temp6; j++) {
temp4=tempptr[j];
darray[--dgraph[temp4]]=j;
darray[--dgraph[temp4]]=i;
}
}
for(i=0; i<temp7; i++)
systemlonginteger1[i]= -1;
infptr2=fopen( infile2, "r+" );
k_number= detectfilen(infptr2,&temp1);
kmerpool= (kmer *) malloc(sizeof(kmer) * k_number );
systemstring2= (char *) malloc( sizeof(char) * kp * k_number );
temp1=0;
systemlonginteger2= (long *) malloc( sizeof(long) * pp * k_number );
temp2=0;
temp5=k_mer+3;
for(i=0; i<k_number; i++) {
kmertemp=&kmerpool[i];
kmertemp->sequence=fgets(&systemstring2[temp1] , temp5, infptr2);
kmertemp->sequence[k_mer]=0;
temp1+= kp;
kmertemp->sequenceseed= &systemlonginteger2[temp2];
temp2+= pp;
temp3=0;
for(j=0;j<pp;j++) {
kmertemp->sequenceseed[j]=stoi(&kmertemp->sequence[temp3]);
temp3 += i_mer;
}
}
fclose(infptr2);
temp1=0;
//  temp1 is used
outfptr1=fopen(outfile1,"w+" );
outfptr2=fopen(outfile2,"w+" );
outfptr3=fopen(outfile3,"w+" );
fprintf(outfptr3,"%ld,",temp1);
temp7=k_mer-1;
for(i=0; i<k_number; i++) {
kmertempsequence=kmerpool[i].sequence;
kmertempsequenceseed=kmerpool[i].sequenceseed;
for(j=0; j<pp; j++ ){
temp3=kmertempsequenceseed[j];
temp2=dgraph[temp3+1]-dgraph[temp3];
if(!temp2)
continue;
tempptr=&darray[dgraph[temp3]];
temp3=j*i_mer;
for(temp4=0; temp4<temp2;temp4++) {
temp5=tempptr[temp4++];
readtemp=&readpool[temp5];
temp6=tempptr[temp4];
temp6-=temp3;
if((temp6<0) || (temp6 >= (readtemp->length -temp7))|| (readtemp->sequenceseed[temp6]== i))
continue;
if(indistancec(kmertempsequence, &readtemp->sequence[temp6])) {
fprintf(outfptr1, "%ld,", temp5);
fprintf(outfptr2, "%ld,", temp6);
readtemp->sequenceseed[temp6]=i;
temp1++;
} // end if
}//end for
}//end for
fprintf(outfptr3,"%ld,",temp1);
}//end for
fclose(outfptr1);
fclose(outfptr2);
fclose(outfptr3);
free(dgraph);
free(darray);
free(kmerpool);
free(readpool);
free(systemstring1);
free(systemstring2);
free(systemlonginteger1);
free(systemlonginteger2);
Py_RETURN_NONE;
}

kmer *sbuildkpgraph( contig *readpool, long r_number, long *k_number)
{
long *dgraph, *dbase, *darray, *systemseed, *tempptr;
long i,j,k,l, temp1, temp2, temp3, temp4, temp5, i_temp=i_mer,k_num=0, kmm= k_mer-1;
kmer *kmerpool, *kmerpool2, *kmertemp, *kmertemp2;
contig *readtemp;
char findkmer, *tempstring;

if((k_mer%2) != (i_mer%2))
i_mer--;
temp1=1<<(2*i_mer);
dgraph=(long *) malloc(sizeof(long)*temp1);
dbase=(long *) malloc(sizeof(long)*temp1);
for(i=0;i<temp1;i++)
dgraph[i]=0;
temp2=(k_mer-i_mer)/2;
for(i=0;i<r_number;i++) {
readtemp=&readpool[i];
temp1=readtemp->length-kmm;
k_num += temp1;
for(j=0; j<temp1; j++)
dgraph[stoi( &readtemp->sequence[j+temp2])]++;
}// end for
dbase= preprocessingdgraphreset(dgraph, dbase);
darray=(long *) malloc(sizeof(long) *k_num );
kmerpool=(kmer *) malloc(sizeof(kmer) *k_num);
systemseed=(long *) malloc(sizeof(long) * k_num );
k_num=0;
temp4=0;
for(i=0;i<r_number;i++) {
readtemp=&readpool[i];
temp1=readtemp->length-kmm;
readtemp->sequenceseed= &systemseed[temp4];
temp4+= temp1;
k=temp1;
for(j=0; j<temp1; j++) {
k--;
findkmer=0;
temp3=stoi( &readtemp->reverse[k+temp2]);
if (dgraph[temp3]) {
temp5=dgraph[temp3];
tempptr=&darray[dbase[temp3]];
tempstring= &readtemp->reverse[k];
for(l=0; l< temp5; l++ ) {
if(!strncmp(tempstring,((kmer *)tempptr[l])->sequence, k_mer)) {
((kmer *)tempptr[l])->weight+= readtemp->weight;
readtemp->sequenceseed[j]=tempptr[l];
findkmer=1;
break;
}
}
if(findkmer)
continue;
}
temp3=stoi( &readtemp->sequence[j+temp2]);
if (dgraph[temp3]) {
temp5=dgraph[temp3];
tempptr=&darray[dbase[temp3]];
tempstring= &readtemp->sequence[j];
for(l=0; l< temp5; l++ ) {
if(!strncmp(tempstring,((kmer *)tempptr[l])->sequence, k_mer)) {
((kmer *)tempptr[l])->weight+= readtemp->weight;
readtemp->sequenceseed[j]=tempptr[l];
findkmer=1;
break;
}
}
if(findkmer)
continue;
}
kmertemp= &kmerpool[k_num];
kmertemp->sequence= &readtemp->sequence[j];
kmertemp->reverse= &readtemp->reverse[k];
kmertemp->weight= readtemp->weight;
kmertemp->fresh=1;
kmertemp->direction=1;
readtemp->sequenceseed[j]=(long)kmertemp;
darray[dbase[temp3]+dgraph[temp3]]=(long)kmertemp;
dgraph[temp3]++;
k_num++;
}// end for
}// end for
free(dgraph);
free(dbase);
free(darray);
kmerpool2 = (kmer *) malloc(sizeof(kmer)*k_num);
for(i=0;i<k_num;i++) {
kmertemp = &kmerpool[i];
kmertemp2 = &kmerpool2[i];
kmertemp2->sequence = kmertemp->sequence;
kmertemp2->reverse = kmertemp->reverse;
kmertemp2->weight = kmertemp->weight;
kmertemp2->fresh=1;
kmertemp2->direction=1;
kmertemp->sequenceseed = (long *)i;
}// end for
for(i=0;i<r_number;i++) {
readtemp=&readpool[i];
temp1=readtemp->length-kmm;
for(j=0; j<temp1; j++)
readtemp->sequenceseed[j] = (long) &kmerpool2[(long)(((kmer *)readtemp->sequenceseed[j])->sequenceseed)];
}// end for
free(kmerpool);
*k_number=k_num;
i_mer=i_temp;
return kmerpool2;
}

kmer *buildkpgraph(kmer *kmerpool, long k_number, long *n_number)
{
kmer *nodepool, *kmertemp;
long **dgraph, **darray, **dbase, *systemlonginteger, *tempptr, *pool, *temppool, *kmertempsequenceseed, *kmertempreverseseed;
long i,j, lentemppool, kp, pp, temp1, temp2, temp3, temp4, temp5,temp6,temp7;
char *kmertempsequence,kmertempdirection;

lentemppool=0;
pp=p_mer+1;
kp=k_mer+1;
dgraph= (long **) malloc(sizeof(long *) * pp);
darray= (long **) malloc(sizeof(long *) * pp);
dbase= (long **) malloc(sizeof(long *) * pp);
temp1=(1<<(i_mer*2));
for(j=0; j <pp; j++) {
dgraph[j]= (long *)malloc(sizeof(long) * temp1);
dbase[j]= (long *)malloc(sizeof(long) * temp1);
darray[j]= (long *) malloc(sizeof(long) * k_number);
systemlonginteger=dgraph[j];
for(i=0; i<temp1; i++)
systemlonginteger[i]=0;
}
systemlonginteger= (long *) malloc( sizeof(long) * pp * 2 * k_number );
temp2=0;
for(i=0; i<k_number; i++) {
kmertemp=&kmerpool[i];
kmertemp->sequenceseed= &systemlonginteger[temp2];
temp2+= pp;
kmertemp->reverseseed= &systemlonginteger[temp2];
temp2+= pp;
kmertemp->fresh=1;
kmertemp->direction=1;
temp3=0;
for(j=0;j<pp;j++) {
temp4=stoi(&kmertemp->sequence[temp3]);
kmertemp->sequenceseed[j]=temp4;
dgraph[j][temp4]+=1;
kmertemp->reverseseed[j]=stoi(&kmertemp->reverse[temp3]);
temp3 += i_mer;
}
}
for(j=0;j<pp;j++) {
dbase[j]=preprocessingdgraph(dgraph[j], dbase[j]);
tempptr=darray[j];
pool=dbase[j];
for(i=0; i<k_number; i++) {
tempptr[--pool[kmerpool[i].sequenceseed[j]]]=i;
}
}
temp1=0;
temp2=0;
// temp1, temp2 is used
pool= (long *) malloc(sizeof(long) * k_number );
temppool= (long *) malloc(sizeof(long) * (k_number+1) );
temppool[lentemppool]=temp2;
for(i=0; i<k_number; i++) {
if (!kmerpool[i].fresh)
continue;
 kmerpool[i].fresh=0;
pool[temp2++]=i;
while(temp1 < temp2) {
temp3=pool[temp1++];
kmertempsequence=kmerpool[temp3].sequence;
kmertempsequenceseed=kmerpool[temp3].sequenceseed;
kmertempreverseseed=kmerpool[temp3].reverseseed;
kmertempdirection=kmerpool[temp3].direction;
for(j=0; j<pp; j++ ){
temp3=kmertempsequenceseed[j];
if(!dgraph[j][temp3])  
continue;
temp5=0;
temp6=dgraph[j][temp3];
tempptr=&darray[j][dbase[j][temp3]];
for(temp4=0; temp4<temp6;temp4++) {
temp7=tempptr[temp4];
if(!kmerpool[temp7].fresh) 
continue;
if(indistancec(kmertempsequence,kmerpool[temp7].sequence)) {
kmerpool[temp7].fresh=0;
kmerpool[temp7].direction=kmertempdirection;
pool[temp2++]=temp7;
} // end if
else
tempptr[temp5++]=temp7;
}//end for
dgraph[j][temp3]=temp5;
}//end for
for(j=0; j<pp; j++ ){
temp3=kmertempreverseseed[j];
if(!dgraph[j][temp3]) 
continue;
temp5=0;
temp6=dgraph[j][temp3];
tempptr=&darray[j][dbase[j][temp3]];
for(temp4=0; temp4<temp6;temp4++) {
temp7=tempptr[temp4];
if(!kmerpool[temp7].fresh)
continue;
if(indistancec(kmertempsequence,kmerpool[temp7].reverse)) {
kmerpool[temp7].fresh=0;
kmerpool[temp7].direction= !kmertempdirection;
pool[temp2++]=temp7;
} // end if
else
tempptr[temp5++]=temp7;
}//end for
dgraph[j][temp3]=temp5;
}//end for
}//endwhile
temppool[++lentemppool]=temp2;
}//end for
for(i=0;i< k_number;i++) 
pool[i]= (long) &kmerpool[pool[i]];
nodepool=(kmer *) malloc(sizeof(kmer)*lentemppool);
for(i=0;i<lentemppool;i++) {
nodepool[i].sequenceseed=&pool[temppool[i]];
nodepool[i].weight= temppool[i+1] -temppool[i];
}
*n_number= lentemppool;
for(j=0; j<pp; j++) {
free(dgraph[j]);
free(dbase[j]);
free(darray[j]);
}
free(dgraph);
free(dbase);
free(darray);
free(temppool);
free(systemlonginteger);
return nodepool;
}

kmer *sbuildkpgraphtrans( contig *readpool, long r_number, long *k_number)
{
long *dgraph, *dbase, *darray, *systemseed, *tempptr;
long i,j,k,l, temp1, temp2, temp3, temp4, temp5, i_temp=i_mer,k_num=0, kmm= k_mer-1;
kmer *kmerpool, *kmerpool2, *kmertemp, *kmertemp2;
contig *readtemp;
char findkmer, *tempstring;

if((k_mer%2) != (i_mer%2))
i_mer--;
temp1=1<<(2*i_mer);
dgraph=(long *) malloc(sizeof(long)*temp1);
dbase=(long *) malloc(sizeof(long)*temp1);
for(i=0;i<temp1;i++)
dgraph[i]=0;
temp2=(k_mer-i_mer)/2;
for(i=0;i<r_number;i++) {
readtemp=&readpool[i];
temp1=readtemp->length-kmm;
k_num += temp1;
for(j=0; j<temp1; j++)
dgraph[stoi( &readtemp->sequence[j+temp2])]++;
}// end for
dbase= preprocessingdgraphreset(dgraph, dbase);
darray=(long *) malloc(sizeof(long) *k_num );
kmerpool=(kmer *) malloc(sizeof(kmer) *k_num);
systemseed=(long *) malloc(sizeof(long) * k_num );
k_num=0;
temp4=0;
for(i=0;i<r_number;i++) {
readtemp=&readpool[i];
temp1=readtemp->length-kmm;
readtemp->sequenceseed= &systemseed[temp4];
temp4+= temp1;
k=temp1;
for(j=0; j<temp1; j++) {
k--;
findkmer=0;
temp3=stoi( &readtemp->sequence[j+temp2]);
if (dgraph[temp3]) {
temp5=dgraph[temp3];
tempptr=&darray[dbase[temp3]];
tempstring= &readtemp->sequence[j];
for(l=0; l< temp5; l++ ) {
if(!strncmp(tempstring,((kmer *)tempptr[l])->sequence, k_mer)) {
((kmer *)tempptr[l])->weight+= readtemp->weight;
readtemp->sequenceseed[j]=tempptr[l];
findkmer=1;
break;
}
}
if(findkmer)
continue;
}
kmertemp= &kmerpool[k_num];
kmertemp->sequence= &readtemp->sequence[j];
kmertemp->reverse= &readtemp->reverse[k];
kmertemp->weight= readtemp->weight;
kmertemp->fresh=1;
kmertemp->direction=1;
readtemp->sequenceseed[j]=(long)kmertemp;
darray[dbase[temp3]+dgraph[temp3]]=(long)kmertemp;
dgraph[temp3]++;
k_num++;
}// end for
}// end for
free(dgraph);
free(dbase);
free(darray);
kmerpool2 = (kmer *) malloc(sizeof(kmer)*k_num);
for(i=0;i<k_num;i++) {
kmertemp = &kmerpool[i];
kmertemp2 = &kmerpool2[i];
kmertemp2->sequence = kmertemp->sequence;
kmertemp2->reverse = kmertemp->reverse;
kmertemp2->weight = kmertemp->weight;
kmertemp2->fresh=1;
kmertemp2->direction=1;
kmertemp->sequenceseed = (long *)i;
}// end for
for(i=0;i<r_number;i++) {
readtemp=&readpool[i];
temp1=readtemp->length-kmm;
for(j=0; j<temp1; j++)
readtemp->sequenceseed[j] = (long) &kmerpool2[(long)(((kmer *)readtemp->sequenceseed[j])->sequenceseed)];
}// end for
free(kmerpool);
*k_number=k_num;
i_mer=i_temp;
return kmerpool2;
}

kmer *buildkpgraphtrans(kmer *kmerpool, long k_number, long *n_number)
{
kmer *nodepool, *kmertemp;
long **dgraph, **darray, **dbase, *systemlonginteger, *tempptr, *pool, *temppool, *kmertempsequenceseed;
long i,j, lentemppool, kp, pp, temp1, temp2, temp3, temp4, temp5,temp6,temp7;
char *kmertempsequence;

lentemppool=0;
pp=p_mer+1;
kp=k_mer+1;
dgraph= (long **) malloc(sizeof(long *) * pp);
darray= (long **) malloc(sizeof(long *) * pp);
dbase= (long **) malloc(sizeof(long *) * pp);
temp1=(1<<(i_mer*2));
for(j=0; j <pp; j++) {
dgraph[j]= (long *)malloc(sizeof(long) * temp1);
dbase[j]= (long *)malloc(sizeof(long) * temp1);
darray[j]= (long *) malloc(sizeof(long) * k_number);
systemlonginteger=dgraph[j];
for(i=0; i<temp1; i++)
systemlonginteger[i]=0;
}
systemlonginteger= (long *) malloc( sizeof(long) * pp * k_number );
temp2=0;
for(i=0; i<k_number; i++) {
kmertemp=&kmerpool[i];
kmertemp->sequenceseed= &systemlonginteger[temp2];
temp2+= pp;
kmertemp->fresh=1;
kmertemp->direction=1;
temp3=0;
for(j=0;j<pp;j++) {
temp4=stoi(&kmertemp->sequence[temp3]);
kmertemp->sequenceseed[j]=temp4;
dgraph[j][temp4]+=1;
temp3 += i_mer;
}
}
for(j=0;j<pp;j++) {
dbase[j]=preprocessingdgraph(dgraph[j], dbase[j]);
tempptr=darray[j];
pool=dbase[j];
for(i=0; i<k_number; i++) {
tempptr[--pool[kmerpool[i].sequenceseed[j]]]=i;
}
}
temp1=0;
temp2=0;
// temp1, temp2 is used
pool= (long *) malloc(sizeof(long) * k_number );
temppool= (long *) malloc(sizeof(long) * (k_number+1) );
temppool[lentemppool]=temp2;
for(i=0; i<k_number; i++) {
if (!kmerpool[i].fresh)
continue;
 kmerpool[i].fresh=0;
pool[temp2++]=i;
while(temp1 < temp2) {
temp3=pool[temp1++];
kmertempsequence=kmerpool[temp3].sequence;
kmertempsequenceseed=kmerpool[temp3].sequenceseed;
for(j=0; j<pp; j++ ){
temp3=kmertempsequenceseed[j];
if(!dgraph[j][temp3])  
continue;
temp5=0;
temp6=dgraph[j][temp3];
tempptr=&darray[j][dbase[j][temp3]];
for(temp4=0; temp4<temp6;temp4++) {
temp7=tempptr[temp4];
if(!kmerpool[temp7].fresh) 
continue;
if(indistancec(kmertempsequence,kmerpool[temp7].sequence)) {
kmerpool[temp7].fresh=0;
pool[temp2++]=temp7;
} // end if
else
tempptr[temp5++]=temp7;
}//end for
dgraph[j][temp3]=temp5;
}//end for
}//endwhile
temppool[++lentemppool]=temp2;
}//end for
for(i=0;i< k_number;i++) 
pool[i]= (long) &kmerpool[pool[i]];
nodepool=(kmer *) malloc(sizeof(kmer)*lentemppool);
for(i=0;i<lentemppool;i++) {
nodepool[i].sequenceseed=&pool[temppool[i]];
nodepool[i].weight= temppool[i+1] -temppool[i];
}
*n_number= lentemppool;
for(j=0; j<pp; j++) {
free(dgraph[j]);
free(dbase[j]);
free(darray[j]);
}
free(dgraph);
free(dbase);
free(darray);
free(temppool);
free(systemlonginteger);
return nodepool;
}

long findsplit(kmer *node, long **dlist)
{
long *tempptr, i,j,k, temp1, temp2, len=node->weight;
kmer *kmertemp;
if(len==1) {
kmertemp= (kmer *)node->sequenceseed[0];
node->sequence=strncpy(node->sequence, kmertemp->sequence,k_mer);
node->weight=kmertemp->weight;
kmertemp->weight=(long)node;
return -1;
}
for(i=0; i<k_mer;i++) 
for(j=0;j<4;j++) 
dlist[i][j]=0;
for(j=0;j<len;j++) {
kmertemp=(kmer *)node->sequenceseed[j];
for(i=0;i<k_mer;i++) {
dlist[i][dti[kmertemp->sequence[i]]]+=kmertemp->weight;
}
}
for(i=0; i<k_mer;i++) {
tempptr=dlist[i];
k=0;
for(j=1;j<4;j++) {
if(tempptr[j]> tempptr[k])
k=j;
}
node->sequence[i]=itd[k];
}
node->weight=tempptr[0]+tempptr[1]+tempptr[2]+tempptr[3];
if(idealerrorfraction>0 && node->weight< idealnumber) {
for(j=0;j<len;j++) 
((kmer *)node->sequenceseed[j])->weight=(long)node;
return -1;
}
for(i=0; i<k_mer;i++) {
k=dti[node->sequence[i]];
temp1=(long)(dlist[i][k]*splitparameter);
for(j=0;j<4;j++) {
temp2=dlist[i][j];
if((k!=j) && (temp2)) {
if( ( ( idealerrorfraction==0 || temp2>= idealnumber) && ((temp2/((float)node->weight))>= idealerrorfraction) ) || ( temp2 >= temp1)) {
node->weight=len;
return ((i*4)+j);
}// end if
} // end if
}// end for
} // end for
for(j=0;j<len;j++) 
((kmer *)node->sequenceseed[j])->weight=(long)node;
return -1;
}

void splitnode( kmer *nodepool, char *nodestring, long *nodenumber, long *longpool, long *temppool, long *poolnumber, long **dlist)
{
long i, temp1, temp2, temp3, p, d, *tempptr;
kmer *tempnode;
tempnode= &nodepool[*nodenumber];
i=findsplit(tempnode, dlist);
if(i == -1) {
*nodenumber= *nodenumber + 1;
return ;
}
p=i/4;
d=i%4;
tempptr=tempnode->sequenceseed;
temp1=tempnode->weight;
temp2=temppool[*poolnumber];
temp3=0;
for(i=0;i<temp1;i++) {
//tempkmer= (kmer *)(tempptr[i]);
//if(dti[tempkmer->sequence[p]] == d) {
if(dti[((kmer *)(tempptr[i]))->sequence[p]] == d) 
longpool[temp2++]=tempptr[i];
else
tempptr[temp3++]=tempptr[i];
}
tempnode->weight=temp3;
tempnode->fresh=0;
*poolnumber=*poolnumber+1;
temppool[*poolnumber]=temp2;
splitnode( nodepool, nodestring, nodenumber, longpool, temppool, poolnumber, dlist);
tempnode= &nodepool[*nodenumber];
tempptr=&tempptr[temp3];
tempnode->sequenceseed=tempptr;
tempnode->fresh=0;
temp3=temppool[(*poolnumber)];
*poolnumber= *poolnumber -1;
temp2=temppool[(*poolnumber)];
tempnode->weight= temp3-temp2;
temp1=0;
for(i=temp3-1;i>= temp2; i-- )
tempptr[temp1++]=longpool[i];
tempnode->sequence=&nodestring[(*nodenumber)*k_mer];
splitnode( nodepool, nodestring, nodenumber, longpool, temppool, poolnumber, dlist);
return ;
}

kmer *adjustkmersequence(kmer *kmerpool, long k_number)
{
long i;
char *temp;
kmer *kmertemp;
for(i=0;i<k_number;i++) {
kmertemp= &kmerpool[i];
if(!kmertemp->direction) {
kmertemp->direction=1;
temp=kmertemp->sequence;
kmertemp->sequence=kmertemp->reverse;
kmertemp->reverse=temp;
}
}
return kmerpool;
}

kmer *splitnodes(kmer *nodepool, long n_number1, long *n_number2)
{
kmer *nodepool2, *nodetemp1, *nodetemp2;
long i,k_number, nodenumber=0, poolnumber=0;
long **dlist, *longpool, *temppool;
char *nodestring, *nodestring2;
//findsplit  find sequence and set kmerweight if not splited
//splitnode split and set fresh
dlist=(long **) malloc(sizeof(long *)*k_mer);
for(i=0;i<k_mer;i++)
dlist[i]=(long *) malloc(sizeof(long)*4);
k_number=*n_number2;
longpool=(long *) malloc(sizeof(long)*k_number);
temppool=(long *) malloc(sizeof(long)*(k_number+1));
temppool[0]=0;
nodestring2=(char *) malloc(sizeof(char)*k_number*k_mer);
nodepool2= (kmer *) malloc(sizeof(kmer)*k_number);
for(i=0;i<n_number1;i++) {
nodetemp1=&nodepool[i];
nodetemp2=&nodepool2[nodenumber];
nodetemp2->sequence=&nodestring2[nodenumber*k_mer];
nodetemp2->fresh=2;
nodetemp2->weight=nodetemp1->weight;
nodetemp2->sequenceseed=nodetemp1->sequenceseed;
splitnode( nodepool2, nodestring2, &nodenumber, longpool, temppool, &poolnumber, dlist);
}
free(nodepool);
free(longpool);
free(temppool);
for(i=0;i<k_mer;i++)
free(dlist[i]);
free(dlist);
/*
nodepool=(kmer *) malloc(sizeof(kmer)*nodenumber);
nodestring=(char *)malloc(sizeof(char)*nodenumber*k_mer);
nodestring=memcpy(nodestring,nodestring2,nodenumber*k_mer);
for(i=0;i<nodenumber;i++) {
nodetemp1= &nodepool[i];
nodetemp2=&nodepool2[i];
nodetemp1->sequence= &nodestring[i*k_mer];
nodetemp1->fresh=nodetemp2->fresh;
nodetemp1->weight=nodetemp2->weight;
nodetemp1->sequenceseed=nodetemp2->sequenceseed;
}
free(nodestring2);
free(nodepool2);
*/
*n_number2=nodenumber;
return nodepool2;
}

supercontig *createsupercontigbykmer(contig *readpool, kmer *kmerpool, long r_number, long k_number)
{
supercontig *superpool, *tempsupercontig;
contig *tempread;
kmer *tempkmer;
long *allsequenceseed;
long i,j=0;
for(i=0;i<r_number;i++) {
tempread = &readpool[i];
 tempread->reverseseed = (long *)tempread->sequenceseed[(tempread->length-k_mer)];
 tempread->sequenceseed = (long *)tempread->sequenceseed[0];
}
superpool= (supercontig *) malloc(sizeof(supercontig)*k_number);
allsequenceseed= (long *) malloc(sizeof(long)*k_number);
for(i=0;i<k_number;i++) {
tempsupercontig= &superpool[i];
tempkmer= &kmerpool[i];
tempsupercontig->sequence = tempkmer->sequence;
tempsupercontig->reverse = tempkmer->reverse;
j+= k_mer;
tempsupercontig->sequenceseed= &allsequenceseed[i];
tempsupercontig->sequenceseed[0] = (long)tempkmer;
tempsupercontig->length= k_mer;
tempsupercontig->weight= 1;
tempsupercontig->prelength= 0;
tempsupercontig->nextlength= 0;
tempsupercontig->fresh= 1;
}
return superpool;
}

supercontig *createsupercontigbycontig(contig *contigpool, long c_number)
{
supercontig *superpool, *tempsupercontig;
contig *tempcontig;
char *allreverse;
long i,j=0;

for(i=0;i<c_number;i++)
j+= (&contigpool[i])->length;
superpool= (supercontig *) malloc(sizeof(supercontig)*c_number);
allreverse= (char *) malloc(sizeof(char)*j);
j=0;
for(i=0;i<c_number;i++) {
tempsupercontig= &superpool[i];
tempcontig= &contigpool[i];
tempsupercontig->sequence= tempcontig->sequence;
tempsupercontig->reverse= getreversen(&allreverse[j],tempcontig->sequence,tempcontig->length);
j+= tempcontig->length;
tempsupercontig->sequenceseed= tempcontig->sequenceseed;
tempsupercontig->length= tempcontig->length;
tempsupercontig->weight= tempcontig->weight;
tempsupercontig->prelength= 0;
tempsupercontig->nextlength= 0;
tempsupercontig->fresh= 1;
}
return superpool;
}

supercontig *refreshcontig(supercontig *supercontigpool, long c_number)
{
long i;
for(i=0;i<c_number;i++)
(&supercontigpool[i])->fresh=1;
return supercontigpool;
}

supercontig *linkcontig(supercontig *supercontigpool, long c_number, long distance)
{
long i,j=(1<<(i_mer*2));
long temp,kmd=k_mer-distance,prelen=0,nextlen=0;
long *dgs, *dgr, *dbs, *dbr;
supercontig **sarray, **rarray, **pre, **next;
supercontig *ptr, *current;
char *tempstring,*predirection,*nextdirection;

dgs = (long *)malloc(sizeof(long)*j);
dgr = (long *)malloc(sizeof(long)*j);
dbs = (long *)malloc(sizeof(long)*j);
dbr = (long *)malloc(sizeof(long)*j);
sarray = (supercontig **)malloc(sizeof(supercontig *)*c_number);
rarray = (supercontig **)malloc(sizeof(supercontig *)*c_number);

for(i=0;i<=j;i++) {
dgs[i]=0;
dgr[i]=0;
}
for(i=0;i<c_number;i++) {
ptr = &supercontigpool[i];
dgs[stoi(ptr->sequence)]++;
dgr[stoi(ptr->reverse)]++;
}
dbs = preprocessingdgraphreset(dgs, dbs);
dbr = preprocessingdgraphreset(dgr, dbr);
for(i=0;i<c_number;i++) {
ptr = &supercontigpool[i];
temp = stoi(ptr->sequence);
sarray[dbs[temp]+dgs[temp]] = ptr;
dgs[temp]++;
temp = stoi(ptr->reverse);
rarray[dbr[temp]+dgr[temp]] = ptr;
dgr[temp]++;
}
for(i=0;i<c_number;i++) {
ptr = &supercontigpool[i];
tempstring = &ptr->sequence[ptr->length-kmd];
temp = stoi(tempstring);
if(dgs[temp]) {
for(j=dbs[temp];j<dbs[temp]+dgs[temp];j++) {
if(!strncmp(tempstring,sarray[j]->sequence,kmd)) {
ptr->nextlength++;
nextlen++;
}
}
}
// end if of next true
if(dgr[temp]) {
for(j=dbr[temp];j<dbr[temp]+dgr[temp];j++) {
current = rarray[j];
if((!strncmp(tempstring,current->reverse,kmd)) && (ptr != current)) {
ptr->nextlength++;
nextlen++;
}
}
}
// end if of next false
tempstring = &ptr->reverse[ptr->length-kmd];
temp = stoi(tempstring);
if(dgr[temp]) {
for(j=dbr[temp];j<dbr[temp]+dgr[temp];j++) {
if(!strncmp(tempstring,rarray[j]->reverse,kmd)) {
ptr->prelength++;
prelen++;
}
}
}
// end if of pre true
if(dgs[temp]) {
for(j=dbs[temp];j<dbs[temp]+dgs[temp];j++) {
current = sarray[j];
if((!strncmp(tempstring,current->sequence,kmd)) && (ptr != current)) {
ptr->prelength++;
prelen++;
}
}
}
// end if of pre false
}
// end for
pre = (supercontig **) malloc(sizeof(supercontig *)*prelen);
next = (supercontig **) malloc(sizeof(supercontig *)*nextlen);
predirection = (char *) malloc(sizeof(char)*prelen);
nextdirection = (char *) malloc(sizeof(char)*nextlen);
prelen = 0;
nextlen = 0;
for(i=0;i<c_number;i++) {
ptr = &supercontigpool[i];
ptr->pre = &pre[prelen];
ptr->next = &next[nextlen];
ptr->predirection = &predirection[prelen];
ptr->nextdirection = &nextdirection[nextlen];
if(ptr->nextlength) {
ptr->nextlength = 0;
tempstring = &ptr->sequence[ptr->length-kmd];
temp = stoi(tempstring);
if(dgs[temp]) {
for(j=dbs[temp];j<dbs[temp]+dgs[temp];j++) {
if(!strncmp(tempstring,sarray[j]->sequence,kmd)) {
ptr->next[ptr->nextlength] = sarray[j];
ptr->nextdirection[ptr->nextlength] = 1;
ptr->nextlength++;
nextlen++;
}
}
}
// end if of next true
if(dgr[temp]) {
for(j=dbr[temp];j<dbr[temp]+dgr[temp];j++) {
current = rarray[j];
if((!strncmp(tempstring,current->reverse,kmd)) && (ptr != current)) {
ptr->next[ptr->nextlength] = current;
ptr->nextdirection[ptr->nextlength] = 0;
ptr->nextlength++;
nextlen++;
}
}
}
// end if of next false
}
// end if of nextlength
if(ptr->prelength) {
ptr->prelength = 0;
tempstring = &ptr->reverse[ptr->length-kmd];
temp = stoi(tempstring);
if(dgr[temp]) {
for(j=dbr[temp];j<dbr[temp]+dgr[temp];j++) {
if(!strncmp(tempstring,rarray[j]->reverse,kmd)) {
ptr->pre[ptr->prelength] = rarray[j];
ptr->predirection[ptr->prelength] = 1;
ptr->prelength++;
prelen++;
}
}
}
// end if of pre true
if(dgs[temp]) {
for(j=dbs[temp];j<dbs[temp]+dgs[temp];j++) {
current = sarray[j];
if((!strncmp(tempstring,current->sequence,kmd)) && (ptr != current)) {
ptr->pre[ptr->prelength] = current;
ptr->predirection[ptr->prelength] = 0;
ptr->prelength++;
prelen++;
}
}
}
// end if of pre false
}
// end if of prelength
}
// end for
free(dgs);
free(dgr);
free(dbs);
free(dbr);
free(sarray);
free(rarray);
return supercontigpool;
}

supercontig *linkcontigtrans(supercontig *supercontigpool, long c_number, long distance)
{
long i,j=(1<<(i_mer*2));
long temp,kmd=k_mer-distance,prelen=0,nextlen=0;
long *dgs, *dgr, *dbs, *dbr;
supercontig **sarray, **rarray, **pre, **next;
supercontig *ptr, *current;
char *tempstring,*predirection,*nextdirection;

dgs = (long *)malloc(sizeof(long)*j);
dgr = (long *)malloc(sizeof(long)*j);
dbs = (long *)malloc(sizeof(long)*j);
dbr = (long *)malloc(sizeof(long)*j);
sarray = (supercontig **)malloc(sizeof(supercontig *)*c_number);
rarray = (supercontig **)malloc(sizeof(supercontig *)*c_number);

for(i=0;i<=j;i++) {
dgs[i]=0;
dgr[i]=0;
}
for(i=0;i<c_number;i++) {
ptr = &supercontigpool[i];
dgs[stoi(ptr->sequence)]++;
dgr[stoi(ptr->reverse)]++;
}
dbs = preprocessingdgraphreset(dgs, dbs);
dbr = preprocessingdgraphreset(dgr, dbr);
for(i=0;i<c_number;i++) {
ptr = &supercontigpool[i];
temp = stoi(ptr->sequence);
sarray[dbs[temp]+dgs[temp]] = ptr;
dgs[temp]++;
temp = stoi(ptr->reverse);
rarray[dbr[temp]+dgr[temp]] = ptr;
dgr[temp]++;
}
for(i=0;i<c_number;i++) {
ptr = &supercontigpool[i];
tempstring = &ptr->sequence[ptr->length-kmd];
temp = stoi(tempstring);
if(dgs[temp]) {
for(j=dbs[temp];j<dbs[temp]+dgs[temp];j++) {
if(!strncmp(tempstring,sarray[j]->sequence,kmd)) {
ptr->nextlength++;
nextlen++;
}
}
}
// end if of next true
tempstring = &ptr->reverse[ptr->length-kmd];
temp = stoi(tempstring);
if(dgr[temp]) {
for(j=dbr[temp];j<dbr[temp]+dgr[temp];j++) {
if(!strncmp(tempstring,rarray[j]->reverse,kmd)) {
ptr->prelength++;
prelen++;
}
}
}
// end if of pre true
}
// end for
pre = (supercontig **) malloc(sizeof(supercontig *)*prelen);
next = (supercontig **) malloc(sizeof(supercontig *)*nextlen);
predirection = (char *) malloc(sizeof(char)*prelen);
nextdirection = (char *) malloc(sizeof(char)*nextlen);
prelen = 0;
nextlen = 0;
for(i=0;i<c_number;i++) {
ptr = &supercontigpool[i];
ptr->pre = &pre[prelen];
ptr->next = &next[nextlen];
ptr->predirection = &predirection[prelen];
ptr->nextdirection = &nextdirection[nextlen];
if(ptr->nextlength) {
ptr->nextlength = 0;
tempstring = &ptr->sequence[ptr->length-kmd];
temp = stoi(tempstring);
if(dgs[temp]) {
for(j=dbs[temp];j<dbs[temp]+dgs[temp];j++) {
if(!strncmp(tempstring,sarray[j]->sequence,kmd)) {
ptr->next[ptr->nextlength] = sarray[j];
ptr->nextdirection[ptr->nextlength] = 1;
ptr->nextlength++;
nextlen++;
}
}
}
// end if of next true
}
// end if of nextlength
if(ptr->prelength) {
ptr->prelength = 0;
tempstring = &ptr->reverse[ptr->length-kmd];
temp = stoi(tempstring);
if(dgr[temp]) {
for(j=dbr[temp];j<dbr[temp]+dgr[temp];j++) {
if(!strncmp(tempstring,rarray[j]->reverse,kmd)) {
ptr->pre[ptr->prelength] = rarray[j];
ptr->predirection[ptr->prelength] = 1;
ptr->prelength++;
prelen++;
}
}
}
// end if of pre true
}
// end if of prelength
}
// end for
free(dgs);
free(dgr);
free(dbs);
free(dbr);
free(sarray);
free(rarray);
return supercontigpool;
}

supercontig *flick(supercontig *self)
{
char *temp;
long i,j,s;

temp=self->sequence;
self->sequence=self->reverse;
self->reverse=temp;
j=self->weight;
for(i=0;i<(self->weight/2);i++) {
j--;
s = self->sequenceseed[i];
self->sequenceseed[i] = self->sequenceseed[j];
self->sequenceseed[j] = s;
}
return self;
}

long findpair(supercontig **fl, char *sl, supercontig *fo, char so)
{
long j;
for(j=0;j<4;j++) {
if(fl[j] == fo) {
if(sl[j] == so) {
return j;
}
}
}
return -1;
}

supercontig *extendnext(supercontig *self, supercontig *current, char *samedirection, long distance, char *tempsequence, long *tempsequenceptr, long *tempnodelist, long *tempnodelistptr)
{
supercontig **pre;
supercontig *next;
char nextdirection,prelength;
long i,kmd,kmm;

if(self->nextlength==1) {
next = self->next[0];
nextdirection = self->nextdirection[0];
if(nextdirection==1) {
prelength = next->prelength;
pre = next->pre;
} else {
prelength = next->nextlength;
pre = next->next;
}
// 3- end if
if(prelength==1) {
if(next!=self) {
if(nextdirection==1) {
self->nextlength = next->nextlength;
self->next = next->next;
self->nextdirection = next->nextdirection;
} else {
next = flick(next);
self->nextlength = next->prelength;
self->next = next->pre;
self->nextdirection = next->predirection;
for(i=0;i<next->prelength;i++) {
if(next->predirection[i]==1)
self->nextdirection[i] = 0;
else
self->nextdirection[i] = 1;
}
}
// 5- end if
kmd = k_mer - distance;
kmm = next->length - kmd;
strncpy(&tempsequence[*tempsequenceptr],&(next->sequence[kmd]),kmm);
*tempsequenceptr = *tempsequenceptr + kmm;
self->length += kmm;
if(distance>1) {
kmm = distance - 1;
self->weight += kmm;
for(i=0;i<kmm;i++) {
tempnodelist[*tempnodelistptr] = 0;
*tempnodelistptr = *tempnodelistptr + 1;
}
}
// 5- end if
longncpy(&tempnodelist[*tempnodelistptr],next->sequenceseed,next->weight);
*tempnodelistptr = *tempnodelistptr + next->weight;
self->weight += next->weight;
*samedirection = nextdirection;
return next;
}
// 4- end if
}
// 3- end if
}
// 2- end if
if((*samedirection)==1) {
for(i=0;i<self->nextlength;i++) {
next=self->next[i];
if(self->nextdirection[i]==1)
next->pre[findpair(next->pre,next->predirection,current,1)] = self;
else
next->next[findpair(next->next,next->nextdirection,current,0)] = self;
}
// 3- end for
} else {
for(i=0;i<self->nextlength;i++) {
next=self->next[i];
if(self->nextdirection[i]==1) {
kmd = findpair(next->pre,next->predirection,current,0);
next->pre[kmd] = self;
next->predirection[kmd] = 1;
} else {
kmd = findpair(next->next,next->nextdirection,current,1);
next->next[kmd] = self;
next->nextdirection[kmd] = 0;
}
// 4- end if
}
// 3- end for
}
// 2- end if
return NULL;
}

supercontig *extendpre(supercontig *self, supercontig *current, char *samedirection, long distance, char *tempsequence, long *tempsequenceptr, long *tempnodelist, long *tempnodelistptr)
{
supercontig **next;
supercontig *pre;
char predirection,nextlength;
long i,kmd,kmm;

if(self->prelength==1) {
pre=self->pre[0];
predirection=self->predirection[0];
if(predirection==1) {
next=pre->next;
nextlength=pre->nextlength;
} else {
next=pre->pre;
nextlength=pre->prelength;
}
if(nextlength==1) {
if(pre != self) {
if(predirection==1) {
self->prelength=pre->prelength;
self->pre=pre->pre;
self->predirection=pre->predirection;
} else {
pre=flick(pre);
self->prelength=pre->nextlength;
self->pre=pre->next;
self->predirection=pre->nextdirection;
for(i=0;i<pre->nextlength;i++) {
if(pre->nextdirection[i]==1)
self->predirection[i] = 0;
else
self->predirection[i] = 1;
}
}
// 5- end if
kmd = k_mer - distance;
kmm = pre->length - kmd;
*tempsequenceptr = *tempsequenceptr - kmm;
strncpy(&tempsequence[*tempsequenceptr],pre->sequence,kmm);
self->length += kmm;
if(distance>1) {
kmm = distance - 1;
self->weight += kmm;
for(i=0;i<kmm;i++) {
*tempnodelistptr = *tempnodelistptr - 1;
tempnodelist[*tempnodelistptr] = 0;
}
}
// 5- end if
*tempnodelistptr = *tempnodelistptr - pre->weight;
longncpy(&tempnodelist[*tempnodelistptr],pre->sequenceseed,pre->weight);
self->weight += pre->weight;
*samedirection = predirection;
return pre;
}
// 4- end if
}
// 3- end if
}
// 2- end if
if((*samedirection)==1) {
for(i=0;i<self->prelength;i++) {
pre=self->pre[i];
if(self->predirection[i]==1)
pre->next[findpair(pre->next,pre->nextdirection,current,1)] = self;
else
pre->pre[findpair(pre->pre,pre->predirection,current,0)] = self;
}
// 3- end for
} else {
for(i=0;i<self->prelength;i++) {
pre=self->pre[i];
if(self->predirection[i]==1) {
kmd = findpair(pre->next,pre->nextdirection,current,0);
pre->next[kmd] = self;
pre->nextdirection[kmd] = 1;
} else {
kmd = findpair(pre->pre,pre->predirection,current,1);
pre->pre[kmd] = self;
pre->predirection[kmd] = 0;
}
// 4- end if
}
// 3- end for
}
// 2- end if
return NULL;
}

supercontig *mergecontig(supercontig *supercontigpool, long *c_number, long distance)
{
supercontig **ptrpool, **pre, **next;
supercontig *pool, *ptr, *current;
supercontig freeptr;
long i,j,tempsequenceptr,tempnodelistptr,sequencelength=0,nodelistlength=0,p_number=0;
char samedirection;
char *tempsequence, *presequence, *reversesequence, *predirection, *nextdirection;
long *tempnodelist, *prenodelist;

// setting freeptr for preparation of free old data
ptr = &freeptr;
current = &supercontigpool[0];
ptr->pre=current->pre;
ptr->next=current->next;
ptr->predirection=current->predirection;
ptr->nextdirection=current->nextdirection;
// than start
ptrpool = (supercontig **) malloc(sizeof(supercontig *)*(*c_number));
for(i=0;i<(*c_number);i++) {
ptr= &supercontigpool[i];
sequencelength += ptr->length;
nodelistlength += ptr->weight;
}
nodelistlength += ((distance-1)*(*c_number-1));
// consider the case when distance > 1
tempsequence = (char *) malloc(sizeof(char)*sequencelength);
presequence = (char *) malloc(sizeof(char)*sequencelength);
tempnodelist = (long *) malloc(sizeof(long)*nodelistlength);
prenodelist = (long *) malloc(sizeof(long)*nodelistlength);
for(i=0;i<(*c_number);i++) {
ptr = &supercontigpool[i];
if(ptr->fresh == 0)
continue;
samedirection = 1;
presequence = strncpy(presequence,ptr->sequence,ptr->length);
prenodelist = longncpy(prenodelist,ptr->sequenceseed,ptr->weight);
tempsequenceptr=ptr->length;
tempnodelistptr=ptr->weight;
current = extendnext(ptr, ptr, &samedirection, distance, presequence, &tempsequenceptr, prenodelist, &tempnodelistptr);
while(current != NULL) {
current->fresh = 0;
current = extendnext(ptr, current, &samedirection, distance, presequence, &tempsequenceptr, prenodelist, &tempnodelistptr);
}
tempsequenceptr=sequencelength-ptr->length;
tempnodelistptr=nodelistlength-ptr->weight;
strncpy(&tempsequence[tempsequenceptr],presequence,ptr->length);
longncpy(&tempnodelist[tempnodelistptr],prenodelist,ptr->weight);
samedirection = 1;
current = extendpre(ptr, ptr, &samedirection, distance, tempsequence, &tempsequenceptr, tempnodelist, &tempnodelistptr);
while(current != NULL) {
current->fresh = 0;
current = extendpre(ptr, current, &samedirection, distance, tempsequence, &tempsequenceptr, tempnodelist, &tempnodelistptr);
}
sequencelength -= ptr->length;
nodelistlength -= ptr->weight;
ptr->sequence = &tempsequence[sequencelength];
ptr->sequenceseed = &tempnodelist[nodelistlength];
ptr->fresh = 0;
ptrpool[p_number++] = ptr;
}
// free and rewind
free(presequence);
free(prenodelist);
//consider to printf a string s='abcd0'
//sequencelength need more p_number bytes
sequencelength=p_number;
nodelistlength=0;
tempsequenceptr=0;
tempnodelistptr=0;
// precount
for(i=0;i<p_number;i++) {
ptr = ptrpool[i];
ptr->reverseseed = (long *) i;
sequencelength += ptr->length;
nodelistlength += ptr->weight;
tempsequenceptr += ptr->prelength;
tempnodelistptr += ptr->nextlength;
}
// create copy data
presequence = (char *) malloc(sizeof(char)*sequencelength);
reversesequence = (char *) malloc(sizeof(char)*sequencelength);
prenodelist = (long *) malloc(sizeof(long)*nodelistlength);
pre = (supercontig **) malloc(sizeof(supercontig *)*tempsequenceptr);
predirection = (char *) malloc(sizeof(char)*tempsequenceptr);
next = (supercontig **) malloc(sizeof(supercontig *)*tempnodelistptr);
nextdirection = (char *) malloc(sizeof(char)*tempnodelistptr);
// start copy
sequencelength=0;
nodelistlength=0;
tempsequenceptr=0;
tempnodelistptr=0;
pool = (supercontig *) malloc(sizeof(supercontig)*p_number);
for(i=0;i<p_number;i++) {
current = &pool[i];
ptr = ptrpool[i];
current->length = ptr->length;
current->sequence = strncpy(&presequence[sequencelength],ptr->sequence,ptr->length);
current->reverse = getreversen(&reversesequence[sequencelength],ptr->sequence,ptr->length);
sequencelength += ptr->length;
presequence[sequencelength]=0;
reversesequence[sequencelength++]=0;
current->weight = ptr->weight;
current->sequenceseed = longncpy(&prenodelist[nodelistlength],ptr->sequenceseed,ptr->weight);
nodelistlength += ptr->weight;
current->reverseseed = (long *) i;
current->prelength = ptr->prelength;
current->pre = &pre[tempsequenceptr];
current->predirection = &predirection[tempsequenceptr];
for(j=0;j<ptr->prelength;j++) {
current->pre[j] = &pool[(long)((ptr->pre[j])->reverseseed)];
current->predirection[j] = ptr->predirection[j];
}
tempsequenceptr += ptr->prelength;
current->nextlength = ptr->nextlength;
current->next = &next[tempnodelistptr];
current->nextdirection = &nextdirection[tempnodelistptr];
for(j=0;j<ptr->nextlength;j++) {
current->next[j] = &pool[(long)((ptr->next[j])->reverseseed)];
current->nextdirection[j] = ptr->nextdirection[j];
}
tempnodelistptr += ptr->nextlength;
}
free(tempsequence);
free(tempnodelist);
free(ptrpool);
ptr = &freeptr;
free(ptr->pre);
free(ptr->predirection);
free(ptr->next);
free(ptr->nextdirection);
free(supercontigpool);
(*c_number) = p_number;
return pool;
}

supercontig *extendcontig(supercontig *supercontigpool, long *c_number)
{
supercontigpool = refreshcontig(supercontigpool,*c_number);
supercontigpool = linkcontig(supercontigpool,*c_number,1);
supercontigpool= mergecontig(supercontigpool,c_number,1);
return supercontigpool;
}

supercontig *extendcontigtrans(supercontig *supercontigpool, long *c_number)
{
supercontigpool = refreshcontig(supercontigpool,*c_number);
supercontigpool = linkcontigtrans(supercontigpool,*c_number,1);
supercontigpool= mergecontig(supercontigpool,c_number,1);
return supercontigpool;
}

contig *preprocessingcontig(kmer *nodepool, long n_number, long *c_number)
{
kmer *tempnode, *currentnode, *ntn, *ntp, *nt1, *nt2;
contig *contigpool, *copypool, *tempcontig, *copycontig;
char *systemstring, *copystring, *tempsequence, *tempreverse;
long *systemlonginteger, *copylonginteger, i, j, kmm, notideal, temp1, temp2, temp3, temp4, temp5, temp6;

contigpool= (contig *) malloc(sizeof(contig)*n_number);
systemstring=(char *) malloc(sizeof(char)*n_number*k_mer);
systemlonginteger=(long *)malloc(sizeof(long)*n_number);
tempsequence=(char *) malloc(sizeof(char)*k_mer);
tempreverse=(char *) malloc(sizeof(char)*k_mer);
j=0;
temp1=0;
temp2=0;
notideal=0;
kmm=k_mer-1;
for(i=0;i<n_number;i++) {
tempnode=&nodepool[i];
if(tempnode->fresh==3)
continue;
if(tempnode->fresh==0 || tempnode->fresh==2) {
tempcontig= &contigpool[j];
j+=1;
tempcontig->sequence= strncpy(&systemstring[temp1],tempnode->sequence,k_mer);
temp1+= k_mer;
tempcontig->sequenceseed= &systemlonginteger[temp2];
temp2+=1;
tempcontig->sequenceseed[0]=(long)tempnode;
tempcontig->length=k_mer;
tempcontig->weight=1;
}else {
tempnode->fresh=3;
tempcontig= &contigpool[j];
j+=1;
tempcontig->sequence= strncpy(&systemstring[temp1],tempnode->sequence,k_mer);
temp3=k_mer;
tempcontig->sequenceseed= &systemlonginteger[temp2];
tempcontig->sequenceseed[0]=(long)tempnode;
temp4=1;
tempsequence=strncpy(tempsequence,tempnode->sequence,k_mer);
currentnode=tempnode;
ntn=(kmer *)tempnode->reverseseed;
ntp=(kmer *)tempnode->sequenceseed;
while(ntn->fresh==1) {
nt1=(kmer *)ntn->reverseseed;
nt2=(kmer *)ntn->sequenceseed;
if(nt2 == tempnode) {
if(!strncmp(&tempsequence[1],ntn->sequence,kmm)) {
tempcontig->sequence[temp3++]=ntn->sequence[kmm];
tempsequence=strncpy(tempsequence,ntn->sequence,k_mer);
}else {
tempreverse=getreverse(tempreverse,ntn->sequence);
if(!strncmp(&tempsequence[1],tempreverse,kmm)) {
tempcontig->sequence[temp3++]=tempreverse[kmm];
tempsequence=strncpy(tempsequence,tempreverse,k_mer);
} else {
ntn->fresh=2;
notideal++;
break;
}
}
ntn->fresh=3;
tempcontig->sequenceseed[temp4++]=(long)ntn;
tempnode=ntn;
ntn=nt1;
}else if( nt1 == tempnode  ) {
if(!strncmp(&tempsequence[1],ntn->sequence,kmm)) {
tempcontig->sequence[temp3++]=ntn->sequence[kmm];
tempsequence=strncpy(tempsequence,ntn->sequence,k_mer);
}else {
tempreverse=getreverse(tempreverse,ntn->sequence);
if(!strncmp(&tempsequence[1],tempreverse,kmm)) {
tempcontig->sequence[temp3++]=tempreverse[kmm];
tempsequence=strncpy(tempsequence,tempreverse,k_mer);
} else {
ntn->fresh=2;
notideal++;
break;
}
}
ntn->fresh=3;
tempcontig->sequenceseed[temp4++]=(long)ntn;
tempnode=ntn;
ntn=nt2;
}else {
ntn->fresh=2;
notideal++;
break;
}
}// end while
tempcontig->weight=temp4;
tempnode=currentnode;
tempsequence=strncpy(tempsequence,tempnode->sequence,k_mer);
while(ntp->fresh==1) {
nt1=(kmer *)ntp->reverseseed;
nt2=(kmer *)ntp->sequenceseed;
if(nt1 == tempnode) {
if(!strncmp(tempsequence,&(ntp->sequence[1]),kmm)) {
tempcontig->sequence[temp3++]=ntp->sequence[0];
tempsequence=strncpy(tempsequence,ntp->sequence,k_mer);
}else {
tempreverse=getreverse(tempreverse,ntp->sequence);
if(!strncmp(tempsequence,&tempreverse[1],kmm)) {
tempcontig->sequence[temp3++]=tempreverse[0];
tempsequence=strncpy(tempsequence,tempreverse,k_mer);
} else {
ntp->fresh=2;
notideal++;
break;
}
}
ntp->fresh=3;
tempcontig->sequenceseed[temp4++]=(long)ntp;
tempnode=ntp;
ntp=nt2;
}else if( nt2 == tempnode  ) {
if(!strncmp(tempsequence,&(ntp->sequence[1]),kmm)) {
tempcontig->sequence[temp3++]=ntp->sequence[0];
tempsequence=strncpy(tempsequence,ntp->sequence,k_mer);
}else {
tempreverse=getreverse(tempreverse,ntp->sequence);
if(!strncmp(tempsequence,&tempreverse[1],kmm)) {
tempcontig->sequence[temp3++]=tempreverse[0];
tempsequence=strncpy(tempsequence,tempreverse,k_mer);
} else {
ntp->fresh=2;
notideal++;
break;
}
}
ntp->fresh=3;
tempcontig->sequenceseed[temp4++]=(long)ntp;
tempnode=ntp;
ntp=nt1;
}else {
ntp->fresh=2;
notideal++;
break;
}
}// end while
tempcontig->length=temp3;
temp1+=temp3;
temp2+=temp4;
}// end if
}// end for
*c_number=j;
// copy again and rewind
copypool=(contig *) malloc(sizeof(contig)*j);
copystring=(char *)malloc(sizeof(char)*(temp1+j));
copylonginteger=(long *)malloc(sizeof(long)*temp2);
temp1=0;
temp2=0;
for(i=0;i<j;i++) {
tempcontig=&contigpool[i];
copycontig=&copypool[i];
temp3=tempcontig->length;
copycontig->length=temp3;
copycontig->weight = temp3-kmm;
if(temp3==k_mer) {
copycontig->sequence= strncpy(&copystring[temp1],tempcontig->sequence,temp3);
temp1+=temp3;
copystring[temp1++]=0;
copycontig->sequenceseed=&copylonginteger[temp2++];
copycontig->sequenceseed[0]=tempcontig->sequenceseed[0];
} else {
tempsequence=tempcontig->sequence;
tempreverse=&copystring[temp1];
copycontig->sequence=tempreverse;
temp4=tempcontig->weight+kmm;
temp5=0;
for(temp6=temp3-1;temp6 >= temp4;temp6--)
tempreverse[temp5++]=tempsequence[temp6];
 strncpy(&tempreverse[temp5], tempsequence,temp4);
temp1+=temp3;
copystring[temp1++]=0;
temp3-=kmm;
temp4-=kmm;
copycontig->sequenceseed=&copylonginteger[temp2];
temp5=0;
for(temp6=temp3-1; temp6 >=temp4; temp6--) {
copycontig->sequenceseed[temp5++]=tempcontig->sequenceseed[temp6];
}
for(temp6=0; temp6 <temp4; temp6++) {
copycontig->sequenceseed[temp5++]=tempcontig->sequenceseed[temp6];
}
temp2 += temp5;
}//end if
}// end for
free(systemstring);
free(systemlonginteger);
free(contigpool);
return copypool;
}

contig *preprocessingcontigtrans(kmer *nodepool, long n_number, long *c_number)
{
kmer *tempnode, *currentnode, *ntn, *ntp, *nt1, *nt2;
contig *contigpool, *copypool, *tempcontig, *copycontig;
char *systemstring, *copystring, *tempsequence, *tempreverse;
long *systemlonginteger, *copylonginteger, i, j, kmm, notideal, temp1, temp2, temp3, temp4, temp5, temp6;
contigpool= (contig *) malloc(sizeof(contig)*n_number);
systemstring=(char *) malloc(sizeof(char)*n_number*k_mer);
systemlonginteger=(long *)malloc(sizeof(long)*n_number);
tempsequence=(char *) malloc(sizeof(char)*k_mer);
j=0;
temp1=0;
temp2=0;
notideal=0;
kmm=k_mer-1;
for(i=0;i<n_number;i++) {
tempnode=&nodepool[i];
if(tempnode->fresh==3)
continue;
if(tempnode->fresh==0 || tempnode->fresh==2) {
tempcontig= &contigpool[j];
j+=1;
tempcontig->sequence= strncpy(&systemstring[temp1],tempnode->sequence,k_mer);
temp1+= k_mer;
tempcontig->sequenceseed= &systemlonginteger[temp2];
temp2+=1;
tempcontig->sequenceseed[0]=(long)tempnode;
tempcontig->length=k_mer;
tempcontig->weight=1;
}else {
tempnode->fresh=3;
tempcontig= &contigpool[j];
j+=1;
tempcontig->sequence= strncpy(&systemstring[temp1],tempnode->sequence,k_mer);
temp3=k_mer;
tempcontig->sequenceseed= &systemlonginteger[temp2];
tempcontig->sequenceseed[0]=(long)tempnode;
temp4=1;
tempsequence=strncpy(tempsequence,tempnode->sequence,k_mer);
currentnode=tempnode;
ntn=(kmer *)tempnode->reverseseed;
ntp=(kmer *)tempnode->sequenceseed;
while(ntn->fresh==1) {
nt1=(kmer *)ntn->reverseseed;
nt2=(kmer *)ntn->sequenceseed;
if(nt2 == tempnode) {
if(!strncmp(&tempsequence[1],ntn->sequence,kmm)) {
tempcontig->sequence[temp3++]=ntn->sequence[kmm];
tempsequence=strncpy(tempsequence,ntn->sequence,k_mer);
}else{
ntn->fresh=2;
notideal++;
break;
}
ntn->fresh=3;
tempcontig->sequenceseed[temp4++]=(long)ntn;
tempnode=ntn;
ntn=nt1;
}else {
ntn->fresh=2;
notideal++;
break;
}
}// end while
tempcontig->weight=temp4;
tempnode=currentnode;
tempsequence=strncpy(tempsequence,tempnode->sequence,k_mer);
while(ntp->fresh==1) {
nt1=(kmer *)ntp->reverseseed;
nt2=(kmer *)ntp->sequenceseed;
if(nt1 == tempnode) {
if(!strncmp(tempsequence,&(ntp->sequence[1]),kmm)) {
tempcontig->sequence[temp3++]=ntp->sequence[0];
tempsequence=strncpy(tempsequence,ntp->sequence,k_mer);
}else {
ntp->fresh=2;
notideal++;
break;
}
ntp->fresh=3;
tempcontig->sequenceseed[temp4++]=(long)ntp;
tempnode=ntp;
ntp=nt2;
}else {
ntp->fresh=2;
notideal++;
break;
}
}// end while
tempcontig->length=temp3;
temp1+=temp3;
temp2+=temp4;
}// end if
}// end for
*c_number=j;
// copy again and rewind
copypool=(contig *) malloc(sizeof(contig)*j);
copystring=(char *)malloc(sizeof(char)*(temp1+j));
copylonginteger=(long *)malloc(sizeof(long)*temp2);
temp1=0;
temp2=0;
for(i=0;i<j;i++) {
tempcontig=&contigpool[i];
copycontig=&copypool[i];
temp3=tempcontig->length;
copycontig->length=temp3;
copycontig->weight = temp3-kmm;
if(temp3==k_mer) {
copycontig->sequence= strncpy(&copystring[temp1],tempcontig->sequence,temp3);
temp1+=temp3;
copystring[temp1++]=0;
tempnode=(kmer *)tempcontig->sequenceseed[0];
copycontig->sequenceseed=&copylonginteger[temp2];
copycontig->sequenceseed[0]=tempnode->weight;
tempnode->weight=temp2++;
} else {
tempsequence=tempcontig->sequence;
tempreverse=&copystring[temp1];
copycontig->sequence=tempreverse;
temp4=tempcontig->weight+kmm;
temp5=0;
for(temp6=temp3-1;temp6 >= temp4;temp6--)
tempreverse[temp5++]=tempsequence[temp6];
 strncpy(&tempreverse[temp5], tempsequence,temp4);
temp1+=temp3;
copystring[temp1++]=0;
temp3-=kmm;
temp4-=kmm;
copycontig->sequenceseed=&copylonginteger[temp2];
temp5=0;
for(temp6=temp3-1; temp6 >=temp4; temp6--) {
tempnode=(kmer *)tempcontig->sequenceseed[temp6];
copycontig->sequenceseed[temp5++]=tempnode->weight;
tempnode->weight=temp2++;
}
for(temp6=0; temp6 <temp4; temp6++) {
tempnode=(kmer *)tempcontig->sequenceseed[temp6];
copycontig->sequenceseed[temp5++]=tempnode->weight;
tempnode->weight=temp2++;
}
}//end if
}// end for
free(systemstring);
free(systemlonginteger);
free(contigpool);
return copypool;
}

 kmer *preprocessingsetting(contig *readpool, kmer *kmerpool, kmer *nodepool, long r_number, long k_number, long n_number)
{
long *tempptr, i, j, len;
kmer *nodetemp;
contig *readtemp;
for(i=0;i<r_number;i++) {
readtemp= &readpool[i];
len= readtemp->length +1 - k_mer;
tempptr= readtemp->sequenceseed;
// read.sequenceseed -> node,node,node
for(j=0; j< len; j++ ) {
tempptr[j]= ((kmer *)tempptr[j])->weight;
}
// node.sequenceseed -> n2 node.reverseseed ->n1
// read.sequenceseed -> node, read.reverseseed -> node,
len--;
for(j=1; j< len; j++ ) {
nodetemp= (kmer *)tempptr[j];
if(nodetemp->fresh ==2) {
nodetemp->sequenceseed =(long *) tempptr[j-1];
nodetemp->reverseseed =(long *) tempptr[j+1];
nodetemp->fresh =1;
}
}
readtemp->sequenceseed=(long *)tempptr[0];
readtemp->reverseseed=(long *)tempptr[len];
}
return nodepool;
}
//read.sequenceseed-> kmer, kmer, kmer
// node.sequenceseed -> kmer,kmer,kmer  node.weight -> len
// node.weight-> weight
//kmer.weight->node
// read.sequenceseed -> node,node,node
// node.sequenceseed -> n2 node.reverseseed ->n1
// read.sequenceseed -> node, read.reverseseed -> node,
//contig.sequenceseed-> node, node, node
//contig.sequenceseed-> node.weight, node.weight, node.weight
// node.weight -> node id
static PyObject* preprocessingcontigc(PyObject* self, PyObject* args)
{
//infile:read, outfile1:contig->sequence, outfile2: nodeweight, outfile3:readpool->node ID, file4: supercontig->pre and next
char *infile, *outfile1, *outfile2, *outfile3, *outfile4;
FILE *infptr, *outfptr1, *outfptr2, *outfptr3, *outfptr4;
kmer *kmerpool, *nodepool;
contig *readpool, *contigpool, *readtemp;
supercontig *supercontigpool, *supercontigtemp;
long i,j,r_number,k_number,n_number,c_number,temp1,temp2,temp3,temp4, *tempptr;
char *systemstring;

rdna['A']='T';
rdna['C']='G';
rdna['G']='C';
rdna['T']='A';
rdna['N']='N';
dti['A']=0;
dti['C']=1;
dti['G']=2;
dti['T']=3;

    if (!PyArg_ParseTuple(args, "iiiffsssss", &k_mer, &p_mer, &i_mer, &splitparameter, &idealerrorfraction, &infile, &outfile1, &outfile2, &outfile3, &outfile4))
        return NULL;

if (i_mer > max_i_mer)
 i_mer = max_i_mer;
//add
//printf("splitparameter: %lf\n",splitparameter);
//printf("idealerrorfraction: %lf\n",idealerrorfraction);
infptr=fopen( infile, "r+" );
r_number= detectfilen(infptr, &temp1);
readpool= (contig *) malloc(sizeof(contig) * r_number );
systemstring= (char *) malloc( sizeof(char) * 2*temp1);
temp2=0;
for(i=0; i<r_number; i++) {
readtemp=&readpool[i];
readtemp->sequence=fgetl(&systemstring[temp2] , &temp3, infptr);
temp2+= temp3;
readtemp->reverse= getreversen( &systemstring[temp2], readtemp->sequence,temp3);
temp2+= temp3;
readtemp->length=temp3;
readtemp->weight=1;
}
fclose(infptr);
//add
printf("Input reads, reads: %ld\n",r_number);
temp2=temp1-(r_number*(k_mer-1));
printf("K-mers in reads: %ld\n",temp2);
n_number=i_mer;
i_mer=k_mer;
if (i_mer > max_i_mer)
 i_mer = max_i_mer;
kmerpool=sbuildkpgraph(readpool,r_number,&k_number);
i_mer=n_number;
//add
printf("K-mers in k-mer set: %ld\n",k_number);
idealnumber= (long) ceil(((double)temp2)/((double)k_number));
//printf("idealnumber: %ld\n",idealnumber);
if(p_mer) {
temp1=k_number;
nodepool=buildkpgraph(kmerpool,k_number,&n_number);
kmerpool=adjustkmersequence(kmerpool,k_number);
//add
printf("Components of k-mers in k-mer set: %ld\n",n_number);
idealnumber= (long) ceil(((double)temp2)/((double)n_number));
//printf("idealnumber: %ld\n",idealnumber);
if(splitparameter==0.0 && idealerrorfraction==0.0)
idealnumber=0;
nodepool=splitnodes(nodepool,n_number,&temp1);
n_number=temp1;
idealnumber= (long) ceil(((double)temp2)/((double)n_number));
//add
printf("Split the nodes.\n");
printf("Nodes to build the de Bruijn graph: %ld\n",n_number);
//printf("idealnumber: %ld\n",idealnumber);
nodepool= preprocessingsetting(readpool, kmerpool, nodepool, r_number, k_number, n_number);
//add
//printf("preprocessing setting ok\n");
contigpool=preprocessingcontig(nodepool,n_number,&c_number);
//add
//printf("preprocessing contig ok c_number: %ld\n",c_number);
supercontigpool=createsupercontigbycontig(contigpool, c_number);
}else {
supercontigpool=createsupercontigbykmer(readpool, kmerpool, r_number, k_number);
c_number = k_number;
printf("Nodes to build the de Bruijn graph: %ld\n",k_number);
}
supercontigpool = extendcontig(supercontigpool, &c_number);
outfptr1=fopen(outfile1,"w+" );
outfptr2=fopen(outfile2,"w+" );
outfptr4=fopen(outfile4,"w+" );
temp2 = 0;
//printf("c_number: %ld\n",c_number);
for(i=0; i<c_number; i++) {
supercontigtemp=&supercontigpool[i];
//printf("contig %ld: length %ld, list %ld\n",i,supercontigtemp->length,supercontigtemp->weight);
fprintf(outfptr1, "%s\n", supercontigtemp->sequence);
temp1 = supercontigtemp->length+1-k_mer;
tempptr = supercontigtemp->sequenceseed;
for(j=0;j< temp1; j++) {
fprintf(outfptr2, "%ld,", ((kmer *)tempptr[j])->weight);
((kmer *)tempptr[j])->weight = temp2++;
}
for(j=0;j<supercontigtemp->prelength; j++) {
fprintf(outfptr4, "%ld,", (long)((supercontigtemp->pre[j])->reverseseed));
}
fprintf(outfptr4, "\t");
for(j=0;j<supercontigtemp->prelength; j++) {
fprintf(outfptr4, "%ld,", supercontigtemp->predirection[j]);
}
fprintf(outfptr4, "\t");
for(j=0;j<supercontigtemp->nextlength; j++) {
fprintf(outfptr4, "%ld,", (long)((supercontigtemp->next[j])->reverseseed));
}
fprintf(outfptr4, "\t");
for(j=0;j<supercontigtemp->nextlength; j++) {
fprintf(outfptr4, "%ld,", supercontigtemp->nextdirection[j]);
}
fprintf(outfptr4, "\n");
}
fclose(outfptr4);
fclose(outfptr2);
fclose(outfptr1);
//printf("\npast ok\n");
outfptr3=fopen(outfile3,"w+" );
for(i=0; i<r_number; i++) {
readtemp=&readpool[i];
fprintf(outfptr3, "%ld,%ld,",((kmer *)readtemp->sequenceseed)->weight, ((kmer *)readtemp->reverseseed)->weight);
}
fclose(outfptr3);
free(readpool);
free(kmerpool);
if(p_mer) {
free(nodepool);
free(contigpool);
}
free(supercontigpool);
free(systemstring);
Py_RETURN_NONE;
}

static PyObject* preprocessingcontigtransc(PyObject* self, PyObject* args)
{
//infile:read, outfile1:contig->sequence, outfile2: nodeweight, outfile3:readpool->node ID, file4: supercontig->pre and next
char *infile, *outfile1, *outfile2, *outfile3, *outfile4;
FILE *infptr, *outfptr1, *outfptr2, *outfptr3, *outfptr4;
kmer *kmerpool, *nodepool;
contig *readpool, *contigpool, *readtemp;
supercontig *supercontigpool, *supercontigtemp;
long i,j,r_number,k_number,n_number,c_number,temp1,temp2,temp3,temp4, *tempptr;
char *systemstring;

rdna['A']='T';
rdna['C']='G';
rdna['G']='C';
rdna['T']='A';
rdna['N']='N';
dti['A']=0;
dti['C']=1;
dti['G']=2;
dti['T']=3;

    if (!PyArg_ParseTuple(args, "iiiffsssss", &k_mer, &p_mer, &i_mer, &splitparameter, &idealerrorfraction, &infile, &outfile1, &outfile2, &outfile3, &outfile4))
        return NULL;

if (i_mer > max_i_mer)
 i_mer = max_i_mer;
//add
//printf("splitparameter: %lf\n",splitparameter);
//printf("idealerrorfraction: %lf\n",idealerrorfraction);
infptr=fopen( infile, "r+" );
r_number= detectfilen(infptr, &temp1);
readpool= (contig *) malloc(sizeof(contig) * r_number );
systemstring= (char *) malloc( sizeof(char) * 2*temp1);
temp2=0;
for(i=0; i<r_number; i++) {
readtemp=&readpool[i];
readtemp->sequence=fgetl(&systemstring[temp2] , &temp3, infptr);
temp2+= temp3;
readtemp->reverse= getreversen( &systemstring[temp2], readtemp->sequence,temp3);
temp2+= temp3;
readtemp->length=temp3;
readtemp->weight=1;
}
fclose(infptr);
//add
printf("Input reads, reads: %ld\n",r_number);
temp2=temp1-(r_number*(k_mer-1));
printf("K-mers in reads: %ld\n",temp2);
n_number=i_mer;
i_mer=k_mer;
if (i_mer > max_i_mer)
 i_mer = max_i_mer;
kmerpool=sbuildkpgraphtrans(readpool,r_number,&k_number);
i_mer=n_number;
//add
printf("K-mers in k-mer set: %ld\n",k_number);
idealnumber= (long) ceil(((double)temp2)/((double)k_number));
//printf("idealnumber: %ld\n",idealnumber);
if(p_mer) {
temp1=k_number;
nodepool=buildkpgraphtrans(kmerpool,k_number,&n_number);
kmerpool=adjustkmersequence(kmerpool,k_number);
//add
printf("Components of k-mers in k-mer set: %ld\n",n_number);
idealnumber= (long) ceil(((double)temp2)/((double)n_number));
//printf("idealnumber: %ld\n",idealnumber);
if(splitparameter==0.0 && idealerrorfraction==0.0)
idealnumber=0;
nodepool=splitnodes(nodepool,n_number,&temp1);
n_number=temp1;
idealnumber= (long) ceil(((double)temp2)/((double)n_number));
//add
printf("Split the nodes.\n");
printf("Nodes to build the de Bruijn graph: %ld\n",n_number);
//printf("idealnumber: %ld\n",idealnumber);
nodepool= preprocessingsetting(readpool, kmerpool, nodepool, r_number, k_number, n_number);
//add
//printf("preprocessing setting ok\n");
contigpool=preprocessingcontigtrans(nodepool,n_number,&c_number);
//add
//printf("preprocessing contig ok c_number: %ld\n",c_number);
supercontigpool=createsupercontigbycontig(contigpool, c_number);
}else {
supercontigpool=createsupercontigbykmer(readpool, kmerpool, r_number, k_number);
c_number = k_number;
printf("Nodes to build the de Bruijn graph: %ld\n",k_number);
}
supercontigpool = extendcontigtrans(supercontigpool, &c_number);
outfptr1=fopen(outfile1,"w+" );
outfptr2=fopen(outfile2,"w+" );
outfptr4=fopen(outfile4,"w+" );
temp2 = 0;
//printf("c_number: %ld\n",c_number);
for(i=0; i<c_number; i++) {
supercontigtemp=&supercontigpool[i];
//printf("contig %ld: length %ld, list %ld\n",i,supercontigtemp->length,supercontigtemp->weight);
fprintf(outfptr1, "%s\n", supercontigtemp->sequence);
temp1 = supercontigtemp->length+1-k_mer;
tempptr = supercontigtemp->sequenceseed;
for(j=0;j< temp1; j++) {
fprintf(outfptr2, "%ld,", ((kmer *)tempptr[j])->weight);
((kmer *)tempptr[j])->weight = temp2++;
}
for(j=0;j<supercontigtemp->prelength; j++) {
fprintf(outfptr4, "%ld,", (long)((supercontigtemp->pre[j])->reverseseed));
}
fprintf(outfptr4, "\t");
for(j=0;j<supercontigtemp->prelength; j++) {
fprintf(outfptr4, "%ld,", supercontigtemp->predirection[j]);
}
fprintf(outfptr4, "\t");
for(j=0;j<supercontigtemp->nextlength; j++) {
fprintf(outfptr4, "%ld,", (long)((supercontigtemp->next[j])->reverseseed));
}
fprintf(outfptr4, "\t");
for(j=0;j<supercontigtemp->nextlength; j++) {
fprintf(outfptr4, "%ld,", supercontigtemp->nextdirection[j]);
}
fprintf(outfptr4, "\n");
}
fclose(outfptr4);
fclose(outfptr2);
fclose(outfptr1);
//printf("\npast ok\n");
outfptr3=fopen(outfile3,"w+" );
for(i=0; i<r_number; i++) {
readtemp=&readpool[i];
fprintf(outfptr3, "%ld,%ld,",((kmer *)readtemp->sequenceseed)->weight, ((kmer *)readtemp->reverseseed)->weight);
}
fclose(outfptr3);
free(readpool);
free(kmerpool);
if(p_mer) {
free(nodepool);
free(contigpool);
}
free(supercontigpool);
free(systemstring);
Py_RETURN_NONE;
}

static PyObject* alignkpgraphc(PyObject* self, PyObject* args)
{
char *infile1, *infile2, *outfile1, *outfile2, *outfile3, *outfile4;
FILE *infptr1, *infptr2, *outfptr1, *outfptr2, *outfptr3, *outfptr4;
kmer *kmerpool, *kmertemp;
contig *readpool, *readtemp;
long *dgraph, *darray, *systemlonginteger1, *systemlonginteger2, *tempptr, *kmertempsequenceseed, *kmertempreverseseed;
long i,j, r_number, k_number,kp, pp, temp1, temp2, temp3, temp4, temp5,temp6,temp7, temp8;
char *systemstring1, *systemstring2, *kmertempsequence, *kmertempreverse;
rdna['A']='T';
rdna['C']='G';
rdna['G']='C';
rdna['T']='A';
rdna['N']='N';
dti['A']=0;
dti['C']=1;
dti['G']=2;
dti['T']=3;
dti['N']=0;

    if (!PyArg_ParseTuple(args, "iiissssss", &k_mer, &p_mer, &i_mer, &infile1, &infile2, &outfile1, &outfile2, &outfile3, &outfile4))
        return NULL;
if(larray<=k_mer) {
larray=k_mer+1;
carray=(long *)malloc(sizeof(long)*larray);
parray=(long *)malloc(sizeof(long)*larray);
}
if (i_mer > max_i_mer)
 i_mer = max_i_mer;
pp=p_mer+1;
kp=k_mer+1;


infptr1=fopen( infile1, "r+" );
r_number= detectfilen(infptr1, &temp8);
temp7=temp8-(r_number*(i_mer-1));
temp1=(1<<(i_mer*2))+1;
readpool= (contig *) malloc(sizeof(contig) * r_number );
dgraph= (long *) malloc(sizeof(long)*temp1 );
darray= (long *) malloc(sizeof(long) * temp7*2);
for(i=0; i<temp1; i++)
dgraph[i]=0;
systemstring1= (char *) malloc( sizeof(char) * temp8);
temp1=0;
systemlonginteger1= (long *) malloc( sizeof(long) * temp7);
temp2=0;
for(i=0; i<r_number; i++) {
readtemp=&readpool[i];
readtemp->sequence=fgetl(&systemstring1[temp1] , &temp6, infptr1);
temp1+=temp6;
readtemp->length=temp6;
temp6-= (i_mer-1);
readtemp->sequenceseed= &systemlonginteger1[temp2];
temp2+= temp6;
for(j=0;j<temp6;j++) {
temp4=stoi( &readtemp->sequence[j]);
readtemp->sequenceseed[j]=temp4;
dgraph[temp4]+=2;
}
}
fclose(infptr1);
dgraph=preprocessingdgraphmap(dgraph);
for(i=0; i<r_number; i++) {
temp6=readpool[i].length-(i_mer-1);
tempptr=readpool[i].sequenceseed;
for(j=0; j<temp6; j++) {
temp4=tempptr[j];
darray[--dgraph[temp4]]=j;
darray[--dgraph[temp4]]=i;
}
}
for(i=0; i<temp7; i++)
systemlonginteger1[i]= -1;
infptr2=fopen( infile2, "r+" );
k_number= detectfilen(infptr2, &temp1);
kmerpool= (kmer *) malloc(sizeof(kmer) * k_number );
systemstring2= (char *) malloc( sizeof(char) * kp * 2 * k_number );
temp1=0;
systemlonginteger2= (long *) malloc( sizeof(long) * pp * 2 * k_number );
temp2=0;
temp5=k_mer+3;
for(i=0; i<k_number; i++) {
kmertemp=&kmerpool[i];
kmertemp->sequence=fgets(&systemstring2[temp1] , temp5, infptr2);
kmertemp->sequence[k_mer]=0;
temp1+= kp;
kmertemp->reverse= getreverse( &systemstring2[temp1], kmertemp->sequence);
temp1+= kp;
kmertemp->sequenceseed= &systemlonginteger2[temp2];
temp2+= pp;
kmertemp->reverseseed= &systemlonginteger2[temp2];
temp2+= pp;
temp3=0;
for(j=0;j<pp;j++) {
kmertemp->sequenceseed[j]=stoi(&kmertemp->sequence[temp3]);
kmertemp->reverseseed[j]=stoi(&kmertemp->reverse[temp3]);
temp3 += i_mer;
}
}
fclose(infptr2);
temp1=0;
//  temp1 is used
outfptr1=fopen(outfile1,"w+" );
outfptr2=fopen(outfile2,"w+" );
outfptr3=fopen(outfile3,"w+" );
outfptr4=fopen(outfile4,"w+" );
fprintf(outfptr4,"%ld,",temp1);
temp7=k_mer-1;
for(i=0; i<k_number; i++) {
kmertempsequence=kmerpool[i].sequence;
kmertempreverse=kmerpool[i].reverse;
kmertempsequenceseed=kmerpool[i].sequenceseed;
kmertempreverseseed=kmerpool[i].reverseseed;
for(j=0; j<pp; j++ ){
temp3=kmertempsequenceseed[j];
temp2=dgraph[temp3+1]-dgraph[temp3];
if(!temp2)
continue;
tempptr=&darray[dgraph[temp3]];
temp3=j*i_mer;
for(temp4=0; temp4<temp2;temp4++) {
temp5=tempptr[temp4++];
readtemp=&readpool[temp5];
temp6=tempptr[temp4];
temp6-=temp3;
if((temp6<0) || (temp6 >= (readtemp->length -temp7))|| (readtemp->sequenceseed[temp6]== i))
continue;
if(aligndistancef(kmertempsequence, &readtemp->sequence[temp6])) {
fprintf(outfptr1, "%ld,", temp5);
fprintf(outfptr2, "%ld,", temp6);
fprintf(outfptr3, "%ld,", 1);
readtemp->sequenceseed[temp6]=i;
temp1++;
} // end if
}//end for
}//end for
for(j=0; j<pp; j++ ){
temp3=kmertempreverseseed[j];
temp2=dgraph[temp3+1]-dgraph[temp3];
if(!temp2)
continue;
tempptr=&darray[dgraph[temp3]];
temp3=j*i_mer;
for(temp4=0; temp4<temp2;temp4++) {
temp5=tempptr[temp4++];
readtemp= &readpool[temp5];
temp6=tempptr[temp4];
temp6-=temp3;
if((temp6<0) || (temp6 >= (readtemp->length -temp7))|| (readtemp->sequenceseed[temp6]== i))
continue;
if(aligndistancef(kmertempreverse, &readtemp->sequence[temp6])) {
fprintf(outfptr1, "%ld,", temp5);
fprintf(outfptr2, "%ld,", temp6);
fprintf(outfptr3, "%ld,", 0);
readtemp->sequenceseed[temp6]=i;
temp1++;
} // end if
}//end for
}//end for
fprintf(outfptr4,"%ld,",temp1);
}//end for
fclose(outfptr1);
fclose(outfptr2);
fclose(outfptr3);
fclose(outfptr4);
free(dgraph);
free(darray);
free(kmerpool);
free(readpool);
free(systemstring1);
free(systemstring2);
free(systemlonginteger1);
free(systemlonginteger2);
Py_RETURN_NONE;
}

static PyObject* alignkpgraphtransc(PyObject* self, PyObject* args)
{
char *infile1, *infile2, *outfile1, *outfile2, *outfile3;
FILE *infptr1, *infptr2, *outfptr1, *outfptr2, *outfptr3;
kmer *kmerpool, *kmertemp;
contig *readpool, *readtemp;
long *dgraph, *darray, *systemlonginteger1, *systemlonginteger2, *tempptr, *kmertempsequenceseed;
long i,j, r_number, k_number,kp, pp, temp1, temp2, temp3, temp4, temp5,temp6,temp7, temp8;
char *systemstring1, *systemstring2, *kmertempsequence;
rdna['A']='T';
rdna['C']='G';
rdna['G']='C';
rdna['T']='A';
rdna['N']='N';
dti['A']=0;
dti['C']=1;
dti['G']=2;
dti['T']=3;
dti['N']=0;

    if (!PyArg_ParseTuple(args, "iiisssss", &k_mer, &p_mer, &i_mer, &infile1, &infile2, &outfile1, &outfile2, &outfile3))
        return NULL;
if(larray<=k_mer) {
larray=k_mer+1;
carray=(long *)malloc(sizeof(long)*larray);
parray=(long *)malloc(sizeof(long)*larray);
}
if (i_mer > max_i_mer)
 i_mer = max_i_mer;
pp=p_mer+1;
kp=k_mer+1;


infptr1=fopen( infile1, "r+" );
r_number= detectfilen(infptr1, &temp8);
temp7=temp8-(r_number*(i_mer-1));
temp1=(1<<(i_mer*2))+1;
readpool= (contig *) malloc(sizeof(contig) * r_number );
dgraph= (long *) malloc(sizeof(long)*temp1 );
darray= (long *) malloc(sizeof(long) * temp7*2);
for(i=0; i<temp1; i++)
dgraph[i]=0;
systemstring1= (char *) malloc( sizeof(char) * temp8);
temp1=0;
systemlonginteger1= (long *) malloc( sizeof(long) * temp7);
temp2=0;
for(i=0; i<r_number; i++) {
readtemp=&readpool[i];
readtemp->sequence=fgetl(&systemstring1[temp1] , &temp6, infptr1);
temp1+=temp6;
readtemp->length=temp6;
temp6-= (i_mer-1);
readtemp->sequenceseed= &systemlonginteger1[temp2];
temp2+= temp6;
for(j=0;j<temp6;j++) {
temp4=stoi(&readtemp->sequence[j]);
readtemp->sequenceseed[j]=temp4;
dgraph[temp4]+= 2;
}
}
fclose(infptr1);
dgraph=preprocessingdgraphmap(dgraph);
for(i=0; i<r_number; i++) {
temp6=readpool[i].length-(i_mer-1);
tempptr=readpool[i].sequenceseed;
for(j=0; j<temp6; j++) {
temp4=tempptr[j];
darray[--dgraph[temp4]]=j;
darray[--dgraph[temp4]]=i;
}
}
for(i=0; i<temp7; i++)
systemlonginteger1[i]= -1;
infptr2=fopen( infile2, "r+" );
k_number= detectfilen(infptr2,&temp1);
kmerpool= (kmer *) malloc(sizeof(kmer) * k_number );
systemstring2= (char *) malloc( sizeof(char) * kp * k_number );
temp1=0;
systemlonginteger2= (long *) malloc( sizeof(long) * pp * k_number );
temp2=0;
temp5=k_mer+3;
for(i=0; i<k_number; i++) {
kmertemp=&kmerpool[i];
kmertemp->sequence=fgets(&systemstring2[temp1] , temp5, infptr2);
kmertemp->sequence[k_mer]=0;
temp1+= kp;
kmertemp->sequenceseed= &systemlonginteger2[temp2];
temp2+= pp;
temp3=0;
for(j=0;j<pp;j++) {
kmertemp->sequenceseed[j]=stoi(&kmertemp->sequence[temp3]);
temp3 += i_mer;
}
}
fclose(infptr2);
temp1=0;
//  temp1 is used
outfptr1=fopen(outfile1,"w+" );
outfptr2=fopen(outfile2,"w+" );
outfptr3=fopen(outfile3,"w+" );
fprintf(outfptr3,"%ld,",temp1);
temp7=k_mer-1;
for(i=0; i<k_number; i++) {
kmertempsequence=kmerpool[i].sequence;
kmertempsequenceseed=kmerpool[i].sequenceseed;
for(j=0; j<pp; j++ ){
temp3=kmertempsequenceseed[j];
temp2=dgraph[temp3+1]-dgraph[temp3];
if(!temp2)
continue;
tempptr=&darray[dgraph[temp3]];
temp3=j*i_mer;
for(temp4=0; temp4<temp2;temp4++) {
temp5=tempptr[temp4++];
readtemp=&readpool[temp5];
temp6=tempptr[temp4];
temp6-=temp3;
if((temp6<0) || (temp6 >= (readtemp->length -temp7))|| (readtemp->sequenceseed[temp6]== i))
continue;
if(aligndistancee(kmertempsequence, &readtemp->sequence[temp6])) {
fprintf(outfptr1, "%ld,", temp5);
fprintf(outfptr2, "%ld,", temp6);
readtemp->sequenceseed[temp6]=i;
temp1++;
} // end if
}//end for
}//end for
fprintf(outfptr3,"%ld,",temp1);
}//end for
fclose(outfptr1);
fclose(outfptr2);
fclose(outfptr3);
free(dgraph);
free(darray);
free(kmerpool);
free(readpool);
free(systemstring1);
free(systemstring2);
free(systemlonginteger1);
free(systemlonginteger2);
Py_RETURN_NONE;
}

static PyMethodDef kpgraphMethods[] = 
{
    {"indistance",  indistance, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

static PyMethodDef kpgraphMethods2[] = 
{
    {"inkpdistance",  inkpdistance, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

static PyMethodDef kpgraphMethods3[] = 
{
    {"buildkpgraphc",  buildkpgraphc, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

static PyMethodDef kpgraphMethods4[] = 
{
    {"buildkpgraphtransc",  buildkpgraphtransc, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

static PyMethodDef kpgraphMethods5[] = 
{
    {"mapkpgraphc",  mapkpgraphc, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

static PyMethodDef kpgraphMethods6[] = 
{
    {"mapkpgraphtransc",  mapkpgraphtransc, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

static PyMethodDef kpgraphMethods7[] = 
{
    {"preprocessingcontigc",  preprocessingcontigc, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

static PyMethodDef kpgraphMethods8[] = 
{
    {"alignkpgraphc",  alignkpgraphc, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

static PyMethodDef kpgraphMethods9[] = 
{
    {"alignkpgraphtransc",  alignkpgraphtransc, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

static PyMethodDef kpgraphMethods10[] = 
{
    {"aligndistance1",  aligndistance1, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

static PyMethodDef kpgraphMethods11[] = 
{
    {"aligndistance2",  aligndistance2, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

static PyMethodDef kpgraphMethods12[] = 
{
    {"aligndistance3",  aligndistance3, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

static PyMethodDef kpgraphMethods13[] = 
{
    {"aligndistance4",  aligndistance4, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

static PyMethodDef kpgraphMethods14[] = 
{
    {"aligndistance5",  aligndistance5, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

static PyMethodDef kpgraphMethods15[] = 
{
    {"aligndistance6",  aligndistance6, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

static PyMethodDef kpgraphMethods16[] = 
{
    {"preprocessingcontigtransc",  preprocessingcontigtransc, METH_VARARGS, "library description..."},
    {NULL, NULL, 0, NULL}
};

PyMODINIT_FUNC

initkpgraph(void)
{
    (void) Py_InitModule("kpgraph", kpgraphMethods);    
    (void) Py_InitModule("kpgraph", kpgraphMethods2);    
    (void) Py_InitModule("kpgraph", kpgraphMethods3);    
    (void) Py_InitModule("kpgraph", kpgraphMethods4);    
    (void) Py_InitModule("kpgraph", kpgraphMethods5);    
    (void) Py_InitModule("kpgraph", kpgraphMethods6);    
    (void) Py_InitModule("kpgraph", kpgraphMethods7);    
    (void) Py_InitModule("kpgraph", kpgraphMethods8);    
    (void) Py_InitModule("kpgraph", kpgraphMethods9);    
    (void) Py_InitModule("kpgraph", kpgraphMethods10);    
    (void) Py_InitModule("kpgraph", kpgraphMethods11);    
    (void) Py_InitModule("kpgraph", kpgraphMethods12);    
    (void) Py_InitModule("kpgraph", kpgraphMethods13);    
    (void) Py_InitModule("kpgraph", kpgraphMethods14);    
    (void) Py_InitModule("kpgraph", kpgraphMethods15);    
    (void) Py_InitModule("kpgraph", kpgraphMethods16);    
}