%
%   
%   profile_cgemm.m
%
%  give reference model and experimental model, four graphs are shown
% 
% 1. Gflop/s
% 2. performance ratio R
% 3. R( N = multiple of 8)
% 4. R( N = multiple of 64)
%
% example:
%		profile_cgemm_pair( '../data/GTX285/volkov/threads512.txt', 'volkov', '../data/GTX285/method1/threads320.txt' , 'method1') ;
%
%   reference model = volkov on GTX285
%		experimental model = method 1 on GTX285
%


OUTPUT_DIR = '../data/GTX285/' ;

profile_cgemm_pair( strcat(OUTPUT_DIR,'cublas/threads256.txt'), 'CUBLAS', strcat(OUTPUT_DIR,'volkov/threads256.txt') , 'volkov') ;

%profile_cgemm_pair( strcat(OUTPUT_DIR,'volkov/threads256.txt') , 'volkov', strcat(OUTPUT_DIR,'method1/threads320.txt') , 'method1') ;

%profile_cgemm_pair( strcat(OUTPUT_DIR,'volkov/threads256.txt') , 'volkov', strcat(OUTPUT_DIR,'method1_variant/threads320.txt') , 'method1 variant') ;

%profile_cgemm_pair( strcat(OUTPUT_DIR,'volkov/threads256.txt') , 'volkov', strcat(OUTPUT_DIR,'volkov_unroll1/threads320.txt') , 'volkov unroll 1') ;

%profile_cgemm_pair( strcat(OUTPUT_DIR,'volkov/threads256.txt') , 'volkov', strcat(OUTPUT_DIR,'volkov_unroll2/threads320.txt') , 'volkov unroll 2') ;

%profile_cgemm_pair( strcat(OUTPUT_DIR,'volkov/threads256.txt') , 'volkov', strcat(OUTPUT_DIR,'volkov_unroll4/threads256.txt') , 'volkov unroll 4') ;

%profile_cgemm_pair( strcat(OUTPUT_DIR,'volkov/threads256.txt') , 'volkov', strcat(OUTPUT_DIR,'volkov_unroll8/threads256.txt') , 'volkov unroll 8') ;

%profile_cgemm_pair( strcat(OUTPUT_DIR,'volkov/threads256.txt') , 'volkov', strcat(OUTPUT_DIR,'method2/threads320.txt') , 'method2') ;

%profile_cgemm_pair( strcat(OUTPUT_DIR,'volkov/threads256.txt') , 'volkov', strcat(OUTPUT_DIR,'method2_variant/threads320.txt') , 'method2 variant') ;

%profile_cgemm_pair( strcat(OUTPUT_DIR,'volkov/threads256.txt') , 'volkov', strcat(OUTPUT_DIR,'method3/threads320.txt') , 'method3') ;

%profile_cgemm_pair( strcat(OUTPUT_DIR,'volkov/threads256.txt') , 'volkov', strcat(OUTPUT_DIR,'method3_variant/threads320.txt') , 'method3 variant') ;

%profile_cgemm_pair( strcat(OUTPUT_DIR,'volkov/threads256.txt') , 'volkov', strcat(OUTPUT_DIR,'method4/threads320.txt') , 'method4') ;