
/*
 *  objective: in page 21, HandTunedCgemm_2010_v1.pdf, validity of cudasm is checked
 *		by comparing to binary file generated by nvcc
 *
 *		in order to compare two binary file (.cubin), we would remove its header,
 *      then use UNIX command "diff" to show difference between them.
 *
 *      However we work on windows and file format of windows would put a carrige return
 *      after new line character. 
 *
 *		The simplified method is to remove all blanks in these two files. 
 *		That is purpose of function "remove_blank"
 *
 *  usage:
 *		suppose one wants to compare from_nvcc.cubin and from_cudasm.cubin, then 
 *
 *   step 1:
 *			remove_blank( "../volkov/from_nvcc.cubin", "from_nvcc_noblank.cubin" ) ;
 *			remove_blank( "../volkov/from_cudasm.cubin", "from_cudasm_noblank.cubin" ) ;
 *
 *   step 2:
 *          diff from_nvcc_noblank.cubin  from_cudasm_noblank.cubin
 *
 */


#include <stdio.h>
#include <string.h>
#include <stdlib.h>

void blank_out( char *s, char *t ) ;

/*
 *  input file "inFile" is binary file without header
 *	each line is either two 64-bit binary code or one 64-bit binary code	
 *
 *  we remove blanks, only keep binary code itself into output file "outFile"
 *
 */
void remove_blank( char *inFile, char *outFile )
{
	
	FILE *fin = fopen(inFile, "r") ;
	if ( NULL == fin ){
		printf("input file %s does not exist\n", inFile);
		exit(1) ;
	}

	
	FILE *fout = fopen(outFile, "w") ;
	if ( NULL == fout ){
		printf("output file %s does not exist\n", outFile);
		exit(1) ;
	}

	char wordline[256] ;
	char target[256] ;

	while( NULL != fgets(wordline, 256, fin) ){
		blank_out( wordline, target ) ;
		fprintf(fout, "%s\n", target );
	}

	fclose( fin ) ;

	fclose( fout ) ;
}


void blank_out( char *s, char *t )
{
	int i ;
	int copy_len ; 

	size_t len = strlen( s ) ;

	for( i = 0 ; i < len ; i++){
		if ( ( ' ' == *s) || ( '\t' == *s ) ){
			s++ ;
		}else{
			break ;
		}
	}

	if ( 43 < len ){
// two 64-bit instructions
		copy_len = 43 ; 
	}else if ( 22 < len ){
// only one 64-bit instruction
		copy_len = 21 ; 
	}else{
// }
		copy_len = 1 ; 
	} 

	for( i = 0 ; i < copy_len ; i++){
		*t = *s ;
		s++ ;
		t++ ;
	}
	*t = '\0' ;
	 
}