%
%  
%   compare_GT200.m
%
%  compare method 1 on TeslaC1060, GTX285 and GTX295
%
%

[volkov_TeslaC1060, method1_TeslaC1060] = profile_sgemm_pair( '../data/TeslaC1060/volkov/threads512.txt', 'volkov', '../data/TeslaC1060/method1/variant_threads320.txt' , 'method1(variant)') ;
N = volkov_TeslaC1060(:,1) ;
volkov_flops = volkov_TeslaC1060(:,3) ;
method1_TeslaC1060_flops = method1_TeslaC1060(:,3) ;

[volkov_GTX285, method1_GTX285] = profile_sgemm_pair( '../data/GTX285/volkov/threads512.txt', 'volkov', '../data/GTX285/method1/variant_threads320.txt' , 'method1(variant)') ;
method1_GTX285_flops = method1_GTX285(:,3) ;

[volkov_GTX295, method1_GTX295] = profile_sgemm_pair( '../data/GTX295/volkov/threads512.txt', 'volkov', '../data/GTX295/method1/variant_threads320.txt' , 'method1(variant)') ;
method1_GTX295_flops = method1_GTX295(:,3) ;


N_64 = 1024:64:max(N) ;
I_64 = extract_index( N, N_64 ) ;
figure(5)
	plot(N(I_64), method1_TeslaC1060_flops ( I_64 ), '-') ;
	hold on
		plot(N(I_64), method1_GTX285_flops ( I_64 ) , '-xr' ) ;
		plot(N(I_64), method1_GTX295_flops ( I_64 ) , '-.m' ) ;
		plot(N(I_64), volkov_flops( I_64 ) , ':k' ) ;
	hold off
	xlabel('N') ;
	legend( 'TeslaC1060', 'GTX285', 'GTX295', 'volkov(TeslaC1060)') ;
	axis([1000 4096 250 650]) ;
	title( 'Gflop/s, N = multiple of 64' ,'fontsize', 12 ) ;	

max_method1_TeslaC1060_flops = max( method1_TeslaC1060_flops ) 
max_method1_GTX285_flops = max( method1_GTX285_flops ) 
max_method1_GTX295_flops = max( method1_GTX295_flops ) 
max_volkov_flops = max( volkov_flops ) 
